/*
 * Grdc - GTK+/Gnome Remote Desktop Client
 * Copyright (C) 2009 - Vic Lee 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, 
 * Boston, MA 02111-1307, USA.
 */
 

#ifndef __GRDCSCALER_H__
#define __GRDCSCALER_H__

G_BEGIN_DECLS

#define GRDC_TYPE_SCALER               (grdc_scaler_get_type ())
#define GRDC_SCALER(obj)               (G_TYPE_CHECK_INSTANCE_CAST ((obj), GRDC_TYPE_SCALER, GrdcScaler))
#define GRDC_SCALER_CLASS(klass)       (G_TYPE_CHECK_CLASS_CAST ((klass), GRDC_TYPE_SCALER, GrdcScalerClass))
#define GRDC_IS_SCALER(obj)            (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GRDC_TYPE_SCALER))
#define GRDC_IS_SCALER_CLASS(klass)    (G_TYPE_CHECK_CLASS_TYPE ((klass), GRDC_TYPE_SCALER))
#define GRDC_SCALER_GET_CLASS(obj)     (G_TYPE_INSTANCE_GET_CLASS ((obj), GRDC_TYPE_SCALER, GrdcScalerClass))

typedef struct _GrdcScalerPriv GrdcScalerPriv;

typedef struct _GrdcScaler
{
    GtkTable table;

    gint hscale;
    gint vscale;
    gboolean aspectscale;

    GrdcScalerPriv *priv;
} GrdcScaler;

typedef struct _GrdcScalerClass
{
    GtkTableClass parent_class;

    void (* scaled) (GrdcScaler *scaler);
} GrdcScalerClass;

GType grdc_scaler_get_type (void) G_GNUC_CONST;

GtkWidget* grdc_scaler_new (void);

void grdc_scaler_set (GrdcScaler *scaler, gint hscale, gint vscale, gboolean chained);

void grdc_scaler_set_draw_value (GrdcScaler *scaler, gboolean draw_value);

G_END_DECLS

#endif  /* __GRDCSCALER_H__  */

