C Copyright 2005-2007 ECMWF
C 
C Licensed under the GNU Lesser General Public License which
C incorporates the terms and conditions of version 3 of the GNU
C General Public License.
C See LICENSE and gpl-3.0.txt for details.
C
C  Fortran 77  Implementation: print_data_fortran
C
C  Description: prints all the data contained in a grib file
C
C  Author: Enrico Fucile <enrico.fucile@ecmwf.int>
C
C
C
      program print_data_fortran
      implicit none
      integer maxNumberOfValues
      parameter( maxNumberOfValues = 100000 )
      include 'grib_api_f77.h'
      integer ifile
      integer iret
      integer igrib
      integer i
      real*8 values(maxNumberOfValues)
      integer*4 numberOfValues
      real*8 average
      real*8 max
      real*8 min
      character*256 error
      integer*4 size

      size=maxNumberOfValues
      ifile=5

      iret=grib_open_file(ifile
     X,'../../data/constant_field.grib1','r')
      call grib_check(iret)

C     a new grib message is loaded from file
C     igrib is the grib id to be used in subsequent calls
      call grib_check( grib_new_from_file(ifile,igrib) )


C     get the size of the values array
      call grib_check(grib_get_size(igrib,'values',numberOfValues))
      if ( numberOfValues .gt. maxNumberOfValues ) then
        write(*,*)'ERROR: maxNumberOfValues too small numberOfValues=',
     XnumberOfValues
	    stop
      endif

C     get data values
      call grib_check(grib_get_real8_array(igrib,'values',values,size))
      if ( size .ne. numberOfValues ) then
        write(*,*) 'ERROR: wrong numberOfValues'
        stop
      endif

      do i=1,numberOfValues
        write(*,*)'  ',i,values(i)
      enddo

      average =average / numberOfValues

      write(*,*)numberOfValues,' values found '

      call grib_check(grib_get_real8(igrib,'max',max))
      write(*,*) 'max=',max
      call grib_check(grib_get_real8(igrib,'min',min))
      write(*,*) 'min=',min
      call grib_check(grib_get_real8(igrib,'average',average))
      write(*,*) 'average=',average

      call grib_check(grib_release(igrib))

      call grib_check(grib_close_file(ifile))

      end
