C Copyright 2005-2007 ECMWF
C 
C Licensed under the GNU Lesser General Public License which
C incorporates the terms and conditions of version 3 of the GNU
C General Public License.
C See LICENSE and gpl-3.0.txt for details.
C
C
C  Fortran 77 Implementation: set_fortran
C
C  Description: how to set pv  values.
C
C
C  Author: Enrico Fucile <enrico.fucile@ecmwf.int>
C
C
C
      program set
      implicit none
      include 'grib_api_f77.h'
      integer err
      integer infile,outfile
      integer igrib,iret
      character*256 error
      real*8 pv
      integer pvsize
      dimension pv(4)

      pvsize=4
      infile=5
      outfile=6

      call grib_check(grib_open_file(infile
     X,'../../data/regular_latlon_surface.grib1','r'))

      call grib_check(grib_open_file(outfile,'out.grib1','w'))

C     a new grib message is loaded from file
C     igrib is the grib id to be used in subsequent calls
      call grib_check(grib_new_from_file(infile,igrib))

      call grib_check(grib_set_int(igrib,'PVPresent',1))
      call grib_check(grib_set_real8_array(igrib,'pv',pv,pvsize))

C     write modified message to a file
      call grib_check(grib_write(igrib,outfile))

      call grib_check(grib_release(igrib))

      call grib_check(grib_close_file(infile))

      call grib_check(grib_close_file(outfile))

      end
