#!/usr/bin/perl
use strict;

open(A,"<grib_api.h") or die "grib_api.txt: $!";
my @H = <A>;

open(AI,"<grib_api_internal.h") or die "grib_api_internal.txt: $!";
my @HI = <AI>;

open(H,">grib_api.h.new")    or die "grib_api.h.new: $!";

open(HI,">grib_api_internal.h.new")    or die "grib_api_internal.h.new: $!";

foreach my $h (@H)
{
  last if($h =~ /This part is automatically generated/);
  print H $h;
}

foreach my $h (@HI)
{
  last if($h =~ /This part is automatically generated/);
  print HI $h;
}


open(IN,"<grib_errors.txt") or die "grib_errors.txt: $!";
open(INI,"<grib_errors_internal.txt") or die "grib_errors_internal.txt: $!";

open(C,">grib_errors.c.new")    or die "grib_errors.c.new: $!";

print H <<"EOF";
/* This part is automatically generated by $0, do not edit */
#ifndef grib_errors_H
#define grib_errors_H
EOF

print HI <<"EOF";
/* This part is automatically generated by $0, do not edit */
#ifndef grib_errors_internal_H
#define grib_errors_internal_H
EOF

print C <<"EOF";
/* This file is automatically generated by $0, do not edit */

#include "grib_api.h"

static const char *errors[] = {
EOF

my $code = 0;
while(<IN>) {
  next unless(/^GRIB_/);
  chomp;
  my ($name,$text) = split(" ",$_,2);
  print H "/** $text */\n";
  print H "#define $name\t\t$code\n";
  print C "\"$text\",\t\t/* $code $name */\n";

  $code--;
}

my $code = 1;
while(<INI>) {
  next unless(/^GRIB_/);
  chomp;
  my ($name,$text) = split(" ",$_,2);
  print HI "/** $text */\n";
  print HI "#define $name\t\t$code\n";
  print C "\"$text\",\t\t/* $code $name */\n";

  $code++;
}

print HI <<"EOF";
#endif
EOF

print H <<"EOF";
#endif
EOF

print C <<"EOF";
};

#define NUMBER(a) sizeof(a)/sizeof(a[0])

const char* grib_get_error_message(int code)
{
  code = -code;
  if(code <0 || code >= NUMBER(errors)) {
    static char mess[80];
    sprintf(mess,"Unknow error %d",code);
    return mess;
    }
  return errors[code];
}

void grib_check(const char* call,const char*  file,int line,int e,const char* msg)
{
    if(e) {
        fprintf(stderr,"%s at line %d: %s failed: %s",file,line, call,grib_get_error_message(e));
        if (msg) fprintf(stderr," (%s)",msg);
        printf("\\n");
        exit(1);
    }
}

void grib_fail(const char* expr,const char*  file,int line) {
   fprintf(stderr,"%s at line %d: assertion failure Assert(%s)",file,line,expr);
   abort();
}

EOF

close(HI) or die "grib_api.h.new: $!";
close(H) or die "grib_api.h.new: $!";
close(C) or die "grib_errors.c.new: $!";
