/**
* Copyright 2005-2007 ECMWF
* 
* Licensed under the GNU Lesser General Public License which
* incorporates the terms and conditions of version 3 of the GNU
* General Public License.
* See LICENSE and gpl-3.0.txt for details.
*/

#include "grib_api_internal.h"
/* 
   This is used by make_class.pl

   START_CLASS_DEF
   CLASS      = accessor
   SUPER      = grib_accessor_class_g1area
   IMPLEMENTS = unpack_string
   END_CLASS_DEF

 */

/* START_CLASS_IMP */

/*

Don't edit anything between START_CLASS_IMP and END_CLASS_IMP
Instead edit values between START_CLASS_DEF and END_CLASS_DEF
or edit "accessor.class" and rerun ./make_class.pl

*/

static int unpack_string (grib_accessor*, char*, size_t *len);
static void init_class(grib_accessor_class*);

typedef struct grib_accessor_g1domain {
    grib_accessor          att;
/* Members defined in gen */
/* Members defined in double */
/* Members defined in g1area */
	const char* laf;
	const char* lof;
	const char* lal;
	const char* lol;
	const char* div;
/* Members defined in g1domain */
} grib_accessor_g1domain;

extern grib_accessor_class* grib_accessor_class_g1area;

static grib_accessor_class _grib_accessor_class_g1domain = {
    &grib_accessor_class_g1area,                      /* super                     */
    "g1domain",                      /* name                      */
    sizeof(grib_accessor_g1domain),  /* size                      */
    0,                           /* inited */
    &init_class,                 /* init_class */
    0,                       /* init                      */
    0,                  /* post_init                      */
    0,                    /* free mem                       */
    0,                       /* describes himself         */
    0,                /* get length of section     */
    0,                /* get number of values      */
    0,                 /* get number of bytes      */
    0,                /* get offset to bytes           */
    0,            /* get native type               */
    0,                /* get sub_section                */
    0,               /* grib_pack procedures long      */
    0,               /* grib_pack procedures long      */
    0,                  /* grib_pack procedures long      */
    0,                /* grib_unpack procedures long    */
    0,                /* grib_pack procedures double    */
    0,              /* grib_unpack procedures double  */
    0,                /* grib_pack procedures string    */
    &unpack_string,              /* grib_unpack procedures string  */
    0,                 /* grib_pack procedures bytes     */
    0,               /* grib_unpack procedures bytes   */
    0,            /* pack_expression */
    0,              /* notify_change   */
    0,                /* update_size   */
    0,            /* preferred_size   */
    0,                    /* resize   */
    0,      /* nearest_smaller_value */
    0,                       /* next accessor    */
    0,                    /* compare vs. another accessor   */
    0,             /* unpack only ith value          */
};


grib_accessor_class* grib_accessor_class_g1domain = &_grib_accessor_class_g1domain;


static void init_class(grib_accessor_class* c)
{
	c->dump	=	(*(c->super))->dump;
	c->next_offset	=	(*(c->super))->next_offset;
	c->value_count	=	(*(c->super))->value_count;
	c->byte_count	=	(*(c->super))->byte_count;
	c->byte_offset	=	(*(c->super))->byte_offset;
	c->get_native_type	=	(*(c->super))->get_native_type;
	c->sub_section	=	(*(c->super))->sub_section;
	c->pack_missing	=	(*(c->super))->pack_missing;
	c->is_missing	=	(*(c->super))->is_missing;
	c->pack_long	=	(*(c->super))->pack_long;
	c->unpack_long	=	(*(c->super))->unpack_long;
	c->pack_double	=	(*(c->super))->pack_double;
	c->unpack_double	=	(*(c->super))->unpack_double;
	c->pack_string	=	(*(c->super))->pack_string;
	c->pack_bytes	=	(*(c->super))->pack_bytes;
	c->unpack_bytes	=	(*(c->super))->unpack_bytes;
	c->pack_expression	=	(*(c->super))->pack_expression;
	c->notify_change	=	(*(c->super))->notify_change;
	c->update_size	=	(*(c->super))->update_size;
	c->preferred_size	=	(*(c->super))->preferred_size;
	c->resize	=	(*(c->super))->resize;
	c->nearest_smaller_value	=	(*(c->super))->nearest_smaller_value;
	c->next	=	(*(c->super))->next;
	c->compare	=	(*(c->super))->compare;
	c->unpack_double_element	=	(*(c->super))->unpack_double_element;
}
/* END_CLASS_IMP */

/*************** This will be in a file ***************/
static struct {
	long north;
	long west;
	long south;
	long east;
	char name;

} domain[] = {

	/* Clusters && Tubes */

	{70000, 332500, 40000, 10000, 'a'},
	{72500,      0, 50000, 45000, 'b'},
	{57500, 345000, 32500, 17500, 'c'},
	{57500,   2500, 32500, 42500, 'd'},
	{75000, 340000, 30000, 45000, 'e'},
	{60000, 310000, 40000,     0, 'f'},
};

/*************** end of file ***************/

static int    unpack_string(grib_accessor* a, char* val, size_t *len)
{   
	grib_accessor_g1domain* self = (grib_accessor_g1domain*)a;
	int ret = 0;
	int i = 0;

	double laf,lof,lal,lol;

	ret = grib_get_double_internal(a->parent->h, self->laf,&laf);
	if(ret)return ret;

	ret = grib_get_double_internal(a->parent->h, self->lof,&lof);
	if(ret) return ret;

	ret = grib_get_double_internal(a->parent->h, self->lal,&lal);
  if(ret) return ret;

	ret = grib_get_double_internal(a->parent->h, self->lol,&lol);
  if(ret) return ret;


	if(*len < 60)
	{
		grib_context_log(a->parent->h->context, GRIB_LOG_ERROR, " Buffer too smalle for %s (%d) ", a->name ,*len);
		len = 0;
		return GRIB_BUFFER_TOO_SMALL;
	}

	for(i = 0; i < 6; ++i)
	{
		if(domain[i].north == laf && domain[i].west == lof && domain[i].south == lal && domain[i].east == lol)
		{
			sprintf(val,"%c",domain[i].name);
			len[0] = strlen(val);
			return GRIB_SUCCESS;
		}
	}

	sprintf(val,"N:%3.5f W:%3.5f S:%3.5f E:%3.5f",((float)laf),((float)lof),((float)lal),((float)lol));

	len[0] = strlen(val);
	return GRIB_SUCCESS;
}

