/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */
/*
  gnome-hamlib-rig.c: Gtk+/Gnome widget that contains all implemented
                      hamlib RIG controls. See the API documentation
		      for details.

  Copyright (C)  2002  Alexandru Csete.

  Authors: Alexandru Csete <csete@users.sourceforge.net>

  Comments, questions and bugreports should be submitted via
  http://sourceforge.net/projects/groundstation/
  More details can be found at http://groundstation.sourceforge.net/
 
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the
          Free Software Foundation, Inc.,
	  59 Temple Place, Suite 330,
	  Boston, MA  02111-1307
	  USA
*/

#ifndef GNOME_HAMLIB_RIG_H
#define GNOME_HAMLIB_RIG_H

#include <gtk/gtkwidget.h>
#include <gtk/gtkvbox.h>
#include <gdk/gdk.h>
#include <libgnome/gnome-defs.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <gdk-pixbuf/gnome-canvas-pixbuf.h>
#include <hamlib/rig.h>

BEGIN_GNOME_DECLS


#define GNOME_TYPE_HAMLIB_RIG            (gnome_hamlib_rig_get_type ())
#define GNOME_HAMLIB_RIG(obj)            (GTK_CHECK_CAST ((obj), GNOME_TYPE_HAMLIB_RIG, GnomeHamlibRig))
#define GNOME_HAMLIB_RIG_CLASS(klass)    (GTK_CHECK_CLASS_CAST ((klass), GNOME_TYPE_HAMLIB_RIG, GnomeHamlibRigClass))
#define GNOME_IS_HAMLIB_RIG(obj)         (GTK_CHECK_TYPE ((obj), GNOME_TYPE_HAMLIB_RIG))
#define GNOME_IS_HAMLIB_RIG_CLASS(klass) (GTK_CHECK_CLASS_TYPE ((klass), GNOME_TYPE_HAMLIB_RIG))


typedef struct _GnomeHamlibRig      GnomeHamlibRig;
typedef struct _GnomeHamlibRigClass GnomeHamlibRigClass;

struct _GnomeHamlibRig {
	GtkVBox vbox;
	
	GtkWidget *power;                                /* power button */
	GtkWidget *mode;                                 /* mode selector */
	GtkWidget *filter;                               /* filter selector */
	GtkWidget *agc;                                  /* AGC selector */

	/* These are kept "public" so users can access them */
	GtkWidget *vbox1;         /* vertical box for power, mode, filter etc... */
	GtkWidget *hbox1;                                /* upper horizontal box */

	GtkWidget *canvas;                               /* LCD display */
	GdkColor lcdbg,lcdfg;                            /* canvas colors */
	GdkPixbuf *digits_normal[12],*digits_small[12];  /* digit pixmaps */
	GnomeCanvasItem *main_qrg[12];                   /* canvas digits */

	GtkWidget *af,*rf,*nr,*sql,*apf;                 /* Level settings */

	RIG *rig;              /* Hamlib RIG structure */
	guint64 freq1;         /* current frequency shown on display */
	guint freqtimer_id;    /* The ID of the frequency readback timer */
	guint slidertimer_id;  /* The ID of the slider readback timer */
	guint misctimer_id;    /* The ID of the "other" readback timer */
	guint32 freqtimer_val;
	guint32 slidertimer_val;
	guint32 misctimer_val;
};

struct _GnomeHamlibRigClass {
	GtkVBoxClass parent_class;
};


guint      gnome_hamlib_rig_get_type         (void);

/* Standard API funtions */
GtkWidget *gnome_hamlib_rig_new              (guint rigid, const gchar *port);
gint       gnome_hamlib_rig_get_power        (GnomeHamlibRig *ghr, gint *power);
gint       gnome_hamlib_rig_set_power        (GnomeHamlibRig *ghr, gint power);
gint       gnome_hamlib_rig_get_mode         (GnomeHamlibRig *ghr, gint *mode);
gint       gnome_hamlib_rig_set_mode         (GnomeHamlibRig *ghr, gint mode);
gint       gnome_hamlib_rig_get_filter       (GnomeHamlibRig *ghr, gint *filter);
gint       gnome_hamlib_rig_set_filter       (GnomeHamlibRig *ghr, gint filter);
gint       gnome_hamlib_rig_get_agc          (GnomeHamlibRig *ghr, gint *agc);
gint       gnome_hamlib_rig_set_agc          (GnomeHamlibRig *ghr, gint agc);
gfloat     gnome_hamlib_rig_get_af           (GnomeHamlibRig *ghr);
gint       gnome_hamlib_rig_set_af           (GnomeHamlibRig *ghr, gfloat af);
gfloat     gnome_hamlib_rig_get_rf           (GnomeHamlibRig *ghr);
gint       gnome_hamlib_rig_set_rf           (GnomeHamlibRig *ghr, gfloat rf);
gfloat     gnome_hamlib_rig_get_nr           (GnomeHamlibRig *ghr);
gint       gnome_hamlib_rig_set_nr           (GnomeHamlibRig *ghr, gfloat nr);
gfloat     gnome_hamlib_rig_get_sql          (GnomeHamlibRig *ghr);
gint       gnome_hamlib_rig_set_sql          (GnomeHamlibRig *ghr, gfloat sql);
gfloat     gnome_hamlib_rig_get_apf          (GnomeHamlibRig *ghr);
gint       gnome_hamlib_rig_set_apf          (GnomeHamlibRig *ghr, gfloat apf);
guint64    gnome_hamlib_rig_get_freq         (GnomeHamlibRig *ghr);
gint       gnome_hamlib_rig_set_freq         (GnomeHamlibRig *ghr, guint64 freq);

/* Readback timers */
gint       gnome_hamlib_rig_get_freq_timeout   (GnomeHamlibRig *ghr);
gint       gnome_hamlib_rig_set_freq_timeout   (GnomeHamlibRig *ghr, guint timeout);
gint       gnome_hamlib_rig_get_slider_timeout (GnomeHamlibRig *ghr);
gint       gnome_hamlib_rig_set_slider_timeout (GnomeHamlibRig *ghr, guint timeout);
gint       gnome_hamlib_rig_get_misc_timeout   (GnomeHamlibRig *ghr);
gint       gnome_hamlib_rig_set_misc_timeout   (GnomeHamlibRig *ghr, guint timeout);

END_GNOME_DECLS

#endif
