/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */
/*
  grig-config.c:  Gnome RIG configuration module.

  Copyright (C)  2002  Alexandru Csete.

  Authors: Alexandru Csete <csete@users.sourceforge.net>

  Comments, questions and bugreports should be submitted via
  http://sourceforge.net/projects/groundstation/
  More details can be found at http://groundstation.sourceforge.net/
 
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the
          Free Software Foundation, Inc.,
	  59 Temple Place, Suite 330,
	  Boston, MA  02111-1307
	  USA
*/

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gnome.h>
#include <gconf/gconf.h>
#include <gconf/gconf-client.h>
#include <hamlib/rig.h>
#include "grig-config.h"
#include "grig-config-general.h"
#include "grig-config-loc.h"
#include "grig-config-rig.h"
#include "grig-config-rot.h"


/* convenient page numbering. Add pages
   in the same order.
*/
enum cfgpnum {
/*  	GRIG_CONFIG_PAGE_GENERAL = 0, */
/*  	GRIG_CONFIG_PAGE_LOC, */
	GRIG_CONFIG_PAGE_RIG = 0
#if defined (HAVE_LIBHAMLIB) && defined (HAVE_HAMLIB_ROTATOR_H)
	, GRIG_CONFIG_PAGE_ROT
#endif
};


static gboolean running = FALSE; /* Set to TRUE when condig is running */

static GtkWidget *configbox = NULL;

/* private function prototypes */
static void grig_config_apply_cb     (GnomePropertyBox *pbox, gint pagenum, gpointer data);
static void grig_config_help_cb      (GnomePropertyBox *pbox, gint pagenum, gpointer data);
static void grig_config_cancel_cb    (GtkWidget *button, gpointer data);
static gint grig_config_window_close (GtkWidget *widget, GdkEvent *event, gpointer data);
static void grig_config_destroy      (GtkWidget *widget, gpointer data);


void
grig_config_run ()
{

	if (!running) {
		rig_debug (RIG_DEBUG_TRACE, _("*** Gnome RIG: grig_config_run called\n"));
		/* change state */
		running = TRUE;

		/* create property box */
		configbox = gnome_property_box_new ();
		gtk_window_set_title (GTK_WINDOW (configbox), _("Gnome RIG Preferences"));

		/* Add contents */
/*  		gnome_property_box_append_page (GNOME_PROPERTY_BOX (configbox), */
/*  						grig_config_general_create (), */
/*  						gtk_label_new (_("General"))); */
/*  		gnome_property_box_append_page (GNOME_PROPERTY_BOX (configbox), */
/*  						grig_config_loc_create (), */
/*  						gtk_label_new (_("Locations"))); */
		gnome_property_box_append_page (GNOME_PROPERTY_BOX (configbox),
						grig_config_rig_create (),
						gtk_label_new (_("Radios")));
#if defined (HAVE_LIBHAMLIB) && defined (HAVE_HAMLIB_ROTATOR_H)
		gnome_property_box_append_page (GNOME_PROPERTY_BOX (configbox),
						grig_config_rot_create (),
						gtk_label_new (_("Rotators")));
#endif
		/* connect signals */
		gtk_signal_connect (GTK_OBJECT (configbox), "apply",
				    GTK_SIGNAL_FUNC (grig_config_apply_cb),
				    NULL);
		gtk_signal_connect (GTK_OBJECT (configbox), "help",
				    GTK_SIGNAL_FUNC (grig_config_help_cb),
				    NULL);
		gtk_signal_connect (GTK_OBJECT (configbox), "delete_event",
				    GTK_SIGNAL_FUNC (grig_config_window_close),
				    NULL);
		gtk_signal_connect (GTK_OBJECT (configbox), "destroy",
				    GTK_SIGNAL_FUNC (grig_config_destroy),
				    NULL);
		gtk_signal_connect (GTK_OBJECT (GNOME_PROPERTY_BOX (configbox)->cancel_button),
				    "clicked",
				    GTK_SIGNAL_FUNC (grig_config_cancel_cb),
				    configbox);
		/* disable help button */
		gtk_widget_set_sensitive (GNOME_PROPERTY_BOX (configbox)->help_button, FALSE);

		gtk_widget_show_all (configbox);
	}
	else
		rig_debug (RIG_DEBUG_TRACE, _("*** Gnome RIG: grig_config_run called but config "\
					      "code is already running\n"));
}


void
grig_config_changed ()
{
	g_return_if_fail (configbox != NULL);

	rig_debug (RIG_DEBUG_TRACE, _("*** Gnome RIG: grig_config_changed called\n"));
	gnome_property_box_changed (GNOME_PROPERTY_BOX (configbox));
}


static void 
grig_config_apply_cb  (GnomePropertyBox *pbox,
		       gint pagenum, 
		       gpointer data)
{
	gchar *buff;

	buff = g_strdup_printf (_("*** Gnome RIG: grig_config_apply_cb called: PAGE %d\n"), pagenum);
	rig_debug (RIG_DEBUG_TRACE, buff);
	g_free (buff);

	switch (pagenum) {
/*  	case GRIG_CONFIG_PAGE_GENERAL: */
/*  		grig_config_general_apply (); */
/*  		break; */
/*  	case GRIG_CONFIG_PAGE_LOC: */
/*  		grig_config_loc_apply (); */
/*  		break; */
	case GRIG_CONFIG_PAGE_RIG:
		grig_config_rig_apply ();
		break;
#if defined (HAVE_LIBHAMLIB) && defined (HAVE_HAMLIB_ROTATOR_H)
	case GRIG_CONFIG_PAGE_ROT:
		grig_config_rot_apply ();
		break;
#endif
	default:
	}
}


static void
grig_config_cancel_cb (GtkWidget *button,
		       gpointer data)
{
	rig_debug (RIG_DEBUG_TRACE, _("*** Gnome RIG: grig_config_cancel_cb called\n"));

/*  	grig_config_general_cancel (); */
/*  	grig_config_loc_cancel (); */
	grig_config_rig_cancel ();
#if defined (HAVE_LIBHAMLIB) && defined (HAVE_HAMLIB_ROTATOR_H)
	grig_config_rot_cancel ();
#endif

	gtk_widget_destroy (GTK_WIDGET (data));
}


static void
grig_config_help_cb   (GnomePropertyBox *pbox, 
		       gint pagenum, 
		       gpointer data)
{
	gchar *buff;

	buff = g_strdup_printf (_("*** Gnome RIG: grig_config_help_cb called: PAGE %d\n"), pagenum);
	rig_debug (RIG_DEBUG_TRACE, buff);
	g_free (buff);

	switch (pagenum) {
/*  	case GRIG_CONFIG_PAGE_GENERAL: */
/*  		grig_config_general_help (); */
/*  		break; */
/*  	case GRIG_CONFIG_PAGE_LOC: */
/*  		grig_config_loc_help (); */
/*  		break; */
	case GRIG_CONFIG_PAGE_RIG:
		grig_config_rig_help ();
		break;
#if defined (HAVE_LIBHAMLIB) && defined (HAVE_HAMLIB_ROTATOR_H)
	case GRIG_CONFIG_PAGE_ROT:
		grig_config_rot_help ();
		break;
#endif
	default:
	}
}



static gint
grig_config_window_close (GtkWidget *widget,
			  GdkEvent  *event,
			  gpointer data)
{
	/* If you return FALSE in the "delete_event" signal handler,
	   GTK will emit the "destroy" signal. Returning TRUE means
	   you don't want the window to be destroyed.
	   This is useful for popping up 'are you sure you want to quit?'
	   type dialogs.
	*/
	running = FALSE;
	return FALSE;
}


static void
grig_config_destroy (GtkWidget *widget, gpointer data)
{
	/* This function is called when the
	   grig config window is destroyed.
	*/
	rig_debug (RIG_DEBUG_TRACE, _("*** Gnome RIG: grig_config_destroy called\n"));

	/* give them a chance to clean up */
/*  	grig_config_general_close (); */
/*  	grig_config_loc_close (); */
	grig_config_rig_close ();
#if defined (HAVE_LIBHAMLIB) && defined (HAVE_HAMLIB_ROTATOR_H)
	grig_config_rot_close ();
#endif

	running = FALSE;
}
