/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */
/*
  grig-druid.c:  Configuration wizard for first time use of Gnome RIG.

  Copyright (C)  2001, 2002  Groundstation Software Suite Team.

  Authors: Alexandru Csete <csete@users.sourceforge.net>

  Comments, questions and bugreports should be submitted via
  http://sourceforge.net/projects/groundstation/
  More details can be found at http://groundstation.sourceforge.net/
 
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the
          Free Software Foundation, Inc.,
	  59 Temple Place, Suite 330,
	  Boston, MA  02111-1307
	  USA
*/

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gnome.h>
#include <gconf/gconf.h>
#include <gconf/gconf-client.h>

#include "grig-druid.h"
#include "grig-druid-rig.h"
#include "grig-druid-ant.h"
#include "grig-druid-loc.h"

#if defined (HAVE_LIBHAMLIB) && defined (HAVE_HAMLIB_RIG_H)
#  include <hamlib/rig.h>
#endif

GdkColor mainbg,headbg;

extern GConfClient *confclient;  /* main.c */

static void grig_druid_cancel_cb (GnomeDruid *, gpointer);
static void grig_druid_finish_cb (GnomeDruidPage *, gpointer, gpointer);
static GtkWidget *grig_druid_page_start_create (void);
static GtkWidget *grig_druid_page_finish_create (void);

void grig_druid_run ()
{
	/* Create the widgets and run the configuration druid.
	   It will create it's own gtk_main () loop, so the program
	   will hang here until the druid is finished or canceled.
	 */

	GtkWidget *druid,*window;
	GtkWidget *pend; /* this is needed to connect the "finish" signal correctly */

	/* initialize colors */
	mainbg.red   = (gushort)0xFFFF;
	mainbg.green = (gushort)0xFFFF;
	mainbg.blue  = (gushort)0xFFFF;
	headbg.red   = (gushort)6425;
	headbg.green = (gushort)6425;
	headbg.blue  = (gushort)28784;

	pend = grig_druid_page_finish_create ();

	/* create the druid and it's contents */
	druid = gnome_druid_new ();
	gnome_druid_append_page (GNOME_DRUID (druid),
				 GNOME_DRUID_PAGE (grig_druid_page_start_create ()));
	gnome_druid_append_page (GNOME_DRUID (druid),
				 GNOME_DRUID_PAGE (grig_druid_loc_create (druid)));
	gnome_druid_append_page (GNOME_DRUID (druid),
				 GNOME_DRUID_PAGE (grig_druid_rig_create (druid)));
#if defined (HAVE_LIBHAMLIB) && defined (HAVE_HAMLIB_ROTATOR_H)
	gnome_druid_append_page (GNOME_DRUID (druid),
				 GNOME_DRUID_PAGE (grig_druid_ant_create (druid)));
#endif
	gnome_druid_append_page (GNOME_DRUID (druid),
				 GNOME_DRUID_PAGE (pend));

	/* create container window */
	window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
	gtk_window_set_title (GTK_WINDOW (window),
			      _("Gnome RIG configuration druid"));
	gtk_container_add (GTK_CONTAINER (window), druid);

	/* now that we have the window, we can connect the signals */
	gtk_signal_connect (GTK_OBJECT (druid), "cancel",
			    GTK_SIGNAL_FUNC (grig_druid_cancel_cb),
			    window);
	gtk_signal_connect (GTK_OBJECT (pend), "finish",
			    GTK_SIGNAL_FUNC (grig_druid_finish_cb),
			    window);
	
	/* show everything */
	gtk_widget_show_all (window);

	/* start main loop */
	gtk_main ();

}


static void
grig_druid_cancel_cb (GnomeDruid *druid, gpointer window)
{
	/* This function is called when the users clicks on the
	   "Cancel" button. */

	/* cancel modules */
	grig_druid_loc_cancel ();
	grig_druid_rig_cancel ();
#if defined (HAVE_LIBHAMLIB) && defined (HAVE_HAMLIB_ROTATOR_H)
	grig_druid_ant_cancel ();
#endif
	gconf_client_suggest_sync (confclient, NULL);

	gtk_widget_destroy (GTK_WIDGET (window));
	gtk_main_quit ();
	exit (0);
}


static void
grig_druid_finish_cb (GnomeDruidPage *page, gpointer druid, gpointer window)
{
	/* This function is called when the user clicks on the
	   "finish" button on the last page of the configuration
	   druid.
	*/
	
	/* finish modules */
	grig_druid_loc_finish ();
	grig_druid_rig_finish ();
#if defined (HAVE_LIBHAMLIB) && defined (HAVE_HAMLIB_ROTATOR_H)
	grig_druid_ant_finish ();
#endif
	gconf_client_suggest_sync (confclient, NULL);

	gtk_widget_destroy (GTK_WIDGET (window));
	gtk_main_quit ();
}


const gchar *welcome = {
	N_("It seems that this is the first time you are running Gnome RIG, \n"\
	   "or you have messed up your configuration. Don't worry...\n\n"\
	   "On the following pages you will be guided through the initial\n"\
	   "setup of Gnome RIG. You will have the possibility to configure\n"\
	   "your radios, antennas and locations.\n\n"\
	   "You will always have the possibility to change these settings at\n"\
	   "any later time.")
};


static GtkWidget *
grig_druid_page_start_create ()
{
	/* This function creates the first page of the configuration
	   druid.
	*/

	GtkWidget *page;

	page = gnome_druid_page_start_new_with_vals (_("Welcome to Gnome RIG !"),
						     welcome,
						     NULL,
						     NULL);
	gnome_druid_page_start_set_bg_color (GNOME_DRUID_PAGE_START (page),
					     &headbg);
	gnome_druid_page_start_set_logo_bg_color (GNOME_DRUID_PAGE_START (page),
						  &headbg);

	return page;
}


const gchar *end = {
	N_("Gnome RIG should now be configured properly. Press \"Finish\"\n"\
	   "to save your settings and start the program.\n\n"\
	   "If you have comments, questions or other problems, please visit\n"\
	   "the project page at http://sourceforge.net/projects/groundstation\n"\
	   "and ask for support.")
};

static GtkWidget *
grig_druid_page_finish_create ()
{
	/* This function creates the last page of the configuration
	   druid.
	*/

	GtkWidget *page;

	page = gnome_druid_page_finish_new_with_vals (_("Configuration complete !"),
						      end,
						      NULL,
						      NULL);
	gnome_druid_page_finish_set_bg_color (GNOME_DRUID_PAGE_FINISH (page),
					   &headbg);
	gnome_druid_page_finish_set_logo_bg_color (GNOME_DRUID_PAGE_FINISH (page),
						&headbg);

	return page;
}
