/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */
/*
  menubar.c:  Menubar UIInfo macros for Gnome RIG.

  Copyright (C)  2001, 2002  Alexandru Csete.

  Comments, questions and bugreports should be submitted via
  http://sourceforge.net/projects/groundstation/
  More details can be found at http://groundstation.sourceforge.net/
 
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the
          Free Software Foundation, Inc.,
	  59 Temple Place, Suite 330,
	  Boston, MA  02111-1307
	  USA
*/


#include <gnome.h>
#include <gconf/gconf-client.h>
#include <hamlib/rig.h>
#include "grig-config.h"

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif


extern GtkWidget *app;            /* in main.c */
extern GConfClient *confclient;   /* ditto */

static void grig_set_debug_level_cb (GtkWidget *, gpointer);
static void grig_exit_cb (GtkWidget *, gpointer);
static void grig_about_cb (GtkWidget *, gpointer);
static void grig_config_cb (GtkWidget *widget, gpointer data);


/* File menu declaration */
GnomeUIInfo grig_file_menu[] = {
#ifdef HAVE_GNOME_PRINT
/*	GNOMEUIINFO_MENU_PRINT_ITEM (print_main_satlist, NULL),
	GNOMEUIINFO_SEPARATOR,*/
#endif
	GNOMEUIINFO_MENU_EXIT_ITEM (grig_exit_cb, NULL),
	GNOMEUIINFO_END
};

/* rig_set_debug items in a radiolist */
GnomeUIInfo grig_settings_debug_list[] = {
	GNOMEUIINFO_RADIOITEM_DATA (N_("_None"), N_("No debug info"),
				    grig_set_debug_level_cb,
				    GUINT_TO_POINTER (0), NULL),
	GNOMEUIINFO_RADIOITEM_DATA (N_("_Bug"), N_("Internal bugs"),
				    grig_set_debug_level_cb,
				    GUINT_TO_POINTER (1), NULL),
	GNOMEUIINFO_RADIOITEM_DATA (N_("_Error"), N_("Show only errors"),
				    grig_set_debug_level_cb,
				    GUINT_TO_POINTER (2), NULL),
	GNOMEUIINFO_RADIOITEM_DATA (N_("_Warning"), N_("Also show warnings"),
				    grig_set_debug_level_cb,
				    GUINT_TO_POINTER (3), NULL),
	GNOMEUIINFO_RADIOITEM_DATA (N_("_Verbose"), N_("Verbose"),
				    grig_set_debug_level_cb,
				    GUINT_TO_POINTER (4), NULL),
	GNOMEUIINFO_RADIOITEM_DATA (N_("_Trace"), N_("Print everything"),
				    grig_set_debug_level_cb,
				    GUINT_TO_POINTER (5), NULL),
	GNOMEUIINFO_END
};


/* the submenu containing the radiolist */
GnomeUIInfo grig_settings_debug_submenu[] = {
	GNOMEUIINFO_RADIOLIST (grig_settings_debug_list),
	GNOMEUIINFO_END
};

/* Settings menu entry */
GnomeUIInfo grig_settings_menu[] = {
/*  	GNOMEUIINFO_ITEM_STOCK (N_("_Preferences"), N_("Edit settings and preferences"), */
/*  				grig_config_cb, */
/*  				GNOME_STOCK_PIXMAP_PREFERENCES), */
	GNOMEUIINFO_MENU_PREFERENCES_ITEM (grig_config_cb, NULL),
	GNOMEUIINFO_SEPARATOR,
	GNOMEUIINFO_SUBTREE (N_("_Debug Level"), grig_settings_debug_submenu),
	GNOMEUIINFO_END
};

/* Help menu declaration */
GnomeUIInfo grig_help_menu[] = {
	GNOMEUIINFO_HELP ("grig"),
	GNOMEUIINFO_SEPARATOR,
	GNOMEUIINFO_MENU_ABOUT_ITEM (grig_about_cb, NULL),
	GNOMEUIINFO_END
};

/* MENUBAR */
GnomeUIInfo grig_menubar[] = {
	GNOMEUIINFO_MENU_FILE_TREE (grig_file_menu),
	GNOMEUIINFO_SUBTREE (N_("_Settings"), grig_settings_menu),
	GNOMEUIINFO_MENU_HELP_TREE (grig_help_menu),
	GNOMEUIINFO_END
};



static void
grig_set_debug_level_cb (GtkWidget *widget, gpointer level)
{
	rig_set_debug (GPOINTER_TO_UINT (level));
	gconf_client_set_int (confclient,
			      "/apps/grig/hamlib/debug",
			      GPOINTER_TO_UINT (level),
			      NULL);
	gconf_client_suggest_sync (confclient, NULL);
}



static void
grig_config_cb (GtkWidget *widget, gpointer data)
{
	grig_config_run ();
}


static void
grig_exit_cb (GtkWidget *widget, gpointer data)
{
	gtk_widget_destroy (app);
}


/*** About callback  ***/
static void
grig_about_cb (GtkWidget *widget, gpointer data)
{
	const gchar *authors[] = {
		N_("Alexandru Csete, <csete@users.sourceforge.net>."),
		NULL
	};
	GtkWidget *about,*hbox,*home,*proj;

	about = gnome_about_new (_("Gnome RIG"), VERSION,
				 _("Copyright (C) 2002 Alexandru Csete"),
				 (const gchar **) authors,
				 _("Gnome RIG is a GUI for the Ham Radio Control Libraries. "\
				   "Gnome RIG is licensed under the terms and conditions of the"\
				   "GNU General Public License."),
				 NULL);
	/* URL link buttons */
	home = gnome_href_new ("http://groundstation.sourceforge.net/?grig",
			       _("Gnome RIG Home Page"));
	proj = gnome_href_new ("http://sourceforge.net/projects/groundstation/",
			       _("Gnome RIG Project Page"));
	/* hbox */
	hbox = gtk_hbox_new (TRUE, 5);
	gtk_box_pack_start (GTK_BOX (hbox), home, FALSE, FALSE, 0);
	gtk_box_pack_start (GTK_BOX (hbox), proj, FALSE, FALSE, 0);

	/* add to About Box */
	gtk_box_pack_start_defaults (GTK_BOX (GNOME_DIALOG (about)->vbox), hbox);

	gtk_widget_show_all (about);
}


