/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */
/*
  riglist-util.c:  Utility functions for obtaining a list of available
                   drivers in hamlib.

  Copyright (C)  2001, 2002  Alexandru Csete.

  Comments, questions and bugreports should be submitted via
  http://sourceforge.net/projects/groundstation/
  More details can be found at http://groundstation.sourceforge.net/
 
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the
          Free Software Foundation, Inc.,
	  59 Temple Place, Suite 330,
	  Boston, MA  02111-1307
	  USA
*/

#include <glib.h>
#include "riglist-util.h"

#ifdef HAVE_CONFIG_H
#  include "../config.h"
#endif

#if defined (HAVE_LIBHAMLIB) && defined (HAVE_HAMLIB_RIG_H)
#  include <hamlib/rig.h>
#endif

/* Do we need riglist.h at all? */
#if defined (HAVE_LIBHAMLIB) && defined (HAVE_HAMLIB_RIGLIST_H)
#  include <hamlib/riglist.h>
#endif

#if defined (HAVE_LIBHAMLIB) && defined (HAVE_HAMLIB_RIG_H) && defined (HAVE_HAMLIB_RIGLIST_H)
gint riglist_make_list (const struct rig_caps *, gpointer);
#endif


/* Keep it forever */
static GSList *riglist = NULL;


GSList *riglist_get_list ()
{
	/* This function returns a list with available
	   drivers from hamlib. The returned list is a
	   newly allocated singly linked GSList which
	   should be freed with g_slist_free() when no
	   longer needed.
	*/
#if defined (HAVE_LIBHAMLIB) && defined (HAVE_HAMLIB_RIG_H)
//	GSList *list = NULL;
	gint status;
	if (!riglist) {
		rig_load_all_backends ();
		status = rig_list_foreach (riglist_make_list, NULL);
	}
	return riglist;
#endif
	return NULL;
}



#if defined (HAVE_LIBHAMLIB) && defined (HAVE_HAMLIB_RIG_H)
gint riglist_make_list (const struct rig_caps *caps, gpointer data)
{
	/* This function appends a new entry in the driver
	   list. It is called by the rig_list_foreach()
	   function from hamlib.
	*/
	riglist = g_slist_append (riglist, (gpointer) caps);

	return 1;
}
#endif

