/*
 * Controller module header
 *
 * GroController manages GroMoves.
 * It is bind to one drawable window(typically root window).
 * It owns one 'theme'.
 * It has a timer, which drives everything.
 *
 * The timer's start and stop is up to the caller.
 * For example, if a caller called gro_controller_run() twice,
 * without calling gro_controller_stop() for the first timer,
 * the first timer is never stopped.
 * (No way to stop it, because it lost its timer-id.)
 * 
 * Copyright INOUE Seiichiro <inoue@ainet.or.jp>, licensed under the GPL.
 */
#ifndef __GRO_CONTROLLER_H__
#define __GRO_CONTROLLER_H__

#include "theme.h"
#include "growin.h"

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */


/* Private stuff */
typedef struct _GroControllerPrivate GroControllerPrivate;

struct _GroController {
	GroTheme *cur_theme;	/* Current theme */
	GroWindow *gro_win;		/* Window for drawing */

	GList *gmove_list;		/* Doubly linked list of GroMove */
	
	GroControllerPrivate *privat;
};


/* Global function declarations */
extern GroController* gro_controller_new(GdkWindow *window, GtkWidget *actual_widget);
extern void gro_controller_delete(GroController *controller);
extern void gro_controller_attach_theme(GroController *controller, GroTheme *theme);
extern void gro_controller_detach_theme(GroController *controller);
extern void gro_controller_run(GroController *controller);
extern void gro_controller_stop(GroController *controller);
extern gboolean gro_controller_is_running(const GroController *controller);
extern void gro_controller_change_interval(GroController *controller, guint interval_base);
extern void gro_controller_add_gmoves(GroController *controller, guint num_gmoves);

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* __GRO_CONTROLLER_H__ */
