/*
 * Copyright 2003-2015 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package groovy

class TripleQuotedStringTest extends GroovyTestCase {

    void testTripleQuotedString() {
        def s = """
        Lots of 'text' with a variety of ""quoting "" and
   a few lines
    and some escaped \""" quoting and
    an ending""".trim()

        println(s)
        assert s != null
        def idx = s.indexOf("quoting and")
        assert idx > 0
    }

    static void main( String[] args ) { 
        def o = new TripleQuotedStringTest();
        o.testTripleQuotedString();
    }
}
