/*
 * Copyright 2003-2015 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package groovy.bugs

import groovy.util.GroovyTestCase

public class Groovy2706Bug extends GroovyTestCase {
    static counter = 0

    void testStaticAccessWithIncAndDec() {
        ++Groovy2706Bug.counter
        assert counter == 1
        Groovy2706Bug.counter++
        assert counter == 2
        --Groovy2706Bug.counter
        assert counter == 1
        Groovy2706Bug.counter--
        assert counter == 0
        --counter
        assert counter == -1
        ++counter
        assert counter == 0
        counter++
        assert counter == 1
        counter--
        assert counter == 0
    }

}
