/*
 * Grouch.app				Copyright (C) 2006 Andy Sveikauskas
 * ------------------------------------------------------------------------
 * This program is free software under the GNU General Public License
 * --
 * Add buddy/group window.
 */

#import <AddWindow.h>
#import <ClientInstance.h>
#import <User.h>
#import <ErrorWindow.h>

#import <Grouch/GrouchStringTool.h>

#import <AppKit/AppKit.h>
#import <Renaissance/Renaissance.h>

enum
{
	TAG_BUDDY = 0,
	TAG_GROUP = 1
};

@implementation AddWindow

+ windowWithInstance:(ClientInstance*)c
{
	return [[self alloc] initWithInstance:c];
}

- initWithInstance:(ClientInstance*)c
{
	cli = c;
	[NSBundle loadGSMarkupNamed:@"AddWindow" owner:self];
	[window orderFront:nil];
	[window makeKeyWindow];
	[cli addDependentWindow:window];
	[operation selectCellWithTag:TAG_BUDDY];
	[group addItemsWithObjectValues:[cli getGroups]];
        if( [group numberOfItems] )
	{
		[group selectItemAtIndex:0];
		[group setStringValue:[group objectValueOfSelectedItem]];
	}
	return self;
}

- (BOOL)windowShouldClose:sender
{
	[cli removeDependentWindow:window];
	[window autorelease];
	[operation release];
	[name release];
	[group release];
	[self release];
	return YES;
}

- (void)setUser:(User*)u
{
	[name setStringValue:[u name]];	
}

- (void)gotOperation:sender
{
	int action = [(NSCell*)[operation selectedCell] tag];
	[name setEnabled:(action == TAG_BUDDY)];
}

- (void)gotName:sender
{
	[window makeFirstResponder:group];
}

- (void)gotInfo:sender
{
	NSString *who, *where;
	int action = [(NSCell*)[operation selectedCell] tag];

	who = [name stringValue];
	where = [group stringValue];

	if( (![who length] && action == TAG_BUDDY) || ![where length] )
	{
		[ErrorWindow errorWithString:
		 [GrouchString getString:@"vague-form"]];
		return;
	}

	if( action == TAG_GROUP )
		who = nil;

	[[cli session] addUser:who toGroup:where];

	[window performClose:self];
}

- (void)gotGroup:sender
{
	if( [[name stringValue] length] )
		[self gotInfo:sender];
}

@end
