/*
 * Grouch.app				Copyright (C) 2006 Andy Sveikauskas
 * ------------------------------------------------------------------------
 * This program is free software under the GNU General Public License
 * --
 * This subclass of NSMutableDictionary attaches timestamps to objects and
 * lets you "purge" objects that are older than a given age.  That way,
 * the objects don't stay in the dictionary forever and leak memory.
 *
 * To check all the timestamps and delete old objects, call:
 *	[dict expireObjects];
 * This must be done manually.
 *
 * If you REALLY don't want your object to go away, it should accept the
 * message:	- (BOOL)shouldRelease
 * returning YES if it's okay to expire the object, NO otherwise.  The GUI's
 * User class implements this so that users who have an IM window currently
 * open do not get purged.
 */

#import <Foundation/NSDictionary.h>

@interface GrouchTimedDictionary : NSMutableDictionary
{
@private
	NSMutableDictionary *dict;
	id target;
	SEL action;
	unsigned int expireTime;
}

- init;
- (void)dealloc;

// how long it takes for an object to expire in seconds
- (unsigned int)expireTime;
- (void)expireTime:(unsigned int)nSeconds;

// target action:obj called whenever objects are removed
- target;
- (SEL)action;
- (void)setTarget:target;
- (void)setAction:(SEL)act;

// This should be called when you want to get old objects out of the picture
- (void)expireObjects;

// NSDictionary primitives
- (unsigned)count;
- initWithObjects:(id*)objs forKeys:(id*)keys count:(unsigned)count;
- (NSEnumerator*)keyEnumerator;
- (NSEnumerator*)objectEnumerator;
- objectForKey:k;

// NSMutableDictionary primitives
- initWithCapacity:(unsigned)capacity;
- (void)removeObjectForKey:key;
- (void)setObject:obj forKey:key;

@end
