/*
 * Grouch.app				Copyright (C) 2006 Andy Sveikauskas
 * ------------------------------------------------------------------------
 * This program is free software under the GNU General Public License
 * --
 * Simplified interface to application preferences.
 */

#import <Defaults.h>
#import <String.h>

#import <Grouch/GrouchStringTool.h>

#import <Foundation/NSUserDefaults.h>
#import <Foundation/NSString.h>
#import <Foundation/NSDictionary.h>
#import <Foundation/NSValue.h>

static NSString *savedUserDict	= @"Saved User Information";
static NSString *colorDict      = @"Buddy List Tags";
static NSString *awayMsgDict	= @"Away Messages";

#ifdef __APPLE__
#include <stdio.h>
#import <Foundation/NSBundle.h>
#import <Foundation/NSPropertyList.h>
#import <Foundation/NSData.h>
/* Ugly hack to get Mac OS X version.  Since this is NeXT versioning,
   6.0 is 10.0. */
static NSString *getCocoaVersion()
{
	NSBundle *b = [NSBundle bundleForClass:[NSBundle class]];
	NSString *path = [b pathForResource:@"version" ofType:@"plist"];
	if( path )
	{
		NSDictionary *d = [NSPropertyListSerialization
		propertyListFromData:[NSData dataWithContentsOfFile:path]
		mutabilityOption:NSPropertyListImmutable format:NULL
		errorDescription:NULL];
		NSString *r = [d objectForKey:@"CFBundleShortVersionString"];;
		if( r )
			return r;
	}
	return @"6.4";
}
#endif

@implementation Defaults

+ (NSUserDefaults*)defaults
{
	return [NSUserDefaults standardUserDefaults];
}

+ (void)registerDefaults
{
	NSString *msgTitle, *msgBody;
	NSDictionary *awayMsg, *colors, *defaults;
	NSString *menuType;

	msgTitle = [GrouchString getString:@"away-msg-title"];
	msgBody  = [GrouchString getString:@"away-msg"];

	awayMsg = [NSDictionary dictionaryWithObject:msgBody forKey:msgTitle];

	// We don't have to terminate these HTML tags because
	// GrouchHtml will do that for us.
	colors = [NSDictionary dictionaryWithObjectsAndKeys:
		 @"<b><i>", @"offline",
		 @"<i>", @"idle",
		 @"<i>", @"away+idle",
		 nil];

#ifdef GNUSTEP
	menuType = @"Gnu";
#else
	{
		int major = 6, minor = 4;
		sscanf( [getCocoaVersion() cString], "%i.%i", &major, &minor );
		if( major > 6 || minor > 3 )
			menuType = @"Apple";
		else
			menuType = @"Apple-103";
	}
#endif

	defaults = [NSDictionary dictionaryWithObjectsAndKeys:
				 awayMsg,awayMsgDict,
				 colors,colorDict,
				 [NSNumber numberWithInt:5*60],
				 @"Auto-response Time-out",
				 menuType, @"Menu Type",
				 nil];

	[[self defaults] registerDefaults:defaults];
}

+ get:(NSString*)key
{
	return [[self defaults] objectForKey:key];
}

+ get:(NSString*)key fromDict:(NSString*)dict
{
	NSDictionary *d = [[self defaults] objectForKey:dict];
	if( d )
		return [d objectForKey:key];
	else
		return d;
}

+ (void)set:obj forKey:(NSString*)key
{
	[[self defaults] setObject:obj forKey:key];
}
+ (void)set:obj forKey:(NSString*)key inDict:(NSString*)dict
{
	NSDictionary *d = [[self defaults] objectForKey:dict];
	if( d )
	{
		NSMutableDictionary *d2 = [NSMutableDictionary
		dictionaryWithDictionary:d];
		[d2 setObject:obj forKey:key];
		[self set:d2 forKey:dict];
	}
	else
	{
		d = [NSDictionary dictionaryWithObject:obj forKey:key];
		[self set:d forKey:dict];
	}
}

+ (void)removeKey:(NSString*)key
{
	[[self defaults] removeObjectForKey:key];
}

+ (void)removeKey:(NSString*)key inDict:(NSString*)dict
{
	NSDictionary *d = [[self defaults] objectForKey:dict];
	if( d )
	{
		NSMutableDictionary *d2 = [NSMutableDictionary
		dictionaryWithDictionary:d];
		[d2 removeObjectForKey:key];
		[self set:d2 forKey:dict];
	}
}

+ (NSDictionary*)getSavedUsers
{
	NSDictionary *r = [self get:savedUserDict];
	if( r )
		return r;
	else
		return [NSDictionary dictionary];
}

+ getSavedUserInfo:(NSString*)key forUser:(NSString*)user
{
	NSDictionary *d;
	user = [user screenNameKey];
 	d = [self get:user fromDict:savedUserDict];
	if( d )
	{
		// Compatibility with original format...
		id r = [d objectForKey:key];
		if( !r && [key isEqual:@"Login"] )
			return user;
		else
			return r;
	}
	else
		return d;
}

+ (void)setSavedUserInfo:info forKey:(NSString*)key andUser:(NSString*)user
{
	NSDictionary *d;
	user = [user screenNameKey];
 	d = [self get:user fromDict:savedUserDict];
	if( user )
	{
		NSMutableDictionary *d2 = [NSMutableDictionary
		dictionaryWithDictionary:d];
		[d2 setObject:info forKey:key];
		[self set:d2 forKey:user inDict:savedUserDict];
	}
	else
	{
		d = [NSDictionary dictionaryWithObject:info forKey:key];
		[self set:d forKey:user inDict:savedUserDict];
	}
}

+ (NSDictionary*)getSavedUser:(NSString*)user
{
	NSDictionary *d;
	user = [user screenNameKey];
 	d = [self get:user fromDict:savedUserDict];
	if( d )
	{
		if( [d objectForKey:@"Login"] )
		{
			return d;
		}
		else // Compatibility with original format...
		{
			NSMutableDictionary *m = [NSMutableDictionary
			dictionaryWithDictionary:d];
			[m setObject:user forKey:@"Login"];
			return m;
		}
	}
	else
		return nil;
}

+ (void)removeSavedUser:(NSString*)user
{
	[self removeKey:[user screenNameKey] inDict:savedUserDict];
}

+ (NSString*)getAwayMessage:(NSString*)title
{
	return [self get:title fromDict:awayMsgDict];
}

+ (void)setAwayMessage:(NSString*)title withTitle:(NSString*)key
{
	[self set:title forKey:key inDict:awayMsgDict];
}

+ (void)removeAwayMessage:(NSString*)title
{
	[self removeKey:title inDict:awayMsgDict];
}

+ (NSDictionary*)getAwayMessages
{
	return [self get:awayMsgDict];
}

@end

