/*
 * Grouch.app				Copyright (C) 2006 Andy Sveikauskas
 * ------------------------------------------------------------------------
 * This program is free software under the GNU General Public License
 * --
 * Simplified interface to application preferences.
 */

#import <Foundation/NSObject.h>
@class NSUserDefaults, NSString, NSDictionary;

@interface Defaults : NSObject

+ (void)registerDefaults;
+ (NSUserDefaults*)defaults;

+ get:(NSString*)key;
+ get:(NSString*)key fromDict:(NSString*)dict;

+ (void)set:obj forKey:(NSString*)key;
+ (void)set:obj forKey:(NSString*)key inDict:(NSString*)dict;

+ (void)removeKey:(NSString*)key;
+ (void)removeKey:(NSString*)key inDict:(NSString*)dict;

+ (NSDictionary*)getSavedUsers;

+ getSavedUserInfo:(NSString*)key forUser:(NSString*)user;
+ (void)setSavedUserInfo:info forKey:(NSString*)key andUser:(NSString*)user;

+ (NSDictionary*)getSavedUser:(NSString*)key;
+ (void)removeSavedUser:(NSString*)key;

+ (NSString*)getAwayMessage:(NSString*)title;
+ (void)setAwayMessage:(NSString*)msg withTitle:(NSString*)str;
+ (void)removeAwayMessage:(NSString*)msg;

+ (NSDictionary*)getAwayMessages;

@end

