/*
 * Grouch.app				Copyright (C) 2006 Andy Sveikauskas
 * ------------------------------------------------------------------------
 * This program is free software under the GNU General Public License
 * --
 * "Set Profile" window.
 */

#import <SetProfile.h>
#import <Defaults.h>
#import <ClientInstance.h>
#import <String.h>

#import <Renaissance/Renaissance.h>
#import <AppKit/AppKit.h>

static NSString *profileKey = @"Profile";

@implementation SetProfile

- init
{
	NSArray *clients = [ClientInstance clientInstances];
	NSDictionary *storedUsers = [Defaults getSavedUsers];
	NSEnumerator *e;
	NSString *str;
	int i;
	NSMutableDictionary *uniqueKeys = [NSMutableDictionary new];

	[NSBundle loadGSMarkupNamed:@"SetProfile" owner:self];
	[window orderFront:nil];
	[window makeKeyWindow];

	e = [storedUsers keyEnumerator];
	while( (str = [e nextObject]) )
		[uniqueKeys setObject:str forKey:str];

	for( i=0; i<[clients count]; ++i )
	{
		ClientInstance *cli = [clients objectAtIndex:i];
		NSString *nick = [cli nick];
		[uniqueKeys setObject:nick forKey:[nick screenNameKey]];
	}

	e = [uniqueKeys objectEnumerator];
	while( (str = [e nextObject]) )
		[loginComboBox addItemWithObjectValue:str]; 

	[uniqueKeys release];

	if( [loginComboBox numberOfItems] )
	{
		[loginComboBox selectItemAtIndex:0];
		str = [loginComboBox objectValueOfSelectedItem];
		[self setLogin:str];
	}

	return self;
}

- (void)setLogin:(NSString*)str
{
	NSString *profile = [Defaults getSavedUserInfo:profileKey
	forUser:str];
	NSAttributedString *attributed = profile ? [profile parseHtml] :
	[@"" attributed];

	[[input textStorage] setAttributedString:attributed];
	[input setSelectedRange:NSMakeRange(0,0)];
	[loginComboBox setStringValue:str];
}

- (void)gotLogin
{
	[self setLogin:[loginComboBox stringValue]];
}

- (void)gotProfile
{
	NSString *luser = [loginComboBox stringValue];
	ClientInstance *cli = nil;

	NSAttributedString *str = [input textStorage];
	NSString *html = [str generateHtml];

	[Defaults setSavedUserInfo:html forKey:profileKey andUser:luser];
	luser = [Defaults getSavedUserInfo:@"Login" forUser:luser]; 
	
	if( luser )
		cli = [ClientInstance clientByName:luser];
	if( cli )
		[cli setProfile:html];
	[window performClose:self];	
}

- (BOOL)windowShouldClose:sender
{
	[window autorelease];
	[loginComboBox release];
	[input release];
	[self release];
	return YES;
}

@end
