/*
 * Grouch.app				Copyright (C) 2006 Andy Sveikauskas
 * ------------------------------------------------------------------------
 * This program is free software under the GNU General Public License
 * --
 * Asks for rooms and such.
 */

#import <Oscar/OscarFlap.h>

@protocol OscarChatNav
- (void)createChannel:(NSString*)chan withExchange:(int)exchange;
@end

// This queues create operations while we're waiting for the
// socket to connect.
@interface OscarChatNavQueue : NSObject <OscarChatNav>
{
	struct oscarchatnavqueue_node
	{
		NSString *channel;
		int exchange;

		struct oscarchatnavqueue_node *next;
	} *head, *tail;
}

- init;
- (void) dealloc;

- (void)createChannel:(NSString*)chan withExchange:(int)exchange;
- (void)processQueue:(id <OscarChatNav>)chatnav;
@end

@interface OscarChatNav : OscarFlap <OscarChatNav>
{
	OscarChatNavQueue *q;
	BOOL online;
}

+ chatNavForHost:(NSString*)host andCookie:(id<OscarCredentials>)cookie
  andQueue:(OscarChatNavQueue*)q andClient:(OscarClient*)cli;

- initForHost:(NSString*)host andCookie:(id<OscarCredentials>)cookie
  andQueue:(OscarChatNavQueue*)q andClient:(OscarClient*)cli;

- (void)createChannel:(NSString*)chan withExchange:(int)exchange;

- (void)welcome;
@end

