/*
 * Grouch.app				Copyright (C) 2006 Andy Sveikauskas
 * ------------------------------------------------------------------------
 * This program is free software under the GNU General Public License
 * --
 * Some SNAC handler classes.
 *
 * NB: If you send +new to any of these instead of +get, you get memory leaks.
 */

#import <Oscar/OscarSnacHandler.h>

@interface OscarErrorHandler : NSObject <OscarSnacHandler>
+ get;
- (void)handleSnacForClient:(OscarFlap*)flap
	ofFamily:(int)family andType:(int)type
	withFlags:(int)flags andTag:tag
	buffer:(OscarIncomingSnac*)buf;
@end

@interface OscarServiceHandler : OscarSnacFamilyHandler
+ get;
- init;
@end

@interface OscarSnac00010002Base : NSObject <OscarSnacHandler>
- (void)handleSnacForClient:(OscarFlap*)flap
	ofFamily:(int)family andType:(int)type
	withFlags:(int)flags andTag:tag
	buffer:(OscarIncomingSnac*)buf;
- (void)pre:(OscarFlap*)flap;
- (void)post:(OscarFlap*)flap;
@end

@interface OscarLookupHandler : OscarSnacFamilyHandler
+ get;
- init;
@end

@interface OscarListHandler : OscarSnacFamilyHandler
+ get;
- init;
@end

@interface OscarMessageHandler : OscarSnacFamilyHandler
+ get;
- init;
@end

@interface OscarSsiHandler : OscarSnacFamilyHandler
+ get;
- init;
@end

@interface OscarChatNavHandler : OscarSnacFamilyHandler
+ get;
- init;
@end

@interface OscarChatHandler : OscarSnacFamilyHandler
+ get;
- init;
@end

// Junk that I couldn't put anywhere else.
@class OscarTlvListIn;
@protocol GrouchUser;
void oscar_process_buddy( int warn, OscarTlvListIn *tlv, id<GrouchUser> u );

