/*-----------------------------------------------------------------+
 |                                                                 |
 |  Copyright (C) 2002-2003 Grubconf                               |
 |                     http://grubconf.sourceforge.net/            | 
 |                                                                 |
 | This program is free software; you can redistribute it and/or   |
 | modify it under the terms of the GNU General Public License     |
 | as published by the Free Software Foundation; either version 2  |
 | of the License, or (at your option) any later version           |
 |                                                                 |
 | This program is distributed in the hope that it will be useful, |
 | but WITHOUT ANY WARRANTY; without even the implied warranty of  |
 | MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the   |
 | GNU General Public License for more details.                    |
 |                                                                 |
 | A copy of the GNU General Public License may be found in the    |
 | installation directory named "COPYING"                          |
 |                                                                 |
 +-----------------------------------------------------------------+
 */

#include <gtk/gtk.h>

struct grubconf_dev
{
	int drv_num;	// grub's drive number
	int part_num;	// partition number
//	char bsd_num;	// not yet implemented
	
	char *dev_name;	// device name, ie /dev/hda1
	char *fs_label;	// volume label
	
	char *mount_point;	// mount point for device
	
	unsigned char dev_type;
	
	gboolean mounted;
	gboolean need_umount;
	
	struct grubconf_dev *next;
};

// represents the front of the list of devices
struct grubconf_dev *dev_front;

// represents the numeber of devices
unsigned short dev_size;

/* Initializes the list of devices 
 */
void init_grubconf_dev(void);

/* Probes the system devices to build a list of available paritions
 * that grub can use
 */
void reset_grubconf_dev(void);

/* returns the filesystem type ID for part starting at 1 from part_table
 */
unsigned char get_type(int part);

/* Returns the human readable fileystem type, or null if cant
 * be used by GRUB (or not implemented by grubconf)
 */
char *type_to_name(unsigned char type);

/* Returns the filesystem label for specified device
 * 
 * Adapted from Andries Brouwer's (aeb@cwi.nl) e2label
 */
char *get_fs_label(char *dev_str);

/*
 * cleans the list of devices
 */
void dev_list_clean(void);

/* returns 1 if drive exits, 0 otherwise. If the drive
 * exists it will grab the partition talbe while it has
 * it open
 */
int dev_exists(char *name, int offset);

/* retrieves the device at index
 */
struct grubconf_dev *get_dev(int index);

/* retrieves the index from GRUB device of format (hd0,0).
 */
int get_index_grub(char *dev_str);

/* retrieves teh index from GRUB device of format /dev/hda1. 
 */
int get_index_dev(char *dev_str);

/* retrieves the index from GRUB device matching label
 */
int get_index_label(char *label);

/* returns true if the given device is mounted
 */
gboolean mounted (char *dev_str);

/* attempts to mount selected mnt_point. Will return true if is or was mounted.
 */
gboolean mount (char *mnt_point);

/* attempts to mount selected device. Will return true if is or was mounted.
 */
gboolean mount_from_dev (struct grubconf_dev *dev);

/* attempts to umount selected device. Will return true if is or was umounted.
 */
gboolean umount_from_dev (struct grubconf_dev *dev);

/* loads mnu with current devices
 */
void dev_load_menu(GtkWidget *mnu);

/* loads mnu with current devices, optionaly printing path
 */
void dev_load_menu_path(GtkWidget *mnu, gboolean path);
