/*-----------------------------------------------------------------+
 |                                                                 |
 |  Copyright (C) 2002-2003 Grubconf                               |
 |                     http://grubconf.sourceforge.net/            | 
 |                                                                 |
 | This program is free software; you can redistribute it and/or   |
 | modify it under the terms of the GNU General Public License     |
 | as published by the Free Software Foundation; either version 2  |
 | of the License, or (at your option) any later version           |
 |                                                                 |
 | This program is distributed in the hope that it will be useful, |
 | but WITHOUT ANY WARRANTY; without even the implied warranty of  |
 | MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the   |
 | GNU General Public License for more details.                    |
 |                                                                 |
 | A copy of the GNU General Public License may be found in the    |
 | installation directory named "COPYING"                          |
 |                                                                 |
 +-----------------------------------------------------------------+
 */

#ifndef _GRUBCONF_GLOBAL_H_
#define _GRUBCONF_GLOBAL_H_

//#include <glib.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <stdio.h>

#include <config.h>
#include <include/interface.h>
#include <include/callbacks.h>
#include <include/support.h>
#include <include/grubconf_os_list.h>
#include <include/grubconf_dev.h>

struct os_list_item;
enum os_dev_type;
enum os_dev_rank;
enum os_dev_part;

enum known_commands
{
	UNKNOWN,
	DEFAULT,
	TIMEOUT,
	SPLASHIMAGE,
	COLOR,
	HIDDENMENU,
	TITLE,
	ROOT,
	KERNEL,
	ROOTNOVERIFY,
	MAKEACTIVE,
	CHAINLOADER
};

enum color_enum {
	BLACK,
	BLUE,
	GREEN,
	CYAN,
	RED,
	MAGENTA,
	BROWN,
	LIGHT_GRAY,
	DARK_GRAY,
	LIGHT_BLUE,
	LIGHT_GREEN,
	LIGHT_CYAN,
	LIGHT_RED,
	LIGHT_MAGENTA,
	YELLOW,
	WHITE,
	INVERSE
};

char *grubconf_fname;
char *grubconf_fname_bak;

/* Perform all data initialization. This is called before
 * gtk is initialied. 
 */
void init_global (void);
/* Called before the program exits. Cleanup anything that needs
 * it here
 */
void clean_global (void);

/* Finds the grub configuration file
 */
void find_menu_lst (void);

/* Loads the grub configuration file
 */
int load_from_file (void);

/* Parses a line from the config file and returns an enumeration of the type
 */
enum known_commands get_command (char **line);

/* parses a line from the config file and returns the value of that option
 */
char *get_value (char *line);

/* searches haystack for needle case-insensitively
 */
char *stristr (char *haystack, char *needle);

/* Saves the grub configuration to file
 */
int save_to_file (void);

/* Resests the OS editing dialog to default values
 */
void reset_diaOS (void);

/* loads the OS editing dialog with an os item
 */
void edit_diaOS (GtkTreeModel *model, GtkTreeIter *iter);

/* reset the device menus that use paths
 */
void reset_dev_menus (void);

/* get color from char*
 */
enum color_enum get_color_enum (char *color);

/* get char* from color
 */
char *get_color_string (enum color_enum);


extern size_t getline (char **lineptr, size_t *n, FILE *stream);


#endif
