/*-----------------------------------------------------------------+
 |                                                                 |
 |  Copyright (C) 2002-2003 Grubconf                               |
 |                     http://grubconf.sourceforge.net/            | 
 |                                                                 |
 | This program is free software; you can redistribute it and/or   |
 | modify it under the terms of the GNU General Public License     |
 | as published by the Free Software Foundation; either version 2  |
 | of the License, or (at your option) any later version           |
 |                                                                 |
 | This program is distributed in the hope that it will be useful, |
 | but WITHOUT ANY WARRANTY; without even the implied warranty of  |
 | MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the   |
 | GNU General Public License for more details.                    |
 |                                                                 |
 | A copy of the GNU General Public License may be found in the    |
 | installation directory named "COPYING"                          |
 |                                                                 |
 +-----------------------------------------------------------------+
 */
/*
 * This contains universal helper functions
 */

#include <fcntl.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/sendfile.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <unistd.h>

// for _(String)
#include <gnome.h>

#include <include/grubconf_global.h>

/* This function will find a widget called widget_name 
 */
GtkWidget *
lookup_widget (GtkWidget * widget, const gchar * widget_name)
{
	GtkWidget *parent, *found_widget;

	while (1)
	{
		if (GTK_IS_MENU (widget))
			parent = gtk_menu_get_attach_widget (GTK_MENU
							     (widget));
		else
			parent = widget->parent;
		if (!parent)
			parent = gtk_object_get_data (GTK_OBJECT (widget),
						      "GladeParentKey");
		if (parent == NULL)
			break;
		widget = parent;
	}

	found_widget = (GtkWidget *) gtk_object_get_data (GTK_OBJECT (widget),
							  widget_name);
	if (!found_widget)
		g_warning ("Widget not found: %s", widget_name);
	return found_widget;
}

/* Finds the currently selected items index in widget. widget is of
 * type option menu 
 */
int
get_selected (GtkWidget * widget)
{
	GtkWidget *menu, *active_item;
	gint active_index;
	if (!GTK_OPTION_MENU (widget))
	{
		return 0;
	}
	menu = GTK_OPTION_MENU (widget)->menu;
	active_item = gtk_menu_get_active (GTK_MENU (menu));
	active_index =
		g_list_index (GTK_MENU_SHELL (menu)->children, active_item);
	return active_index;
}

/* Will send a warning mesage in a dialog
 *
 * Valid m_type values are:
 * GTK_MESSAGE_INFO
 * GTK_MESSAGE_WARNING
 * GTK_MESSAGE_QUESTION
 * GTK_MESSAGE_ERROR 
*/
void 
gtk_message (GtkMessageType m_type, char *warn_str, ...)
{
	char s[200];
	va_list arg;
	int done;
	
	va_start (arg, warn_str);
	done = vsprintf (s, warn_str, arg);
	va_end (arg);

	if (done < 0) { // just in case something went to hell
		m_type = GTK_MESSAGE_ERROR;
		strcpy(s, _("There was a problem formatting an error mesasge"));
	}
	
	GtkWidget *dialog = gtk_message_dialog_new (GTK_WINDOW (winMain),
                                  GTK_DIALOG_DESTROY_WITH_PARENT,
                                  m_type,
                                  GTK_BUTTONS_CLOSE,
                                  s);
	gtk_dialog_run (GTK_DIALOG (dialog));
	gtk_widget_destroy (dialog);
}

/* copies file from source to dest
 */
int
copy (char *source, char *dest) 
{
	int read_fd, write_fd;
	struct stat stat_buf;
	off_t offset = 0;
	
	if (!source || !dest) 
		return 0;
	
	read_fd = open (source, O_RDONLY);
	fstat (read_fd, &stat_buf);
	
	write_fd = open (dest, O_WRONLY | O_CREAT | O_TRUNC, stat_buf.st_mode);
	
	sendfile (write_fd, read_fd, &offset, stat_buf.st_size);
	
	close (read_fd);
	close (write_fd);
	return 1;
}

/* reads a line from stream and stores it in *lineptr
 * returns 0  on failure, 1 on success
 */
size_t
my_getline (char **lineptr, FILE * stream)
{
	int zero;
	size_t ret;
	char *tmp_str;
	ret = getline (lineptr, &zero, stream);
	tmp_str = strchr (*lineptr, '\n');
	if (tmp_str)
		*tmp_str = '\0';
	return ret;
}
