/* GSAMBAD, an easy to use GTK+ frontend for the SAMBA file and print server.
 * Copyright (C) 2006 Magnus Loef <magnus-swe@telia.com> 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307, USA.
 *
*/



#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>
#include "gettext.h"
#include "widgets.h"
#include "make_settings_entries.h"
#include "make_settings_buttons.h"
#include "make_settings_combos.h"
#include "make_settings_spinbuttons.h"
#include "make_settings_checkbuttons.h"
#include "delete_share.h"
#include "add_share.h"
#include "create_import_question.h"
#include "apply_share_settings.h"



void create_share_settings(struct w *widgets)
{
    GtkTooltips *tooltips;
    gchar *combo_text = NULL;
    gchar *utf8 = NULL;

    GtkWidget *hbox;
    GtkWidget *delete_share_button;
    GtkWidget *add_share_button;
    GtkWidget *import_button;

    GtkWidget *import_hbox;
    GtkWidget *import_image;
    GtkWidget *import_label;
    GtkWidget *import_alignment;

    GtkWidget *apply_share_button;

    int a = 0;
    int b = 1;

    int ent  = 0;
    int comb = 0;

    tooltips = gtk_tooltips_new();
    hbox = gtk_hbox_new(FALSE, 3);

    /* The delete and apply share settings buttons */
    delete_share_button = gtk_button_new_from_stock(GTK_STOCK_DELETE);
    add_share_button = gtk_button_new_from_stock(GTK_STOCK_ADD);
    apply_share_button = gtk_button_new_from_stock(GTK_STOCK_APPLY);

    gtk_box_pack_start(GTK_BOX(hbox), delete_share_button, FALSE, FALSE, 0);
    gtk_box_pack_start(GTK_BOX(hbox), add_share_button, FALSE, FALSE, 0);

    /* Custom import users or groups button */
    import_button = gtk_button_new();
    import_alignment = gtk_alignment_new (0.5, 0.5, 0, 0);
    gtk_container_add(GTK_CONTAINER(import_button), import_alignment);

    import_hbox = gtk_hbox_new(FALSE, 2);
    gtk_container_add(GTK_CONTAINER(import_alignment), import_hbox);

    import_image = gtk_image_new_from_stock("gtk-convert", GTK_ICON_SIZE_BUTTON);
    gtk_box_pack_start(GTK_BOX(import_hbox), import_image, FALSE, FALSE, 0);

    import_label = gtk_label_new_with_mnemonic(_("Import users and groups"));
    gtk_box_pack_start(GTK_BOX(import_hbox), import_label, FALSE, FALSE, 0);
    gtk_label_set_justify(GTK_LABEL(import_label), GTK_JUSTIFY_LEFT);

    gtk_box_pack_start(GTK_BOX(hbox), import_button, FALSE, FALSE, 0);
    gtk_box_pack_start(GTK_BOX(hbox), apply_share_button, FALSE, FALSE, 0);



    /* table, left, right, top, bottom, fill, expand, length, xpad, ypad */
    gtk_table_attach(GTK_TABLE(widgets->share_set_table), hbox, 1, 2, 0, 1, 0, 0, 5, 5);
    a++; b++;

    g_signal_connect_swapped(G_OBJECT(delete_share_button), "clicked",
			     G_CALLBACK(delete_share), widgets);

    g_signal_connect_swapped(G_OBJECT(add_share_button), "clicked",
			     G_CALLBACK(add_share), widgets);

    g_signal_connect_swapped(G_OBJECT(import_button), "clicked",
			     G_CALLBACK(create_import_question), widgets);
			     
    g_signal_connect_swapped(G_OBJECT(apply_share_button), "clicked",
			     G_CALLBACK(apply_share_settings), widgets);



    /* Sharename */	     /* Max length and input 350 chars */
    widgets->share_set_entry[ent] = make_entry_with_label(GTK_TABLE(widgets->share_set_table), _(" Share name: "), 0,1,a,b,350);
    gtk_tooltips_set_tip(tooltips, widgets->share_set_entry[ent], "The name of the Share", NULL);
    a++; b++; ent++;

    /* Share path */
    GtkWidget *sharepath_button;
    widgets->share_set_entry[ent] = gtk_entry_new();
    sharepath_button = make_button_with_entry(GTK_TABLE(widgets->share_set_table),
                                             widgets->share_set_entry[ent],
                                             "gtk-refresh",
                                             "Shared directory:",  // fixme, utf8
                                             "Select a directory to share",  // fixme, utf8
                                             0,1,a,b,350);
    a++; b++; ent++;


    /* A comment */
    widgets->share_set_entry[ent] = make_entry_with_label(GTK_TABLE(widgets->share_set_table), _(" Comment: "), 0,1,a,b,350);
    gtk_tooltips_set_tip(tooltips, widgets->share_set_entry[ent], "A comment for this share", NULL);
    a++; b++; ent++;


    /* Valid users */
    widgets->share_set_entry[ent] = make_entry_with_label(GTK_TABLE(widgets->share_set_table), _(" Valid users: "), 0,1,a,b,350);
    gtk_tooltips_set_tip(tooltips, widgets->share_set_entry[ent], "If any users or groups are listed then only these users and groups can connect to this share", NULL);
    a++; b++; ent++;


    /* Write list */
    widgets->share_set_entry[ent] = make_entry_with_label(GTK_TABLE(widgets->share_set_table), _(" Write list: "), 0,1,a,b,350);
    gtk_tooltips_set_tip(tooltips, widgets->share_set_entry[ent], "Only these users and groups have write access to this share unless they are admin users", NULL);
    a++; b++; ent++;


    /* Admin users */
    widgets->share_set_entry[ent] = make_entry_with_label(GTK_TABLE(widgets->share_set_table), _(" Admin users: "), 0,1,a,b,350);
    gtk_tooltips_set_tip(tooltips, widgets->share_set_entry[ent], "Admin users override filesystem permissions and have full control in this share", NULL);
    a++; b++; ent++;


    /* Directory mask */
    widgets->share_set_entry[ent] = make_entry_with_label(GTK_TABLE(widgets->share_set_table), _(" Directory mask: "), 0,1,a,b,350);
    gtk_tooltips_set_tip(tooltips, widgets->share_set_entry[ent], "A Directory mask", NULL);
    a++; b++; ent++;


    /* Create mode */
    widgets->share_set_entry[ent] = make_entry_with_label(GTK_TABLE(widgets->share_set_table), _(" Create mode: "), 0,1,a,b,350);
    gtk_tooltips_set_tip(tooltips, widgets->share_set_entry[ent], "A create mode", NULL);
    a++; b++; ent++;





    /* read only combo */
    widgets->share_set_combo[comb] = make_label_combo_label(GTK_TABLE(widgets->share_set_table), _(" Read only: "), 0,1,a,b, 80);
    combo_text = g_strdup_printf(_("Yes"));
    utf8 = g_locale_to_utf8(combo_text, strlen(combo_text), NULL, NULL, NULL);
    gtk_combo_box_append_text(GTK_COMBO_BOX(widgets->share_set_combo[comb]), utf8);
    combo_text = g_strdup_printf(_("No"));
    utf8 = g_locale_to_utf8(combo_text, strlen(combo_text), NULL, NULL, NULL);
    gtk_combo_box_append_text(GTK_COMBO_BOX(widgets->share_set_combo[comb]), utf8);
    g_free(combo_text); g_free(utf8);
    a++; b++; comb++;


    /* available combo */
    widgets->share_set_combo[comb] = make_label_combo_label(GTK_TABLE(widgets->share_set_table), _(" Available: "), 0,1,a,b, 80);
    combo_text = g_strdup_printf(_("Yes"));
    utf8 = g_locale_to_utf8(combo_text, strlen(combo_text), NULL, NULL, NULL);
    gtk_combo_box_append_text(GTK_COMBO_BOX(widgets->share_set_combo[comb]), utf8);
    combo_text = g_strdup_printf(_("No"));
    utf8 = g_locale_to_utf8(combo_text, strlen(combo_text), NULL, NULL, NULL);
    gtk_combo_box_append_text(GTK_COMBO_BOX(widgets->share_set_combo[comb]), utf8);
    g_free(combo_text); g_free(utf8);
    a++; b++; comb++;


    /* browseable combo */
    widgets->share_set_combo[comb] = make_label_combo_label(GTK_TABLE(widgets->share_set_table), _(" Browseable: "), 0,1,a,b, 80);
    combo_text = g_strdup_printf(_("Yes"));
    utf8 = g_locale_to_utf8(combo_text, strlen(combo_text), NULL, NULL, NULL);
    gtk_combo_box_append_text(GTK_COMBO_BOX(widgets->share_set_combo[comb]), utf8);
    combo_text = g_strdup_printf(_("No"));
    utf8 = g_locale_to_utf8(combo_text, strlen(combo_text), NULL, NULL, NULL);
    gtk_combo_box_append_text(GTK_COMBO_BOX(widgets->share_set_combo[comb]), utf8);
    g_free(combo_text); g_free(utf8);
    a++; b++; comb++;


    /* writable combo */
    widgets->share_set_combo[comb] = make_label_combo_label(GTK_TABLE(widgets->share_set_table), _(" Writable: "), 0,1,a,b, 80);
    combo_text = g_strdup_printf(_("Yes"));
    utf8 = g_locale_to_utf8(combo_text, strlen(combo_text), NULL, NULL, NULL);
    gtk_combo_box_append_text(GTK_COMBO_BOX(widgets->share_set_combo[comb]), utf8);
    combo_text = g_strdup_printf(_("No"));
    utf8 = g_locale_to_utf8(combo_text, strlen(combo_text), NULL, NULL, NULL);
    gtk_combo_box_append_text(GTK_COMBO_BOX(widgets->share_set_combo[comb]), utf8);
    g_free(combo_text); g_free(utf8);
    a++; b++; comb++;


    /* guest ok combo */
    widgets->share_set_combo[comb] = make_label_combo_label(GTK_TABLE(widgets->share_set_table), _(" Guest ok: "), 0,1,a,b, 80);
    combo_text = g_strdup_printf(_("Yes"));
    utf8 = g_locale_to_utf8(combo_text, strlen(combo_text), NULL, NULL, NULL);
    gtk_combo_box_append_text(GTK_COMBO_BOX(widgets->share_set_combo[comb]), utf8);
    combo_text = g_strdup_printf(_("No"));
    utf8 = g_locale_to_utf8(combo_text, strlen(combo_text), NULL, NULL, NULL);
    gtk_combo_box_append_text(GTK_COMBO_BOX(widgets->share_set_combo[comb]), utf8);
    g_free(combo_text); g_free(utf8);
    a++; b++; comb++;


    /* public combo */
    widgets->share_set_combo[comb] = make_label_combo_label(GTK_TABLE(widgets->share_set_table), _(" Public: "), 0,1,a,b, 80);
    combo_text = g_strdup_printf(_("Yes"));
    utf8 = g_locale_to_utf8(combo_text, strlen(combo_text), NULL, NULL, NULL);
    gtk_combo_box_append_text(GTK_COMBO_BOX(widgets->share_set_combo[comb]), utf8);
    combo_text = g_strdup_printf(_("No"));
    utf8 = g_locale_to_utf8(combo_text, strlen(combo_text), NULL, NULL, NULL);
    gtk_combo_box_append_text(GTK_COMBO_BOX(widgets->share_set_combo[comb]), utf8);
    g_free(combo_text); g_free(utf8);
    a++; b++; comb++;


    /* printable combo */
    widgets->share_set_combo[comb] = make_label_combo_label(GTK_TABLE(widgets->share_set_table), _(" Printable: "), 0,1,a,b, 80);
    combo_text = g_strdup_printf(_("Yes"));
    utf8 = g_locale_to_utf8(combo_text, strlen(combo_text), NULL, NULL, NULL);
    gtk_combo_box_append_text(GTK_COMBO_BOX(widgets->share_set_combo[comb]), utf8);
    combo_text = g_strdup_printf(_("No"));
    utf8 = g_locale_to_utf8(combo_text, strlen(combo_text), NULL, NULL, NULL);
    gtk_combo_box_append_text(GTK_COMBO_BOX(widgets->share_set_combo[comb]), utf8);
    g_free(combo_text); g_free(utf8);
    a++; b++; comb++;


    /* share modes combo */
    widgets->share_set_combo[comb] = make_label_combo_label(GTK_TABLE(widgets->share_set_table), _(" Share modes: "), 0,1,a,b, 80);
    combo_text = g_strdup_printf(_("Yes"));
    utf8 = g_locale_to_utf8(combo_text, strlen(combo_text), NULL, NULL, NULL);
    gtk_combo_box_append_text(GTK_COMBO_BOX(widgets->share_set_combo[comb]), utf8);
    combo_text = g_strdup_printf(_("No"));
    utf8 = g_locale_to_utf8(combo_text, strlen(combo_text), NULL, NULL, NULL);
    gtk_combo_box_append_text(GTK_COMBO_BOX(widgets->share_set_combo[comb]), utf8);
    g_free(combo_text); g_free(utf8);
    a++; b++; comb++;


    /* locking combo */
    widgets->share_set_combo[comb] = make_label_combo_label(GTK_TABLE(widgets->share_set_table), _(" File locking: "), 0,1,a,b, 80);
    combo_text = g_strdup_printf(_("Yes"));
    utf8 = g_locale_to_utf8(combo_text, strlen(combo_text), NULL, NULL, NULL);
    gtk_combo_box_append_text(GTK_COMBO_BOX(widgets->share_set_combo[comb]), utf8);
    combo_text = g_strdup_printf(_("No"));
    utf8 = g_locale_to_utf8(combo_text, strlen(combo_text), NULL, NULL, NULL);
    gtk_combo_box_append_text(GTK_COMBO_BOX(widgets->share_set_combo[comb]), utf8);
    g_free(combo_text); g_free(utf8);
    a++; b++; comb++;


    gtk_widget_show_all(widgets->main_window);
}
