/* GSAMBAD, an easy to use GTK+ frontend for the SAMBA file and print server.
 * Copyright (C) 2006 Magnus Loef <magnus-swe@telia.com> 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307, USA.
 *
*/



#include "../config.h"
#include <gtk/gtk.h>
#include "support.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include "allocate.h"
#include "widgets.h"
#include "functions.h"
#include "populate_conns.h"
#include "show_info.h"
#include "commands.h"



void populate_conns(struct w *widgets)
{
    /* Lists connections to the samba server and its shares */
    FILE *fp;
    GtkTreeIter iter;
    GtkTreePath *path;
    char *line, *input1, *input2, *input3, *input4, *input5, *input6, *tmp_pid;
    gboolean edit=0;
    int found_conn=0;
    long file_size=0, old_pos=0;
    gchar *combined=NULL;
    gchar *utf8=NULL;

    gtk_list_store_clear(widgets->conns_store);

    /* This attempt to show useful output is probably quite
       doomed as the output of smbstatus will most likely change. */

    if( ! file_exists("/tmp") )
    {
	printf("The folder: /tmp doesnt exist, returning.\n");
        return;
    }

    /* Flush stdin and stdout */
    fflush(stdin);
    fflush(stdout);

    /* Write the output of smbstatus to a tempfile, FIXME: Static paths and generally notgoodtoday */
    if((fp=popen("touch /tmp/gsambadtmp && chmod 600 /tmp/gsambadtmp && smbstatus 2>&1> /tmp/gsambadtmp", "w"))==NULL)
    {
	/* Dont show a popup */
        return;
    }
    pclose(fp);

    /* We want it in a tempfile so we can scroll around in it properly */
    if((fp=fopen("/tmp/gsambadtmp", "r"))==NULL) // FIXME: Static paths
    {
	/* Dont show a popup */
        return;
    }
    fseek(fp, 0, SEEK_END);
    file_size = ftell(fp);
    rewind(fp);

    /* glibc-2.4 crazyness-avoidance */
    if( file_size < 2 )
    {
	printf("The output is less then 2 chars long, returning.\n");
        return;
    }

    line = allocate(file_size+1);
    input1 = allocate(4096);
    input2 = allocate(4096);
    input3 = allocate(4096);
    input4 = allocate(4096);
    input5 = allocate(4096);
    input6 = allocate(4096);
    tmp_pid = allocate(4096);

/*
  PID    User       Group         Machine       (IP = doesnt show)    (Share, pop downwards with PID to PID matching)
  -------------------------------------------------------------------
  7324   mange      mange         samba24       (127.0.0.1)  	      /home/foo/glibc...
  7326   mange      mange         samba24       (127.0.0.1)  	      /var/cad/dwg.dwg
  

  Service ........... connected at      etc    etc
  -------------------------------------------------------------------


  Locked files:
  Pid          DenyMode   Access      R/W        Oplock           SharePath           Name
  ----------------------------------------------------------------------------------------
  7324         DENY_NONE  0x120089    RDONLY     NONE             /home   mange/GLIBC/glibc-2.3.6.tar.bz2   Sun Jun 25 23:34:59 2006
  7326         DENY_NONE  0x120089    RDONLY     NONE             /home   mange/GLIBC/glibc-2.3.6.tar.bz2   Sun Jun 25 23:35:17 2006
*/


    /* Scroll to the first divider line "------" */
    while(fgets(line, file_size, fp)!=NULL)
      if( strstr(line, "---") )
        break;

    while(fgets(line, file_size, fp)!=NULL)
    {
	/* Skip stuff we dont want to list */
	if( strlen(line) < 10 || strlen(line) > 4000 )
	  continue;
	  
	if( strstr(line, "---") || strstr(line, "Connected at") )
	  break;

	/* Grab row output */
	sscanf(line, "%s %s %s %s %s", input1, input2, input3, input4, input5);

	/* Add a row */
    	gtk_list_store_append(GTK_LIST_STORE(widgets->conns_store), &iter);

	/* Insert PID */
    	utf8 = g_locale_to_utf8(input1, strlen(input1), NULL, NULL, NULL);
    	gtk_list_store_set(GTK_LIST_STORE(widgets->conns_store), &iter, 0, utf8, -1);
                                                                                                                                   
	/* Insert User name */
    	utf8 = g_locale_to_utf8(input2, strlen(input2), NULL, NULL, NULL);
    	gtk_list_store_set(GTK_LIST_STORE(widgets->conns_store), &iter, 1, utf8, -1);

	/* Insert Group name */
    	utf8 = g_locale_to_utf8(input3, strlen(input3), NULL, NULL, NULL);
    	gtk_list_store_set(GTK_LIST_STORE(widgets->conns_store), &iter, 2, utf8, -1);

	/* Insert Server name */
    	utf8 = g_locale_to_utf8(input4, strlen(input4), NULL, NULL, NULL);
    	gtk_list_store_set(GTK_LIST_STORE(widgets->conns_store), &iter, 3, utf8, -1);

	/* Insert IP-Address */
    	utf8 = g_locale_to_utf8(input5, strlen(input5), NULL, NULL, NULL);
    	gtk_list_store_set(GTK_LIST_STORE(widgets->conns_store), &iter, 4, utf8, -1);

	found_conn = 1;

	if( strstr(line, "---") )
	  break;


	/* Record the old position */
	old_pos = ftell(fp);

	/* Scroll to the second divider line "------" */
	while(fgets(line, file_size, fp)!=NULL)
    	if( strstr(line, "---") )
    	  break;

	/* Scroll to the third divider line "------" */
	while(fgets(line, file_size, fp)!=NULL)
    	if( strstr(line, "---") )
    	  break;

	while(fgets(line, file_size, fp)!=NULL)
	{
	    /* Skip stuff we dont want to list */
	    if( strlen(line) < 10 || strlen(line) > 4000 )
	      continue;

	    /* Grab row output (PID, /sharepath, dir/file) */
	    sscanf(line, "%s %*s %*s %*s %*s %s %s", tmp_pid, input5, input6);

	    if( ! strcmp(tmp_pid, input1) ) /* && is_digitz(tmp_pid..) input1 is the users pid from the first while */
	    {
		combined = g_strdup_printf("%s/%s", input5, input6);
		/* Insert The SharePath/File */
    		utf8 = g_locale_to_utf8(combined, strlen(combined), NULL, NULL, NULL);
    		gtk_list_store_set(GTK_LIST_STORE(widgets->conns_store), &iter, 5, utf8, -1);
		g_free(combined);
		break;
	    }
	}
	
	/* Scroll to the old position */
	fseek(fp, old_pos, SEEK_SET);
    }
    fclose(fp);
    free(line);
    free(input1);
    free(input2);
    free(input3);
    free(input4);
    free(input5);
    free(input6);
    free(tmp_pid);

    if( utf8 !=NULL )
      g_free(utf8);

    /* Cant set path if there are no rows */
    if( ! found_conn )
      return;

    path = gtk_tree_path_new_first();
    gtk_tree_view_set_cursor(GTK_TREE_VIEW(widgets->conns_treeview), path, NULL, edit);
    gtk_tree_path_free(path);
}
