//*****************************************************************************
//                                NbkSimrBase.hpp                             *
//                               -----------------                            *
// Description : Base class for all simulator notebooks which contains the    *
//               individual analysis panels.                                  *
// Started     : 05/05/2004                                                   *
// Last Update : 12/04/2010                                                   *
// Copyright   : (C) 2004 by MSWaters                                         *
// Email       : M.Waters@bom.gov.au                                          *
//*****************************************************************************

//*****************************************************************************
//                                                                            *
//    This program is free software; you can redistribute it and/or modify    *
//    it under the terms of the GNU General Public License as published by    *
//    the Free Software Foundation; either version 2 of the License, or       *
//    (at your option) any later version.                                     *
//                                                                            *
//*****************************************************************************

#ifndef NBKSIMRBASE_HPP
#define NBKSIMRBASE_HPP

// System Includes

#include <iostream>

// wxWindows Includes

#include <wx/wx.h>
#include <wx/notebook.h>

// Application Includes

#include "TypeDefs.hpp"
#include "netlist/NetList.hpp"
#include "base/SimnBase.hpp"
#include "base/PnlAnaBase.hpp"

// Local Constant Declarations


//*****************************************************************************

class NbkSimrBase : public wxNotebook
{
  protected :

    // Error message
    wxString   m_osErrMsg;

    // Attribute to identify the simulation engine type
    eSimrType  m_eSimEng;

  public :

    NbkSimrBase( wxWindow * poParent, wxWindowID oWinID );
    NbkSimrBase( void );
   ~NbkSimrBase( );

    virtual  bool  bClear( void );
             bool  bIsOk ( void ) { return( m_osErrMsg.IsEmpty( ) ); }

    virtual  bool  bLoad( const SimnBase & roSimn ) = 0;
    virtual  bool  bSave(       SimnBase & roSimn ) = 0;

    virtual  bool  bSetPage( const wxChar * psAnalysis ) = 0;
    virtual  bool  bSetPage(       eCmdType  eAnalysis ) = 0;

    virtual  const  wxString & rosGetPage( void ) = 0;
    virtual         eCmdType     eGetPage( void ) = 0;

    const wxString & rosGetErrMsg( void ) { return( m_osErrMsg ); }
          void          SetErrMsg( const wxString & rosErrMsg )
                                     { if( bIsOk( ) ) m_osErrMsg = rosErrMsg; }

    eSimrType  eGetSimEng( void ) { return( m_eSimEng ); }

    // Event handlers
    void  OnPageChanged( wxNotebookEvent & roEvtNbk );

    // Leave this as the last line as private access is envoked by macro
    DECLARE_EVENT_TABLE( )
};

//*****************************************************************************

#endif // NBKSIMRBASE_HPP
