//*****************************************************************************
//                               PrcGnuCap.hpp                                *
//                              ---------------                               *
//  Description : This class provides the interface to the GNU-Cap electronic *
//                circuit simulator.                                          *
//  Started     : 01/09/2003                                                  *
//  Last Update : 14/07/2009                                                  *
//  Copyright   : (C) 2003 by M.S.Waters                                      *
//  Email       : M.Waters@bom.gov.au                                         *
//*****************************************************************************

//*****************************************************************************
//                                                                            *
//    This program is free software; you can redistribute it and/or modify    *
//    it under the terms of the GNU General Public License as published by    *
//    the Free Software Foundation; either version 2 of the License, or       *
//    (at your option) any later version.                                     *
//                                                                            *
//*****************************************************************************

#ifndef PRCGNUCAP_HPP
#define PRCGNUCAP_HPP

// System Includes


// wxWindows Includes

#include <wx/wx.h>
#include <wx/config.h>

// Application Includes

#include "TypeDefs.hpp"
#include "base/PrcSimrBase.hpp"
#include "netlist/SimnGnuCap.hpp"
#include "gnucap/commands/CmdGnuCapOP.hpp"
#include "gnucap/commands/CmdGnuCapDC.hpp"
#include "gnucap/commands/CmdGnuCapAC.hpp"
#include "gnucap/commands/CmdGnuCapTR.hpp"
#include "gnucap/commands/CmdGnuCapFO.hpp"
#include "gnucap/commands/CmdGnuCapPR.hpp"
#include "utility/ConvertType.hpp"

// Local Constant Declarations

#define  GNUCAP_COL_WD  14  // Width of columns of data in the results files

//*****************************************************************************

class PrcGnuCap : public PrcSimrBase
{
  private:

    // The label for the X axis variable (sometimes missing in GNU-Cap)
    wxString  m_osInput;

    // Functions to check / format the circuit description lines
//    bool  bFmtCpnts( ArrayComponent & roaCpnts ); ??? 17/08/2009

    // Format the results file
    bool  bFmtGeneric  ( void );
    bool  bFmtResultsFO( void );
    bool  bFmtColumnHdr( void );
    bool  bFmtDataLines( void );

  public:

    PrcGnuCap( void );
   ~PrcGnuCap( );

    // Create the process argument list
    virtual  bool  bMakeArgLst( SimnBase & roSimn );

    // Format the results file
    virtual  bool  bFmtResults( void );
};

//*****************************************************************************

#endif // PRCGNUCAP_HPP
