/*
  Gnome applet for Searching the web in a Practical, Outlined and Tidy way
  Copyright (C) 2007 Norberto M. Lopes shelika@mail.telepac.pt
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.   
  
  @author: Norberto M. Lopes shelika@mail.telepac.pt
*/
#include "gspot_engines.h"
#include "gspot_callbacks.h"

/* UGLY FUNCTION BLEARGH */
void gspot_applet_build_menu(gspotData *gspot) {
  GtkWidget *google_w;
  GtkWidget *wikipedia_w;
  GtkWidget *distrowatch_w;
  GtkWidget *ebay_w;
  GtkWidget *mathworld_w;
  GtkWidget *webster_w;
  GtkWidget *ask_w;
  GtkWidget *answers_w;
  GtkWidget *dictionary_w;
  GtkWidget *imdb_w;
  GtkWidget *freedb_w;
  GtkWidget *bugs_debian_w;
  GtkWidget *packages_debian_w;
  GtkWidget *packages_qa_debian_w;
  GtkWidget *urban_dictionary_w;
  GtkWidget *separator1, *separator2, *separator3, *separator4, *separator5;
  
  GtkWidget *hbox;
  GtkWidget *label;
  GtkWidget *img;
  
  gspot->menu = gtk_menu_new();
  gtk_menu_set_screen(GTK_MENU(gspot->menu), gtk_widget_get_screen(gspot->applet));
  gtk_window_set_resizable(GTK_WINDOW(gspot->menu), TRUE);

  separator1 = gtk_separator_menu_item_new();
  separator2 = gtk_separator_menu_item_new();
  separator3 = gtk_separator_menu_item_new();
  separator4 = gtk_separator_menu_item_new();
  separator5 = gtk_separator_menu_item_new();
  
  hbox = gtk_hbox_new(FALSE, 5);
  
  img = gtk_image_new_from_file("/usr/share/pixmaps/gspot/google_16.xpm");
  gtk_box_pack_start(GTK_BOX(hbox), img, FALSE, TRUE, 0); 
  gtk_widget_show(img);
  label = gtk_label_new("Google");
  gtk_box_pack_start(GTK_BOX(hbox), label, FALSE, TRUE, 0);
  gtk_widget_show(label);
   
  google_w = gtk_menu_item_new();
  gtk_container_add(GTK_CONTAINER(google_w), hbox);
  gtk_widget_show(hbox);

  hbox = NULL;
  hbox = gtk_hbox_new(FALSE, 5);
  
  img = gtk_image_new_from_file("/usr/share/pixmaps/gspot/wikipedia_16.xpm");
  gtk_box_pack_start(GTK_BOX(hbox), img, FALSE, TRUE, 0); 
  gtk_widget_show(img);
  label = gtk_label_new("Wikipedia");
  gtk_box_pack_start(GTK_BOX(hbox), label, FALSE, TRUE, 0);
  gtk_widget_show(label);

  wikipedia_w = gtk_menu_item_new();
  gtk_container_add(GTK_CONTAINER(wikipedia_w), hbox);
  gtk_widget_show(hbox);

  hbox = NULL;
  hbox = gtk_hbox_new(FALSE, 5);
  
  img = gtk_image_new_from_file("/usr/share/pixmaps/gspot/distrowatch_16.xpm");
  gtk_box_pack_start(GTK_BOX(hbox), img, FALSE, TRUE, 0); 
  gtk_widget_show(img);
  label = gtk_label_new("DistroWatch");
  gtk_box_pack_start(GTK_BOX(hbox), label, FALSE, TRUE, 0);
  gtk_widget_show(label);

  distrowatch_w = gtk_menu_item_new();
  gtk_container_add(GTK_CONTAINER(distrowatch_w), hbox);
  gtk_widget_show(hbox);

  hbox = NULL;
  hbox = gtk_hbox_new(FALSE, 5);
  
  img = gtk_image_new_from_file("/usr/share/pixmaps/gspot/ebay_16.xpm");
  gtk_box_pack_start(GTK_BOX(hbox), img, FALSE, TRUE, 0); 
  gtk_widget_show(img);
  label = gtk_label_new("eBay");
  gtk_box_pack_start(GTK_BOX(hbox), label, FALSE, TRUE, 0);
  gtk_widget_show(label);

  ebay_w = gtk_menu_item_new();
  gtk_container_add(GTK_CONTAINER(ebay_w), hbox);
  gtk_widget_show(hbox);

  hbox = NULL;
  hbox = gtk_hbox_new(FALSE, 5);
  
  img = gtk_image_new_from_file("/usr/share/pixmaps/gspot/mathworld_16.xpm");
  gtk_box_pack_start(GTK_BOX(hbox), img, FALSE, TRUE, 0); 
  gtk_widget_show(img);
  label = gtk_label_new("Mathworld");
  gtk_box_pack_start(GTK_BOX(hbox), label, FALSE, TRUE, 0);
  gtk_widget_show(label);

  mathworld_w = gtk_menu_item_new();
  gtk_container_add(GTK_CONTAINER(mathworld_w), hbox);
  gtk_widget_show(hbox);

  hbox = NULL;
  hbox = gtk_hbox_new(FALSE, 5);
  
  img = gtk_image_new_from_file("/usr/share/pixmaps/gspot/webster_16.xpm");
  gtk_box_pack_start(GTK_BOX(hbox), img, FALSE, TRUE, 0); 
  gtk_widget_show(img);
  label = gtk_label_new("Webster");
  gtk_box_pack_start(GTK_BOX(hbox), label, FALSE, TRUE, 0);
  gtk_widget_show(label);

  webster_w = gtk_menu_item_new();
  gtk_container_add(GTK_CONTAINER(webster_w), hbox);
  gtk_widget_show(hbox);

  hbox = NULL;
  hbox = gtk_hbox_new(FALSE, 5);
  
  img = gtk_image_new_from_file("/usr/share/pixmaps/gspot/ask_16.xpm");
  gtk_box_pack_start(GTK_BOX(hbox), img, FALSE, TRUE, 0); 
  gtk_widget_show(img);
  label = gtk_label_new("Ask");
  gtk_box_pack_start(GTK_BOX(hbox), label, FALSE, TRUE, 0);
  gtk_widget_show(label);

  ask_w = gtk_menu_item_new();
  gtk_container_add(GTK_CONTAINER(ask_w), hbox);
  gtk_widget_show(hbox);

  hbox = NULL;
  hbox = gtk_hbox_new(FALSE, 5);
  
  img = gtk_image_new_from_file("/usr/share/pixmaps/gspot/answers_16.xpm");
  gtk_box_pack_start(GTK_BOX(hbox), img, FALSE, TRUE, 0); 
  gtk_widget_show(img);
  label = gtk_label_new("Answers");
  gtk_box_pack_start(GTK_BOX(hbox), label, FALSE, TRUE, 0);
  gtk_widget_show(label);

  answers_w = gtk_menu_item_new();
  gtk_container_add(GTK_CONTAINER(answers_w), hbox);
  gtk_widget_show(hbox);

  hbox = NULL;
  hbox = gtk_hbox_new(FALSE, 5);
  
  img = gtk_image_new_from_file("/usr/share/pixmaps/gspot/dictionary_16.xpm");
  gtk_box_pack_start(GTK_BOX(hbox), img, FALSE, TRUE, 0); 
  gtk_widget_show(img);
  label = gtk_label_new("Dictionary");
  gtk_box_pack_start(GTK_BOX(hbox), label, FALSE, TRUE, 0);
  gtk_widget_show(label);

  dictionary_w = gtk_menu_item_new();
  gtk_container_add(GTK_CONTAINER(dictionary_w), hbox);
  gtk_widget_show(hbox);
  
  hbox = NULL;
  hbox = gtk_hbox_new(FALSE, 5);
  
  img = gtk_image_new_from_file("/usr/share/pixmaps/gspot/imdb_16.xpm");
  gtk_box_pack_start(GTK_BOX(hbox), img, FALSE, TRUE, 0); 
  gtk_widget_show(img);
  label = gtk_label_new("Imdb");
  gtk_box_pack_start(GTK_BOX(hbox), label, FALSE, TRUE, 0);
  gtk_widget_show(label);

  imdb_w = gtk_menu_item_new();
  gtk_container_add(GTK_CONTAINER(imdb_w), hbox);
  gtk_widget_show(hbox);

  hbox = NULL;
  hbox = gtk_hbox_new(FALSE, 5);
  
  img = gtk_image_new_from_file("/usr/share/pixmaps/gspot/freedb_16.xpm");
  gtk_box_pack_start(GTK_BOX(hbox), img, FALSE, TRUE, 0); 
  gtk_widget_show(img);
  label = gtk_label_new("freedb");
  gtk_box_pack_start(GTK_BOX(hbox), label, FALSE, TRUE, 0);
  gtk_widget_show(label);

  freedb_w = gtk_menu_item_new();
  gtk_container_add(GTK_CONTAINER(freedb_w), hbox);
  gtk_widget_show(hbox);
  
  hbox = NULL;
  hbox = gtk_hbox_new(FALSE, 5);
  
  img = gtk_image_new_from_file("/usr/share/pixmaps/gspot/debian_16.xpm");
  gtk_box_pack_start(GTK_BOX(hbox), img, FALSE, TRUE, 0); 
  gtk_widget_show(img);
  label = gtk_label_new("bugs");
  gtk_box_pack_start(GTK_BOX(hbox), label, FALSE, TRUE, 0);
  gtk_widget_show(label);

  bugs_debian_w = gtk_menu_item_new();
  gtk_container_add(GTK_CONTAINER(bugs_debian_w), hbox);
  gtk_widget_show(hbox);

  hbox = NULL;
  hbox = gtk_hbox_new(FALSE, 5);
  
  img = gtk_image_new_from_file("/usr/share/pixmaps/gspot/debian_16.xpm");
  gtk_box_pack_start(GTK_BOX(hbox), img, FALSE, TRUE, 0); 
  gtk_widget_show(img);
  label = gtk_label_new("packages");
  gtk_box_pack_start(GTK_BOX(hbox), label, FALSE, TRUE, 0);
  gtk_widget_show(label);

  packages_debian_w = gtk_menu_item_new();
  gtk_container_add(GTK_CONTAINER(packages_debian_w), hbox);
  gtk_widget_show(hbox);

  hbox = NULL;
  hbox = gtk_hbox_new(FALSE, 5);
  
  img = gtk_image_new_from_file("/usr/share/pixmaps/gspot/debian_16.xpm");
  gtk_box_pack_start(GTK_BOX(hbox), img, FALSE, TRUE, 0); 
  gtk_widget_show(img);
  label = gtk_label_new("packages.qa");
  gtk_box_pack_start(GTK_BOX(hbox), label, FALSE, TRUE, 0);
  gtk_widget_show(label);

  packages_qa_debian_w = gtk_menu_item_new();
  gtk_container_add(GTK_CONTAINER(packages_qa_debian_w), hbox);
  gtk_widget_show(hbox);

  hbox = NULL;
  hbox = gtk_hbox_new(FALSE, 5);
  
  img = gtk_image_new_from_file("/usr/share/pixmaps/gspot/urban_dictionary_16.xpm");
  gtk_box_pack_start(GTK_BOX(hbox), img, FALSE, TRUE, 0); 
  gtk_widget_show(img);
  label = gtk_label_new("Urban Dictionary");
  gtk_box_pack_start(GTK_BOX(hbox), label, FALSE, TRUE, 0);
  gtk_widget_show(label);

  urban_dictionary_w = gtk_menu_item_new();
  gtk_container_add(GTK_CONTAINER(urban_dictionary_w), hbox);
  gtk_widget_show(hbox);
  
  g_signal_connect(google_w, "activate", G_CALLBACK(menu_google_cb), gspot);
  g_signal_connect(wikipedia_w, "activate", G_CALLBACK(menu_wikipedia_cb), gspot);
  g_signal_connect(distrowatch_w, "activate", G_CALLBACK(menu_distrowatch_cb), gspot );
  g_signal_connect(ebay_w, "activate", G_CALLBACK(menu_ebay_cb), gspot );
  g_signal_connect(mathworld_w, "activate", G_CALLBACK(menu_mathworld_cb), gspot );
  g_signal_connect(webster_w, "activate", G_CALLBACK(menu_webster_cb), gspot );
  g_signal_connect(ask_w, "activate", G_CALLBACK(menu_ask_cb), gspot );
  g_signal_connect(answers_w, "activate", G_CALLBACK(menu_answers_cb), gspot );
  g_signal_connect(dictionary_w, "activate", G_CALLBACK(menu_dictionary_cb), gspot );
  g_signal_connect(imdb_w, "activate", G_CALLBACK(menu_imdb_cb), gspot );
  g_signal_connect(freedb_w, "activate", G_CALLBACK(menu_freedb_cb), gspot );
  g_signal_connect(bugs_debian_w, "activate", G_CALLBACK(menu_bugs_debian_cb), gspot );
  g_signal_connect(packages_debian_w, "activate", G_CALLBACK(menu_packages_debian_cb), gspot );
  g_signal_connect(packages_qa_debian_w, "activate", G_CALLBACK(menu_packages_qa_debian_cb), gspot );
  g_signal_connect(urban_dictionary_w, "activate", G_CALLBACK(menu_urban_dictionary_cb), gspot );

  gtk_menu_shell_append(GTK_MENU_SHELL(gspot->menu), google_w);
  gtk_menu_shell_append(GTK_MENU_SHELL(gspot->menu), wikipedia_w);
  gtk_menu_shell_append(GTK_MENU_SHELL(gspot->menu), separator1); 
  gtk_menu_shell_append(GTK_MENU_SHELL(gspot->menu), distrowatch_w);
  gtk_menu_shell_append(GTK_MENU_SHELL(gspot->menu), ebay_w);
  gtk_menu_shell_append(GTK_MENU_SHELL(gspot->menu), mathworld_w);
  gtk_menu_shell_append(GTK_MENU_SHELL(gspot->menu), separator2);
  gtk_menu_shell_append(GTK_MENU_SHELL(gspot->menu), webster_w);
  gtk_menu_shell_append(GTK_MENU_SHELL(gspot->menu), dictionary_w);
  gtk_menu_shell_append(GTK_MENU_SHELL(gspot->menu), separator3);
  gtk_menu_shell_append(GTK_MENU_SHELL(gspot->menu), ask_w);
  gtk_menu_shell_append(GTK_MENU_SHELL(gspot->menu), answers_w);
  gtk_menu_shell_append(GTK_MENU_SHELL(gspot->menu), urban_dictionary_w);
  gtk_menu_shell_append(GTK_MENU_SHELL(gspot->menu), separator4);
  gtk_menu_shell_append(GTK_MENU_SHELL(gspot->menu), imdb_w);
  gtk_menu_shell_append(GTK_MENU_SHELL(gspot->menu), freedb_w);
  gtk_menu_shell_append(GTK_MENU_SHELL(gspot->menu), separator5);
  gtk_menu_shell_append(GTK_MENU_SHELL(gspot->menu), bugs_debian_w);
  gtk_menu_shell_append(GTK_MENU_SHELL(gspot->menu), packages_debian_w);
  gtk_menu_shell_append(GTK_MENU_SHELL(gspot->menu), packages_qa_debian_w);
  
  gtk_widget_show(separator1);
  gtk_widget_show(separator2);
  gtk_widget_show(separator3);
  gtk_widget_show(separator4);
  gtk_widget_show(separator5);
  gtk_widget_show(urban_dictionary_w);
  gtk_widget_show(google_w);
  gtk_widget_show(wikipedia_w);
  gtk_widget_show(imdb_w);
  gtk_widget_show(distrowatch_w);
  gtk_widget_show(dictionary_w);
  gtk_widget_show(ebay_w);
  gtk_widget_show(ask_w);  
  gtk_widget_show(freedb_w);
  gtk_widget_show(mathworld_w);
  gtk_widget_show(webster_w);
  gtk_widget_show(answers_w);
  gtk_widget_show(bugs_debian_w);
  gtk_widget_show(packages_debian_w);
  gtk_widget_show(packages_qa_debian_w);

  gtk_widget_show(gspot->menu);
}

gboolean got_selection(GtkClipboard *clipboard, const gchar *selection, gpointer data){ 
  gchar *complete_url;
  gchar *url = (gchar*)data;
  
  if( selection == NULL ){
    return FALSE;
  }
    
  complete_url = (gchar *)malloc(strlen(selection) + strlen(url)+1);
  
  if( complete_url == NULL )
    return FALSE;
  sprintf(complete_url, "%s%s", url, selection);
  
  if( complete_url == NULL )
    return FALSE;
  
#if (GTK_MAJOR_VERSION > 1)	
  { 
    GError *err = NULL;  
    
    gnome_url_show(complete_url, &err); 
    if (err != NULL)  
      {  
	fprintf(stderr, N_("Error: %s \n"), err->message); 
	g_error_free (err); 
      } 
  } 
#else 
  gnome_url_show(complete_url); 
#endif 
  return TRUE;
}

enum {
  LINK_TYPE_URL
};

/* When links are clicked */
static void links_clicked(GtkAboutDialog *about, const gchar *link, gpointer data)
{
  gchar *link_click;
  
  switch (GPOINTER_TO_INT (data)){
  case LINK_TYPE_URL:
    link_click = g_strdup (link);
    break;
  default:
    g_assert_not_reached ();
  }
  
  gnome_url_show(link_click, NULL);
  g_free(link_click);
}

/* Menu Callback : Display About window */
void menu_about_cb(BonoboUIComponent *uic, GtkWidget *applet, const gchar *verbname) {
static const gchar *authors[] = {
    "GeCC <gecc@mfa.kicks-ass.org>",
    "Norberto M. Lopes <shelika@mail.telepac.pt>",
    NULL
  };
  
  static const gchar *documenters[] = {
    NULL
  };
  
  static const gchar *translator_credits[] = {
    NULL
  };
    
  const char *website = "http://mfa.ath.cx/wiki/index.php/gspot";
  const char *website_label = _("Gspot Website");

  gtk_about_dialog_set_url_hook((GtkAboutDialogActivateLinkFunc) links_clicked,
				GINT_TO_POINTER (LINK_TYPE_URL), NULL);

  gtk_show_about_dialog (NULL,
			 "name",		_("gspot"),
			 "version",	VERSION,
			 "copyright",	"\xC2\xA9 2005 GeCC",
			 "comments",	"gspot for the GNOME Desktop Environment",
			 "authors",	authors,
			 "documenters",	documenters,
			 "translator-credits",	translator_credits,
			 "website", website,
			 "website-label", website_label,
			 "logo-icon-name",	"gspot-100x100",
			 NULL);
}

/* From charpick applet */
static void
get_menu_pos (GtkMenu *menu, gint *x, gint *y, gboolean *push_in, gpointer data)
{
	gspotData *gspot = data;
	GtkRequisition  reqmenu;
	gint tempx, tempy, width, height;
	gint screen_width, screen_height;
	
	gtk_widget_size_request (GTK_WIDGET (menu), &reqmenu);
	gdk_window_get_origin (GTK_WIDGET (gspot->applet)->window, &tempx, &tempy);
	gdk_window_get_geometry (GTK_WIDGET (gspot->applet)->window, NULL, NULL,
				 &width, &height, NULL);
	
	switch (panel_applet_get_orient (PANEL_APPLET (gspot->applet))) {
	case PANEL_APPLET_ORIENT_DOWN:
	  tempy += height;
	  break;
	case PANEL_APPLET_ORIENT_UP:
	  tempy -= reqmenu.height;
	  break;
	case PANEL_APPLET_ORIENT_LEFT:
	  tempx -= reqmenu.width;
	  break;
	case PANEL_APPLET_ORIENT_RIGHT:
	  tempx += width;
	  break;
	}
	screen_width = gdk_screen_width ();
	screen_height = gdk_screen_height ();
	*x = CLAMP (tempx, 0, MAX (0, screen_width - reqmenu.width));
	*y = CLAMP (tempy, 0, MAX (0, screen_height - reqmenu.height));
}

gboolean button_press_callback(GtkWidget *widget, GdkEventButton *event, gspotData *gspot){
  if(event->button == 1) {
    
    if(gspot->menu)
      gtk_menu_popup(GTK_MENU(gspot->menu), NULL, NULL, get_menu_pos, gspot, event->button, event->time);
    return TRUE;
  }
  
  return FALSE;
}

void applet_change_background_cb(PanelApplet *applet,
				 PanelAppletBackgroundType type,
				 GdkColor *color,
				 GdkPixmap *pixmap,
				 gspotData *gspot) {
  GtkRcStyle *rc_style;
  GtkStyle *style;
  
  /* Taken from gnome-applets (cpufreq) */
  /* reset style */
  gtk_widget_set_style (GTK_WIDGET (applet), NULL);
  rc_style = gtk_rc_style_new ();
  gtk_widget_modify_style (GTK_WIDGET (applet), rc_style);
  gtk_rc_style_unref (rc_style);

  switch (type) {
  case PANEL_PIXMAP_BACKGROUND:
    style = gtk_style_copy (GTK_WIDGET (applet)->style);
    if (style->bg_pixmap[GTK_STATE_NORMAL])
      g_object_unref (style->bg_pixmap[GTK_STATE_NORMAL]);
    style->bg_pixmap[GTK_STATE_NORMAL] = g_object_ref (pixmap);
    gtk_widget_set_style (GTK_WIDGET (applet), style);
    g_object_unref (style);
    break;
  case PANEL_COLOR_BACKGROUND:
    gtk_widget_modify_bg (GTK_WIDGET (applet), GTK_STATE_NORMAL, color);
    break;
  case PANEL_NO_BACKGROUND:
  default:
    break;
  }
}

void applet_change_size_cb(PanelApplet *applet, gint size, gspotData *gspot) {
  if (gspot->size != size)
    {
      GdkPixbuf *pixbuf;
      GdkPixbuf *scaled;
      
      size = 22;
      gspot->size = size;
      pixbuf = gdk_pixbuf_new_from_file ("/usr/share/pixmaps/gspot-100x100.png", NULL);
      if (pixbuf)
	{
	  scaled = gdk_pixbuf_scale_simple(pixbuf, size, size, GDK_INTERP_BILINEAR);
	  gtk_image_set_from_pixbuf (GTK_IMAGE (gspot->image), scaled);
	  
	  gtk_widget_show (gspot->image);
	  g_object_unref (G_OBJECT (pixbuf));
	}
    }
  
}
