Name: 		gstreamer-player
Version: 	0.6.0
Release: 	1
Summary: 	GStreamer Streaming media framework player.

Group: 		Applications/Multimedia
License: 	LGPL
URL:		http://gstreamer.net/
Vendor:         GStreamer Backpackers Team <package@gstreamer.net>
Source: 	gst-player-%{version}.tar.gz
BuildRoot: 	%{_tmppath}/%{name}-root

# spec file trickery, please don't look
%{expand:%%define buildforrh7 %(A=$(awk '{print $5}' /etc/redhat-release); if [ "$A" = 7.2 -o "$A" = 7.3 ]; then echo 1; else echo 0; fi)}
%{expand:%%define buildforrh8 %(A=$(awk '{print $5}' /etc/redhat-release); if [ "$A" = 8.0 -o "$A" = 8.1 ]; then echo 1; else echo 0; fi)}

Requires: 	libxml2
Requires: 	gtk2
Requires: 	glib2
Requires:	GConf2
Requires:	libgnomeui
Requires:	libglade2
Requires:	gstreamer >= 0.6.1
Requires:	gstreamer-plugins

# useful plug-ins
Requires:	gstreamer-colorspace
Requires:	gstreamer-mad
Requires:	gstreamer-plugins

BuildRequires: 	gtk2-devel
BuildRequires: 	glib2-devel
BuildRequires:	gstreamer-devel >= 0.5.2
BuildRequires:	gstreamer-plugins-devel >= 0.5.2
BuildRequires:	libgnomeui-devel
BuildRequires:	libglade2-devel
%if %buildforrh8
%{echo: Building for Red Hat 8.x}
%endif

%if %buildforrh7
%{echo: Building for Red Hat 7.x}
BuildRequires:  nautilus2-devel
%endif
BuildRequires:	eel2-devel

BuildRequires:	gail-devel
BuildRequires:	gstreamer-plugins
# until libxml2-devel requires zlib-devel, we need to do this
BuildRequires:  zlib-devel
BuildRequires:	gettext

%description
This package contains the GStreamer media player and libgstplay, a simple
GStreamer playback wrapper library.

%package -n gstreamer-player-devel
Summary:        GStreamer libgstplay development files.
Group:          Development/Libraries
Requires:       gstreamer-player = %{version}

%description -n gstreamer-player-devel
GStreamer libgstplay development libraries and headers.

%package -n gstreamer-player-mozilla
Summary:	Gstreamer Mozilla plugin
Group:		Applications/Multimedia
Requires:	gstreamer-player = %{version}

%description -n gstreamer-player-mozilla
GStreamer Mozilla browser plugin

%package -n gstreamer-player-nautilus
Summary:        GStreamer nautilus view.
Group:          Libraries/Multimedia
Requires:       gstreamer-player = %{version}
%if %buildforrh8
Requires:	nautilus
%endif
%if %buildforrh7
Requires:	nautilus2
%endif
Requires:	gail
Requires:	eel2

%description -n gstreamer-player-nautilus
GStreamer nautilus view for media files.

%prep
%setup -n gst-player-%{version}
%build
CFLAGS="${CFLAGS:-%optflags}" ; export CFLAGS ; \
CXXFLAGS="${CXXFLAGS:-%optflags}" ; export CXXFLAGS ; \
FFLAGS="${FFLAGS:-%optflags}" ; export FFLAGS ; \
## not doing the libtoolize thing because we don't really need it
## note that we have configure.in because of intltoolize needing it
## and thus libtoolize gets triggered
## %{?__libtoolize:[ -f configure.in ] && %{__libtoolize} --copy --force} ; \
./configure \
  --prefix=%{_prefix} \
  --exec-prefix=%{_exec_prefix} \
  --bindir=%{_bindir} \
  --sbindir=%{_sbindir} \
  --sysconfdir=%{_sysconfdir} \
  --datadir=%{_datadir} \
  --includedir=%{_includedir} \
  --libdir=%{_libdir} \
  --libexecdir=%{_libexecdir} \
  --localstatedir=%{_localstatedir} \
  --sharedstatedir=%{_sharedstatedir} \
  --mandir=%{_mandir} \
  --infodir=%{_infodir} \
  --enable-debug \
  --enable-static \
  --with-configdir=/etc/gstreamer \
  --disable-tests --disable-examples --disable-debug-color \
  --enable-docs-build

export GCONF_DISABLE_MAKEFILE_SCHEMA_INSTALL=1
if [ "$SMP" != "" ]; then
  (make "MAKE=make -k -j $SMP"; exit 0)
else
  make
fi

%makeinstall
# Clean out files that should not be part of the rpm.
# This is the recommended way of dealing with it for RH8
rm -f $RPM_BUILD_ROOT%{_libdir}/gst/*.la
rm -f $RPM_BUILD_ROOT%{_libdir}/*.la
rm -f $RPM_BUILD_ROOT%{_libdir}/mozilla/plugins/libmozstreamer.la


%clean
[ -n "$RPM_BUILD_ROOT" -a "$RPM_BUILD_ROOT" != / ] && rm -rf $RPM_BUILD_ROOT

%post
export GCONF_CONFIG_SOURCE=`gconftool-2 --get-default-source`
gconftool-2 --makefile-install-rule %{_sysconfdir}/gconf/schemas/gst-player.schemas > /dev/null
/sbin/ldconfig

%postun
/sbin/ldconfig

%files
%defattr(-, root, root)
%doc AUTHORS COPYING
%{_libdir}/libgstplayer.so.*
%{_bindir}/gst-player
%{_bindir}/gst-player-gtk
%{_sysconfdir}/gconf/schemas/gst-player.schemas
%{_mandir}/man1/gst*.*
%{_datadir}/applications/gst-player.desktop
%{_datadir}/gst-player/ui/*.png
%{_datadir}/gst-player/ui/mediacontrol.glade
%{_datadir}/gst-player/ui/playlist.glade
%{_datadir}/pixmaps/gst-player-48.png
%{_datadir}/application-registry/gst-player.applications
%{_datadir}/mime-info/gst-player.keys
%{_datadir}/locale/*/*/*
%{_datadir}/gst-player/ui/gst-player.glade

%files -n gstreamer-player-devel
%defattr(-, root, root)
%{_libdir}/libgstplayer.a
%{_libdir}/libgstplayer.so
%{_includedir}/gst-player-%{version}/gst/gstvideowidget.h
%{_includedir}/gst-player-%{version}/gst/gtk-playlist.h

%files -n gstreamer-player-nautilus
%defattr(-, root, root)
%{_libdir}/bonobo/servers/Gst-Player-Control.server
%{_libdir}/bonobo/servers/Gst-Player-View.server
%{_libexecdir}/gst-player-control
%{_libexecdir}/gst-player-view
%{_datadir}/gnome-2.0/ui/gst-player-view-ui.xml

%files -n gstreamer-player-mozilla
%{_libdir}/mozilla/plugins/libmozstreamer.so
%{_libdir}/mozilla/plugins/libmozstreamer.so.*
%{_libdir}/mozilla/plugins/libmozstreamer.a

%changelog
* Wed Jul 23 2003 Christian Schaller <Uraeus@gnome.org>
- Update file list and remove avi req

* Sat Jul 12 2003 Christian Schaller <Uraeus@gnome.org>
- Update SPEC for changes in gst-plugins to conform to RH package

* Wed Jul 02 2003 Christian Schaller <Uraeus@gnome.org>
- Cleaned up spec to reflect latest code cleanups

* Sun Jan 19 2003 Christian Schaller <Uraeus@gnome.org>
- Updated with playlist changes

* Sat Jan 11 2003 Christian Schaller <Uraeus@gnome.org>
- Added the gst-player-logo.png file

* Wed Oct 30 2002 Thomas Vander Stichele <thomas at apestaart dot org>
- adding gstreamer-play to buildreqs

* Wed Oct 30 2002 Thomas Vander Stichele <thomas at apestaart dot org>
- remove libgstplay

* Sat Oct 26 2002 Thomas Vander Stichele <thomas@apestaart.org>
- Fix location of bonobo servers

* Fri Oct 25 2002 Christian F.K. Schaller <Uraues@linuxrising.org>
- Fix reference to videowidget.h since it been renamed gstvideowidget.h
- Add gst-player-gtk binary

* Fri Oct 25 2002 Thomas Vander Stichele <thomas@apestaart.org>
- add eel2 to dependencies for nautilus
* Thu Oct 24 2002 Thomas Vander Stichele <thomas@apestaart.org>
- fixed other people's laziness by doing a proper list of files instead
  of asterisks all over
- fixed path of headers
- trying out a new trick with buildfor macro's

* Sun Oct 20 2002 Christian Schaller <Uraeus@linuxrising.org>
- There is no Nautilus2-devel package, fixing it to be Nautilus
- Added all manpages
- Removed .la files

* Fri Sep 20 2002 Thomas Vander Stichele <thomas@apestaart.org>
- added gstreamer-plugins-devel buildrequires (for gstreamer-libs.pc)
- added libglade deps
- added gstreamer-GConf deps
- added nautilus2 deps
- added gail deps
- split out packages to main, devel, and nautilus

* Sat Sep 14 2002 Thomas Vander Stichele <thomas@apestaart.org>
- moved libgstplay to prefix/lib

* Thu Aug 27 2002 Christian Schaller <Uraeus@linuxrising.org>
- Added media-player icon 
- Added Nautilus mime type files
- Added Nautilus view files

* Mon Aug 09 2002 Steve Baker <stevebaker_org@yahoo.co.uk>
- remove pixmaps dir and added ui dir

* Mon Jul 08 2002 Thomas Vander Stichele <thomas@apestaart.org>
- comment out the bonobo and nautilus stuff until it works properly

* Sun Jul 07 2002 Christian Schaller <Uraeus@linuxrising.org>
- Added the needed plugins as Requirements, apt and RC will want this

* Sat Jun 29 2002 Christian Schaller <Uraeus@linuxrising.org>
- Updated with latest changes

* Wed May 15 2002 Christian Fredrik Kalager Schaller <Uraeus@linuxrising.org>
- Added Nautilus view and i18n stuff

* Fri May 05 2002 Thomas Vander Stichele <thomas@apestaart.org>
- re-added new pixmaps
- went back to %configure, feels nicer

* Tue Feb 12 2002 Benjamin Otte <in7y118@public.uni-hamburg.de>
- removed pixmaps, they are statically linked now

* Tue Feb 05 2002 Thomas Vander Stichele <thomas@apestaart.org>
- changed location of pixmaps

* Sun Feb 03 2002 Thomas Vander Stichele <thomas@apestaart.org>
- adapted from other spec file
