/**
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.
 *
 */

#ifndef __GST_MEDIA_PLAY_CONTROL_H__
#define __GST_MEDIA_PLAY_CONTROL_H__

#include <gnome.h>
#include "gstmediaplay.h"

G_BEGIN_DECLS

#define GST_TYPE_CONTROL            (gst_control_get_type ())
#define GST_CONTROL(obj)            (GTK_CHECK_CAST ((obj), GST_TYPE_CONTROL, GstControl))
#define GST_CONTROL_CLASS(klass)    (GTK_CHECK_CLASS_CAST ((klass), GST_TYPE_CONTROL, GstControlClass))
#define GST_IS_CONTROL(obj)         (GTK_CHECK_TYPE ((obj), GST_TYPE_CONTROL))
#define GST_IS_CONTROL_CLASS(klass) (GTK_CHECK_CLASS_TYPE ((klass), GTK_TYPE_CONTROL))
#define GST_CONTROL_GET_CLASS(obj)  (GTK_CHECK_GET_CLASS ((obj), GST_TYPE_CONTROL, GstControlClass))

typedef struct _GstControl         GstControl;
typedef struct _GstControlClass    GstControlClass;
typedef struct _GstControlPrivate  GstControlPrivate;

struct _GstControl
{
	GtkVBox box;

	GstControlPrivate *_priv;
};

struct _GstControlClass
{
	GtkVBoxClass parent_class;

	void (*toggle_play)     (GstControl *control);
	void (*toggle_playlist) (GstControl *control);
	void (*toggle_info)		(GstControl *control);
	void (*next)            (GstControl *control);
	void (*previous)        (GstControl *control);
	void (*stop)            (GstControl *control);
	void (*toggle_fullscreen) (GstControl *control);
	void (*volume_change)   (GstControl *control);
	void (*seek_change)     (GstControl *control);
	void (*display_mode_change) (GstControl *control, GstMediaPlayMode display_mode);
};

GtkType     gst_control_get_type       (void);
GtkWidget*  gst_control_new            (GladeXML *xml, GladeXML *volume_xml);

void        gst_control_set_display_mode  (GstControl *control, GstMediaPlayMode display_mode);
void        gst_control_set_state  (GstControl *control, GstElementState old_state, GstElementState new_state);
void        gst_control_set_enable_seek (GstControl* control, gboolean enable);
void        gst_control_set_mute  (GstControl *control, gboolean mute);
void        gst_control_allow_fullscreen (GstControl* control, gboolean allow);
GtkAdjustment* gst_control_get_volume_adjustment (GstControl *control);
void        gst_control_set_time(GstControl *control, gint64 time_nanos);
void        gst_control_set_length(GstControl *control, gint64 length_nanos);
gchar*		gst_control_get_time_string(time_t seconds);

G_END_DECLS

#endif /* __GST_MEDIA_PLAY_CONTROL_H__ */
