/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 8; tab-width: 8 -*- */
/**
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.
 *
 */

#ifndef GST_PLAYER_VIEW_H
#define GST_PLAYER_VIEW_H

#include <libnautilus/nautilus-view.h>

#define GST_TYPE_PLAYER_VIEW	         (gst_player_view_get_type ())
#define GST_PLAYER_VIEW(obj)	         (GTK_CHECK_CAST ((obj), GST_TYPE_PLAYER_VIEW, GstPlayerView))
#define GST_PLAYER_VIEW_CLASS(klass)     (GTK_CHECK_CLASS_CAST ((klass), GST_TYPE_PLAYER_VIEW, GstPlayerViewClass))
#define GST_IS_PLAYER_VIEW(obj)	         (GTK_CHECK_TYPE ((obj), GST_TYPE_PLAYER_VIEW))
#define GST_IS_PLAYER_VIEW_CLASS(klass)  (GTK_CHECK_CLASS_TYPE ((klass), GST_TYPE_PLAYER_VIEW))

typedef struct GstPlayerViewDetails GstPlayerViewDetails;

typedef struct {
	NautilusView parent;
	GstPlayerViewDetails *details;
} GstPlayerView;

typedef struct {
	NautilusViewClass parent;
} GstPlayerViewClass;

GType gst_player_view_get_type (void);

#endif /* GST_PLAYER_VIEW_H */
