/* main.c for gstar */

#include "gstar.h"

GtkWidget *RAspin;
GtkWidget *DEspin;
GtkWidget *SCspin;
GtkWidget *MAGspin;
GtkWidget *LBLspin;
GtkWidget *MOspin;
GtkWidget *DAYspin;
GtkWidget *YRspin;
GtkWidget *HRspin;
GtkWidget *MINspin;
GtkWidget *listbox;
GtkWidget *filesel;
GtkWidget *menubar;
GtkItemFactory *factory;
GtkWidget *aboutwindow;
GtkWidget *aboutlabel;
GtkWidget *aboutbutton;
GtkWidget *table;

#ifndef HELPFILE
#define HELPFILE "/usr/local/share/starchart/gstar.help"
#endif

static GtkItemFactoryEntry show_items[] = {
        { "/Show", NULL, NULL, 0, "<Branch>" },
        { "/Show/Nebulae", NULL, 0, 0, "<CheckItem>" },
        { "/Show/Constellation boundaries", NULL, 0, 0, "<CheckItem>" },
        { "/Show/Constellation shapes", NULL, 0, 0, "<CheckItem>" },
        { "/Show/Constellation names", NULL, 0, 0, "<CheckItem>" },
        { "/Show/Planets", NULL, 0, 0, "<CheckItem>" },
	{ "/Help", NULL, NULL, 0, "<LastBranch>" },
        { "/Help/Usage", NULL, help, 0, NULL },
        { "/Help/About", NULL, about, 0, NULL },
      };

void get_main_menu( GtkWidget  *window,
		    GtkWidget **menubar ) {
  gint nshow_items = sizeof (show_items) / sizeof (show_items[0]);

  factory = gtk_item_factory_new (GTK_TYPE_MENU_BAR, "<main>", 
                                             NULL);

  gtk_item_factory_create_items (factory, nshow_items, show_items, NULL);

  if (menubar)
    *menubar = gtk_item_factory_get_widget (factory, "<main>");
}

void file_ok_sel (GtkWidget *w, GtkFileSelection *fs) {
  char filename[MAXSTR];
  strcpy(filename, 
	 gtk_file_selection_get_filename(GTK_FILE_SELECTION(fs)));
  make_chart(filename);
  gtk_widget_destroy(filesel);
}

void name_file (void) {
  filesel = gtk_file_selection_new("Name for postscript file");
  gtk_file_selection_set_filename (GTK_FILE_SELECTION(filesel), 
                                           "stars.ps");
  gtk_signal_connect (GTK_OBJECT (GTK_FILE_SELECTION (filesel)->ok_button),
                              "clicked", (GtkSignalFunc) file_ok_sel, filesel );
  gtk_signal_connect_object (GTK_OBJECT (GTK_FILE_SELECTION
					 (filesel)->cancel_button),
			     "clicked", (GtkSignalFunc) gtk_widget_destroy,
			     GTK_OBJECT (filesel));
  gtk_widget_show(filesel);
}

void delete_widget(GtkWidget *widget, gpointer data)
{
  gtk_widget_destroy(data);
}

void about(void) {

  aboutwindow = gtk_window_new(GTK_WINDOW_DIALOG);
  gtk_container_border_width(GTK_CONTAINER(aboutwindow), 5);
  gtk_window_position (GTK_WINDOW(aboutwindow), GTK_WIN_POS_MOUSE);
  gtk_window_set_title (GTK_WINDOW (aboutwindow), "About gstar");  
  
  table = gtk_table_new(2, 3, FALSE);
  gtk_container_add(GTK_CONTAINER(aboutwindow), table);
  
  aboutlabel = gtk_label_new("gstar is a GTK front end for starchart.\n \
  gstar (C)1999 Allin Cottrell\nDistributed under the GNU Public License.");
  gtk_table_attach_defaults(GTK_TABLE(table), aboutlabel, 0, 3, 0, 1);
  
  aboutbutton = gtk_button_new_with_label("Close");
  gtk_table_attach_defaults(GTK_TABLE(table), aboutbutton, 1, 2, 1, 2);
  
  gtk_signal_connect(GTK_OBJECT(aboutbutton), "clicked",
		     GTK_SIGNAL_FUNC(delete_widget),
		     aboutwindow);
  
  gtk_widget_show(aboutbutton);
  gtk_widget_show(aboutlabel);
  gtk_widget_show(table);
  gtk_widget_show(aboutwindow);  
}

void help(void) {
  view_file(HELPFILE, 0, 600, 400, 1);
}

      int main( int   argc,
                char *argv[] )
      {

        GtkWidget *window;
        GtkWidget *frame;
        GtkWidget *hbox;
        GtkWidget *main_vbox;
        GtkWidget *vbox;
        GtkWidget *vbox2;
        GtkWidget *button;
        GtkWidget *label;
        GtkAdjustment *adj;
	GList *glist=NULL;
	GtkTooltips *tips;
	gint i;

        /* Initialise GTK */
        gtk_init(&argc, &argv);

        make_userdir();

        window = gtk_window_new (GTK_WINDOW_TOPLEVEL);


        gtk_signal_connect (GTK_OBJECT (window), "destroy",
                            GTK_SIGNAL_FUNC (gtk_main_quit),
                            NULL);

        gtk_window_set_title (GTK_WINDOW (window), "gstar");

        main_vbox = gtk_vbox_new (FALSE, 5);
        gtk_container_set_border_width (GTK_CONTAINER (main_vbox), 10);
        gtk_container_add (GTK_CONTAINER (window), main_vbox);
	tips = gtk_tooltips_new ();

	get_main_menu (window, &menubar);
        gtk_box_pack_start (GTK_BOX (main_vbox), menubar, FALSE, TRUE, 0);
        gtk_widget_show (menubar);

        frame = gtk_frame_new ("View region");
        gtk_box_pack_start (GTK_BOX (main_vbox), frame, TRUE, TRUE, 0);
        
        vbox = gtk_vbox_new (FALSE, 0);
        gtk_container_set_border_width (GTK_CONTAINER (vbox), 5);
        gtk_container_add (GTK_CONTAINER (frame), vbox);
        
        hbox = gtk_hbox_new (FALSE, 0);
        gtk_box_pack_start (GTK_BOX (vbox), hbox, FALSE, TRUE, 5);
        
        vbox2 = gtk_vbox_new (FALSE, 0);
        gtk_box_pack_start (GTK_BOX (hbox), vbox2, TRUE, TRUE, 5);
        
	listbox = gtk_combo_new();
        gtk_entry_set_text(GTK_ENTRY(GTK_COMBO(listbox)->entry), "Cons");
	glist = g_list_append(glist, "Custom (below)");
        for (i=0;i<NUMCONS;i++) {
	  glist = g_list_append(glist, conlocs[i].name);
	}
        gtk_signal_connect(GTK_OBJECT(GTK_COMBO(listbox)->entry), "changed",
                             GTK_SIGNAL_FUNC (cons_set), NULL);
	gtk_combo_set_popdown_strings( GTK_COMBO(listbox), glist) ;
        gtk_box_pack_start (GTK_BOX (vbox2), listbox, FALSE, TRUE, 0);

        
        /* RA and DE spinners */
        
        hbox = gtk_hbox_new (FALSE, 0);
        gtk_box_pack_start (GTK_BOX (vbox), hbox, TRUE, TRUE, 5);
        
        vbox2 = gtk_vbox_new (FALSE, 0);
        gtk_box_pack_start (GTK_BOX (hbox), vbox2, TRUE, TRUE, 5);
        
        label = gtk_label_new ("R.A.");
        gtk_misc_set_alignment (GTK_MISC (label), 0, 0.5);
        gtk_box_pack_start (GTK_BOX (vbox2), label, FALSE, TRUE, 0);
        
        adj = (GtkAdjustment *) gtk_adjustment_new (0.0, 0.0, 24.0, 0.01,
                                                    1.0, 0.0);
        RAspin = gtk_spin_button_new (adj, 0.5, 2);
	gtk_tooltips_set_tip (tips, RAspin, 
			      "Set Right Ascension (0.00 to 24.00 hours)", NULL);
        gtk_spin_button_set_wrap (GTK_SPIN_BUTTON (RAspin), TRUE);
        gtk_spin_button_set_shadow_type (GTK_SPIN_BUTTON (RAspin),
                                         GTK_SHADOW_ETCHED_IN);
        gtk_box_pack_start (GTK_BOX (vbox2), RAspin, FALSE, TRUE, 0);
        
        vbox2 = gtk_vbox_new (FALSE, 0);
        gtk_box_pack_start (GTK_BOX (hbox), vbox2, TRUE, TRUE, 5);
        
        label = gtk_label_new ("Dec.");
        gtk_misc_set_alignment (GTK_MISC (label), 0, 0.5);
        gtk_box_pack_start (GTK_BOX (vbox2), label, FALSE, TRUE, 0);
        
        adj = (GtkAdjustment *) gtk_adjustment_new (0.0, -90.0, 90.0, 0.01,
                                                    10.0, 0.0);
        DEspin = gtk_spin_button_new (adj, 0.5, 2);
	gtk_tooltips_set_tip (tips, DEspin, 
			      "Set Declination (-90.00 to +90.00 degrees)", NULL);
        gtk_spin_button_set_wrap (GTK_SPIN_BUTTON (DEspin), TRUE);
        gtk_spin_button_set_shadow_type (GTK_SPIN_BUTTON (DEspin),
                                         GTK_SHADOW_ETCHED_IN);
        gtk_box_pack_start (GTK_BOX (vbox2), DEspin, FALSE, TRUE, 0);

        vbox2 = gtk_vbox_new (FALSE, 0);
        gtk_box_pack_start (GTK_BOX (hbox), vbox2, TRUE, TRUE, 5);

        label = gtk_label_new ("Scale");
        gtk_misc_set_alignment (GTK_MISC (label), 0, 0.5);
        gtk_box_pack_start (GTK_BOX (vbox2), label, FALSE, TRUE, 0);
        
        adj = (GtkAdjustment *) gtk_adjustment_new (10, 5, 60, 1,
                                                    1.0, 0.0);
        SCspin = gtk_spin_button_new (adj, 0.5, 0);
	gtk_tooltips_set_tip (tips, SCspin, 
			      "Set scale (N/S degrees)", NULL);
        gtk_spin_button_set_wrap (GTK_SPIN_BUTTON (SCspin), TRUE);
        gtk_spin_button_set_shadow_type (GTK_SPIN_BUTTON (SCspin),
                                         GTK_SHADOW_ETCHED_IN);
        gtk_box_pack_start (GTK_BOX (vbox2), SCspin, FALSE, TRUE, 0);

	/* end of first frame */

        frame = gtk_frame_new ("Degree of Detail");
        gtk_box_pack_start (GTK_BOX (main_vbox), frame, TRUE, TRUE, 0);
        
        vbox = gtk_vbox_new (FALSE, 0);
        gtk_container_set_border_width (GTK_CONTAINER (vbox), 5);
        gtk_container_add (GTK_CONTAINER (frame), vbox);
        
        /* limits spinners */
        
        hbox = gtk_hbox_new (FALSE, 0);
        gtk_box_pack_start (GTK_BOX (vbox), hbox, TRUE, TRUE, 5);
        
        vbox2 = gtk_vbox_new (FALSE, 0);
        gtk_box_pack_start (GTK_BOX (hbox), vbox2, TRUE, TRUE, 5);
        
        label = gtk_label_new ("maglim");
        gtk_misc_set_alignment (GTK_MISC (label), 0, 0.5);
        gtk_box_pack_start (GTK_BOX (vbox2), label, FALSE, TRUE, 0);
        
        adj = (GtkAdjustment *) gtk_adjustment_new (8.0, 0.0, 10.0, 0.5,
                                                    1, 0);
        MAGspin = gtk_spin_button_new (adj, 0.5, 1);
	gtk_tooltips_set_tip (tips, 
			      MAGspin,
            "Set magnitude limit (lower numbers for less detail)", NULL);
        gtk_spin_button_set_wrap (GTK_SPIN_BUTTON (RAspin), TRUE);
        gtk_spin_button_set_wrap (GTK_SPIN_BUTTON (MAGspin), TRUE);
        gtk_spin_button_set_shadow_type (GTK_SPIN_BUTTON (MAGspin),
                                         GTK_SHADOW_ETCHED_IN);
        gtk_box_pack_start (GTK_BOX (vbox2), MAGspin, FALSE, TRUE, 0);
        
        vbox2 = gtk_vbox_new (FALSE, 0);
        gtk_box_pack_start (GTK_BOX (hbox), vbox2, TRUE, TRUE, 5);
        
        label = gtk_label_new ("lbllim");
        gtk_misc_set_alignment (GTK_MISC (label), 0, 0.5);
        gtk_box_pack_start (GTK_BOX (vbox2), label, FALSE, TRUE, 0);
        
        adj = (GtkAdjustment *) gtk_adjustment_new (8.0, 0.0, 10.0, 0.5,
                                                    1, 0);
        LBLspin = gtk_spin_button_new (adj, 0.5, 1);
	gtk_tooltips_set_tip (tips, 
			      LBLspin,
            "Set labeling limit (lower numbers for less detail)", NULL);
        gtk_spin_button_set_wrap (GTK_SPIN_BUTTON (LBLspin), TRUE);
        gtk_spin_button_set_shadow_type (GTK_SPIN_BUTTON (LBLspin),
                                         GTK_SHADOW_ETCHED_IN);
        gtk_box_pack_start (GTK_BOX (vbox2), LBLspin, FALSE, TRUE, 0);


        /* end of second frame */

        frame = gtk_frame_new ("Time (for planets)");
        gtk_box_pack_start (GTK_BOX (main_vbox), frame, TRUE, TRUE, 0);
        
        vbox = gtk_vbox_new (FALSE, 0);
        gtk_container_set_border_width (GTK_CONTAINER (vbox), 5);
        gtk_container_add (GTK_CONTAINER (frame), vbox);
        
        /* date and time spinners */
        
        hbox = gtk_hbox_new (FALSE, 0);
        gtk_box_pack_start (GTK_BOX (vbox), hbox, TRUE, TRUE, 5);
        
        vbox2 = gtk_vbox_new (FALSE, 0);
        gtk_box_pack_start (GTK_BOX (hbox), vbox2, TRUE, TRUE, 5);
        
        label = gtk_label_new ("Month");
        gtk_misc_set_alignment (GTK_MISC (label), 0, 0.5);
        gtk_box_pack_start (GTK_BOX (vbox2), label, FALSE, TRUE, 0);
        
        adj = (GtkAdjustment *) gtk_adjustment_new (0, 1, 12, 1,
                                                    1, 0);
        MOspin = gtk_spin_button_new (adj, 0.5, 0);
        gtk_spin_button_set_wrap (GTK_SPIN_BUTTON (MOspin), TRUE);
        gtk_spin_button_set_shadow_type (GTK_SPIN_BUTTON (MOspin),
                                         GTK_SHADOW_ETCHED_IN);
        gtk_box_pack_start (GTK_BOX (vbox2), MOspin, FALSE, TRUE, 0);
        
        vbox2 = gtk_vbox_new (FALSE, 0);
        gtk_box_pack_start (GTK_BOX (hbox), vbox2, TRUE, TRUE, 5);
        
        label = gtk_label_new ("Day");
        gtk_misc_set_alignment (GTK_MISC (label), 0, 0.5);
        gtk_box_pack_start (GTK_BOX (vbox2), label, FALSE, TRUE, 0);
        
        adj = (GtkAdjustment *) gtk_adjustment_new (0, 1, 31, 1,
                                                    1, 0);
        DAYspin = gtk_spin_button_new (adj, 0.5, 0);
        gtk_spin_button_set_wrap (GTK_SPIN_BUTTON (DAYspin), TRUE);
        gtk_spin_button_set_shadow_type (GTK_SPIN_BUTTON (DAYspin),
                                         GTK_SHADOW_ETCHED_IN);
        gtk_box_pack_start (GTK_BOX (vbox2), DAYspin, FALSE, TRUE, 0);

        vbox2 = gtk_vbox_new (FALSE, 0);
        gtk_box_pack_start (GTK_BOX (hbox), vbox2, TRUE, TRUE, 5);

        label = gtk_label_new ("Year");
        gtk_misc_set_alignment (GTK_MISC (label), 0, 0.5);
        gtk_box_pack_start (GTK_BOX (vbox2), label, FALSE, TRUE, 0);
        
        adj = (GtkAdjustment *) gtk_adjustment_new (0, 0, 3000, 1,
                                                    1, 0);
        YRspin = gtk_spin_button_new (adj, 0.5, 0);
        gtk_spin_button_set_wrap (GTK_SPIN_BUTTON (YRspin), TRUE);
        gtk_spin_button_set_shadow_type (GTK_SPIN_BUTTON (YRspin),
                                         GTK_SHADOW_ETCHED_IN);
        gtk_box_pack_start (GTK_BOX (vbox2), YRspin, FALSE, TRUE, 0);

        hbox = gtk_hbox_new (FALSE, 0);
        gtk_box_pack_start (GTK_BOX (vbox), hbox, TRUE, TRUE, 5);
        
        vbox2 = gtk_vbox_new (FALSE, 0);
        gtk_box_pack_start (GTK_BOX (hbox), vbox2, TRUE, TRUE, 5);

        label = gtk_label_new ("Hour");
        gtk_misc_set_alignment (GTK_MISC (label), 0, 0.5);
        gtk_box_pack_start (GTK_BOX (vbox2), label, FALSE, TRUE, 0);
        
        adj = (GtkAdjustment *) gtk_adjustment_new (0, 0, 24, 1,
                                                    1, 0);
        HRspin = gtk_spin_button_new (adj, 0.5, 0);
        gtk_spin_button_set_wrap (GTK_SPIN_BUTTON (HRspin), TRUE);
        gtk_spin_button_set_shadow_type (GTK_SPIN_BUTTON (HRspin),
                                         GTK_SHADOW_ETCHED_IN);
        gtk_box_pack_start (GTK_BOX (vbox2), HRspin, TRUE, FALSE, 0);

        vbox2 = gtk_vbox_new (FALSE, 0);
        gtk_box_pack_start (GTK_BOX (hbox), vbox2, TRUE, TRUE, 5);

        label = gtk_label_new ("Minute");
        gtk_misc_set_alignment (GTK_MISC (label), 0, 0.5);
        gtk_box_pack_start (GTK_BOX (vbox2), label, FALSE, TRUE, 0);
        
        adj = (GtkAdjustment *) gtk_adjustment_new (0, 0, 60, 1,
                                                    1, 0);
        MINspin = gtk_spin_button_new (adj, 0.5, 0);
        gtk_spin_button_set_wrap (GTK_SPIN_BUTTON (MINspin), TRUE);
        gtk_spin_button_set_shadow_type (GTK_SPIN_BUTTON (MINspin),
                                         GTK_SHADOW_ETCHED_IN);
        gtk_box_pack_start (GTK_BOX (vbox2), MINspin, TRUE, FALSE, 0);



        /* Control buttons */
        hbox = gtk_hbox_new (FALSE, 0);
        gtk_box_pack_start (GTK_BOX (main_vbox), hbox, FALSE, TRUE, 0);
        
        button = gtk_button_new_with_label ("Planets");
	gtk_tooltips_set_tip (tips, button, 
			      "Info on locations of planets", NULL);
        gtk_signal_connect_object (GTK_OBJECT (button), "clicked",
                                   GTK_SIGNAL_FUNC (planet),
                                   (gpointer) 1);
        gtk_box_pack_start (GTK_BOX (hbox), button, TRUE, TRUE, 5);

        button = gtk_button_new_with_label ("  View  ");
	gtk_tooltips_set_tip (tips, button, 
			      "View starchart output using gv", NULL);
        gtk_signal_connect_object (GTK_OBJECT (button), "clicked",
                                   GTK_SIGNAL_FUNC (make_chart), NULL);
        gtk_box_pack_start (GTK_BOX (hbox), button, TRUE, TRUE, 5);

        button = gtk_button_new_with_label (" Update ");
	gtk_tooltips_set_tip (tips, button, 
			      "Update starchart in running gv", NULL);
        gtk_signal_connect_object (GTK_OBJECT (button), "clicked",
                                   GTK_SIGNAL_FUNC (make_chart), 
				   (gpointer) temp_filename);
        gtk_box_pack_start (GTK_BOX (hbox), button, TRUE, TRUE, 5);

        button = gtk_button_new_with_label ("  Save  ");
	gtk_tooltips_set_tip (tips, button, 
		       "Save starchart output to named postscript file", NULL);
        gtk_signal_connect_object (GTK_OBJECT (button), "clicked",
                                   GTK_SIGNAL_FUNC (name_file), NULL);
        gtk_box_pack_start (GTK_BOX (hbox), button, TRUE, TRUE, 5);

        button = gtk_button_new_with_label ("  Quit  ");
        gtk_signal_connect_object (GTK_OBJECT (button), "clicked",
                                   GTK_SIGNAL_FUNC (gtk_widget_destroy),
                                   GTK_OBJECT (window));
        gtk_box_pack_start (GTK_BOX (hbox), button, TRUE, TRUE, 5);

        gtk_widget_show_all (window);

	get_time();
	set_rcfile();

        /* Enter the event loop */
        gtk_main ();
          
        return(0);
      }



