// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _GSTREAMERMM_OBJECT_H
#define _GSTREAMERMM_OBJECT_H


#include <glibmm.h>

/* gstreamermm - a C++ wrapper for gstreamer
 *
 * Copyright 2008 The gstreamermm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gst/gstobject.h>
#include <glibmm/object.h>
#include <libxml++/nodes/node.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GstObject GstObject;
typedef struct _GstObjectClass GstObjectClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gst
{ class Object_Class; } // namespace Gst
namespace Gst
{

/** @addtogroup gstreamermmEnums Enums and Flags */

/**
 * @ingroup gstreamermmEnums
 * @par Bitwise operators:
 * <tt>%ObjectFlags operator|(ObjectFlags, ObjectFlags)</tt><br>
 * <tt>%ObjectFlags operator&(ObjectFlags, ObjectFlags)</tt><br>
 * <tt>%ObjectFlags operator^(ObjectFlags, ObjectFlags)</tt><br>
 * <tt>%ObjectFlags operator~(ObjectFlags)</tt><br>
 * <tt>%ObjectFlags& operator|=(ObjectFlags&, ObjectFlags)</tt><br>
 * <tt>%ObjectFlags& operator&=(ObjectFlags&, ObjectFlags)</tt><br>
 * <tt>%ObjectFlags& operator^=(ObjectFlags&, ObjectFlags)</tt><br>
 */
enum ObjectFlags
{
  OBJECT_DISPOSING = 1<<0,
  OBJECT_FLOATING = 1<<1,
  OBJECT_FLAG_LAST = 1<<4
};

/** @ingroup gstreamermmEnums */
inline ObjectFlags operator|(ObjectFlags lhs, ObjectFlags rhs)
  { return static_cast<ObjectFlags>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs)); }

/** @ingroup gstreamermmEnums */
inline ObjectFlags operator&(ObjectFlags lhs, ObjectFlags rhs)
  { return static_cast<ObjectFlags>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs)); }

/** @ingroup gstreamermmEnums */
inline ObjectFlags operator^(ObjectFlags lhs, ObjectFlags rhs)
  { return static_cast<ObjectFlags>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs)); }

/** @ingroup gstreamermmEnums */
inline ObjectFlags operator~(ObjectFlags flags)
  { return static_cast<ObjectFlags>(~static_cast<unsigned>(flags)); }

/** @ingroup gstreamermmEnums */
inline ObjectFlags& operator|=(ObjectFlags& lhs, ObjectFlags rhs)
  { return (lhs = static_cast<ObjectFlags>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs))); }

/** @ingroup gstreamermmEnums */
inline ObjectFlags& operator&=(ObjectFlags& lhs, ObjectFlags rhs)
  { return (lhs = static_cast<ObjectFlags>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs))); }

/** @ingroup gstreamermmEnums */
inline ObjectFlags& operator^=(ObjectFlags& lhs, ObjectFlags rhs)
  { return (lhs = static_cast<ObjectFlags>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs))); }

} // namespace Gst


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gst::ObjectFlags> : public Glib::Value_Flags<Gst::ObjectFlags>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gst
{


/** @defgroup GstBaseClasses gstreamermm Base Classes
 *  Wrapped GStreamer base classes (plug-ins and other classes derrive from
 *  these).
 */

/** Gst::Object - Base class for the GStreamer object hierarchy.
 * Gst::Object provides a root for the object hierarchy tree filed in by the
 * GStreamer library. It is currently a thin wrapper on top of Glib::Object.
 * It is an abstract class that is not very usable on its own.
 *
 * Gst::Object gives us basic refcounting, parenting functionality and
 * locking. Most of the function are just extended for special GStreamer needs
 * and can be found under the same name in the base class of Gst::Object which
 * is Glib::Object (e.g. Glib::Object::reference() becomes
 * Gst:Object::reference().
 *
 * In contrast to Glib::Object instances, Gst::Object adds a name property.
 * The functions set_name() and get_name() are used to set/get the name of the
 * object.
 *
 * Last reviewed on 2005-11-09 (0.9.4)
 * @ingroup GstBaseClasses
 */

class Object : public Glib::Object 
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef Object CppObjectType;
  typedef Object_Class CppClassType;
  typedef GstObject BaseObjectType;
  typedef GstObjectClass BaseClassType;

private:  friend class Object_Class;
  static CppClassType object_class_;

private:
  // noncopyable
  Object(const Object&);
  Object& operator=(const Object&);

protected:
  explicit Object(const Glib::ConstructParams& construct_params);
  explicit Object(GstObject* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~Object();

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  GstObject*       gobj()       { return reinterpret_cast<GstObject*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const GstObject* gobj() const { return reinterpret_cast<GstObject*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  GstObject* gobj_copy();

private:

  
public:
  /** Returns the entire set of flags for the object.
   */
   guint32 get_flags() const;
 
  //TODO: _MEMBER_GET(lock, lock, Glib::Mutex, GMutex)

  
  /** Sets the name of @a object, or gives @a object a guaranteed unique
   * name (if @a name is <tt>0</tt>).
   * This function makes a copy of the provided name, so the caller
   * retains ownership of the name it sent.
   * @param name New name of object.
   * @return <tt>true</tt> if the name could be set. Since Objects that have
   * a parent cannot be renamed, this function returns <tt>false</tt> in those
   * cases.
   * 
   * MT safe.  This function grabs and releases @a object's LOCK.
   */
  bool set_name(const Glib::ustring& name);
  
  /** Returns: the name of @a object. Glib::free() after usage.
   * @return The name of @a object. Glib::free() after usage.
   * 
   * MT safe. This function grabs and releases @a object's LOCK.
   */
  Glib::ustring get_name() const;
  
  /** Sets the parent of @a object to @a parent. The object's reference count will
   * be incremented, and any floating reference will be removed (see sink()).
   * 
   * This function causes the parent-set signal to be emitted when the parent
   * was successfully set.
   * @param parent New parent of object.
   * @return <tt>true</tt> if @a parent could be set or <tt>false</tt> when @a object
   * already had a parent or @a object and @a parent are the same.
   * 
   * MT safe. Grabs and releases @a object's LOCK.
   */
  bool set_parent(const Glib::RefPtr<Gst::Object>& parent);
  
  /** Returns: parent of @a object, this can be <tt>0</tt> if @a object has no
   * @return Parent of @a object, this can be <tt>0</tt> if @a object has no
   * parent. unref after usage.
   * 
   * MT safe. Grabs and releases @a object's LOCK.
   */
  Glib::RefPtr<Gst::Object> get_parent();
  
  /** Returns: parent of @a object, this can be <tt>0</tt> if @a object has no
   * @return Parent of @a object, this can be <tt>0</tt> if @a object has no
   * parent. unref after usage.
   * 
   * MT safe. Grabs and releases @a object's LOCK.
   */
  Glib::RefPtr<const Gst::Object> get_parent() const;
  
  /** Clear the parent of @a object, removing the associated reference.
   * This function decreases the refcount of @a object.
   * 
   * MT safe. Grabs and releases @a object's lock.
   */
  void unparent();
  
  /** Returns: the name prefix of @a object. Glib::free() after usage.
   * @return The name prefix of @a object. Glib::free() after usage.
   * 
   * MT safe. This function grabs and releases @a object's LOCK.
   */
  Glib::ustring get_name_prefix() const;
  
  /** Sets the name prefix of @a object to @a name_prefix.
   * This function makes a copy of the provided name prefix, so the caller
   * retains ownership of the name prefix it sent.
   * 
   * MT safe.  This function grabs and releases @a object's LOCK.
   * @param name_prefix New name prefix of @a object.
   */
  void set_name_prefix(const Glib::ustring& name_prefix);

  // Ignore default signal and error callback.
  

  /** Checks to see if there is any object named @a name in @a list. This function
   * does not do any locking of any kind. You might want to protect the
   * provided list with the lock of the owner of the list. This function
   * will lock each Gst::Object in the list to compare the name, so be
   * carefull when passing a list with a locked object.
   * @param list A list of Gst::Object to check through.
   * @param name The name to search for.
   * @return <tt>true</tt> if a Gst::Object named @a name does not appear in @a list,
   * <tt>false</tt> if it does.
   * 
   * MT safe. Grabs and releases the LOCK of each object in the list.
   */
  static bool check_uniqueness(const Glib::ListHandle<const Gst::Object>& list, const Glib::ustring& name);

  
  /** Check if @a object has an ancestor @a ancestor somewhere up in
   * the hierarchy.
   * @param ancestor A Gst::Object to check as ancestor.
   * @return <tt>true</tt> if @a ancestor is an ancestor of @a object.
   * 
   * MT safe. Grabs and releases @a object's locks.
   */
  bool has_ancestor(const Glib::RefPtr<const Gst::Object>& ancestor) const;

  /** Saves object into the parent XML node.
   * @param parent The parent XML node to save object into.
   * @return The new xmlpp::Node pointer with the saved object.
   */
  xmlpp::Node* save(xmlpp::Node* parent);
  

  /** Saves object into the parent XML node.
   * @param parent The parent XML node to save object into.
   * @return The new xmlpp::Node pointer with the saved object.
   */
  const xmlpp::Node* save(const xmlpp::Node* parent) const;

  
  /** Restores @a object with the data from the parent XML node.
   * @param self The XML node to load @a object from.
   */
  void restore(xmlpp::Node* self);
  
  /** Generates a string describing the path of @a object in
   * the object hierarchy. Only useful (or used) for debugging.
   * @return A string describing the path of @a object. You must
   * Glib::free() the string after usage.
   * 
   * MT safe. Grabs and releases the Gst::Object's LOCK for all objects
   * in the hierarchy.
   */
  Glib::ustring get_path_string();

 
  /** The deep notify signal is used to be notified of property changes. It is
   * typically attached to the toplevel bin to receive notifications from all
   * the elements contained in that bin.
   */
  //TODO: Maybe GParamSpec should be wrapped in glibmm?
  
  /**
   * @par Prototype:
   * <tt>void on_my_%deep_notify(const Glib::RefPtr<Object>& prop_object, GParamSpec* prop)</tt>
   */

  Glib::SignalProxy2< void,const Glib::RefPtr<Object>&,GParamSpec* > signal_deep_notify();


  /** Trigered whenever a new object is saved to XML. You can connect to this
   * signal to insert custom XML tags into the core XML.
   */
  //TODO: Use xmlpp::Node for parameter?
  
  /**
   * @par Prototype:
   * <tt>void on_my_%object_saved(GstXmlNodePtr xml_node)</tt>
   */

  Glib::SignalProxy1< void,GstXmlNodePtr > signal_object_saved();
  

  /** Emitted when the parent of an object is set.
   *
   * @par Prototype:
   * <tt>void on_my_%parent_set(const Glib::RefPtr<Object>& parent)</tt>
   */

  Glib::SignalProxy1< void,const Glib::RefPtr<Object>& > signal_parent_set();


  /** Emitted when the parent of an object is unset.
   *
   * @par Prototype:
   * <tt>void on_my_%parent_unset(const Glib::RefPtr<Object>& parent)</tt>
   */

  Glib::SignalProxy1< void,const Glib::RefPtr<Object>& > signal_parent_unset();


#ifdef GLIBMM_VFUNCS_ENABLED
  virtual xmlpp::Node* save_vfunc(xmlpp::Node* parent);
  virtual void restore_vfunc(xmlpp::Node* self_node);
#endif //GLIBMM_VFUNCS_ENABLED

protected:

  
public:

public:
  //C++ methods used to invoke GTK+ virtual functions:
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

protected:
  //GTK+ Virtual Functions (override these to change behaviour):
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

  //Default Signal Handlers::
#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
  virtual void on_deep_notify(const Glib::RefPtr<Object>& prop_object, GParamSpec* prop);
  virtual void on_object_saved(GstXmlNodePtr xml_node);
  virtual void on_parent_set(const Glib::RefPtr<Object>& parent);
  virtual void on_parent_unset(const Glib::RefPtr<Object>& parent);
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED


};

} // namespace Gst


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gst::Object
   */
  Glib::RefPtr<Gst::Object> wrap(GstObject* object, bool take_copy = false);
}


#endif /* _GSTREAMERMM_OBJECT_H */

