/*  Etalk header loading file
 *
 *  Copyright (C) 1994, 1995 Free Software Foundation
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 * 
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, you can either send email to this
 *  program's author (see below) or write to:
 * 
 *               The Free Software Foundation, Inc.
 *               675 Mass Ave.
 *               Cambridge, MA 02139, USA. 
 * 
 *  Please send bug reports, etc. to zappo@gnu.ai.mit.edu.
 * 
 * This file used to be in config.h.  it is not here to keep it
 * seperate from acconfig.h
 *
 * $Log: headers.h,v $
 * Revision 1.6  1995/04/05  00:56:31  zappo
 * changed how strings is read in
 *
 * Revision 1.5  1995/03/30  02:36:14  zappo
 * Added getenv if not defined in stdlib
 *
 * Revision 1.4  1995/03/25  04:24:36  zappo
 * Updated copyright
 *
 * Revision 1.3  1995/03/04  14:45:34  zappo
 * Moved inclusion of syslog.h into this file because it is used in
 * multiple places.
 *
 * Revision 1.2  1994/11/15  04:14:57  zappo
 * Fixed typo
 *
 * Revision 1.1  1994/11/15  04:14:13  zappo
 * Initial revision
 *
 *
 * Configuration variables to for setting up etalk to be compiled
 */
#ifndef HEADERS_H
#define HEADERS_H

/* The following includes are the defaults needed to do most things
 * within the etalk binary.  This gives me just one place where I must
 * do all this ick stuff.
 */

/* malloc, free, atoi : malloc is cast, and unknowns default to return  */
/*                      int, so there is no need to add those defs here */
#ifdef HAVE_STDLIB_H
#include <stdlib.h>
#else
extern char *getenv();
#endif

/* printf, FILE etc: What do you do without this stuff? */
#ifdef HAVE_STDIO_H
#include <stdio.h>
#endif

/* This from autoconf docs.
 */
#if STDC_HEADERS || HAVE_STRING_H || HAVE_STRINGS_H
#if HAVE_STRING_H
#include <string.h>
#else
#if HAVE_STRINGS_H
#include <strings.h>
#endif /* strings.h */
#endif /* string.h */
/* An ANSI string.h and pre-ANSI memory.h might conflict.  */
#if !STDC_HEADERS && HAVE_MEMORY_H
#include <memory.h>
#endif /* not STDC_HEADERS and HAVE_MEMORY_H */
#define bcopy(s, d, n) memcpy ((d), (s), (n))
#define bzero(s, n) memset ((s), 0, (n))
#else /* not STDC_HEADERS and not HAVE_STRING_H */
#include <strings.h>
/* memory.h and strings.h conflict on some systems.  */
#endif /* not STDC_HEADERS and not HAVE_STRING_H */

#if HAVE_SYS_TYPES_H == 1
# include <sys/types.h>
#else
typedef unsigned char u_char;
typedef unsigned short u_short;
typedef unsigned int u_int;
typedef unsigned long u_long;
#endif

/* This bit from autoconf documentation */
#if TIME_WITH_SYS_TIME
# include <sys/time.h>
# include <time.h>
#else
# if HAVE_SYS_TIME_H
#  include <sys/time.h>
# else
#  include <time.h>
# endif
#endif

#if HAVE_UNISTD_H == 1
# include <unistd.h>
#else
/* If we don't have any of these, we must devine timeval ourselves. */
#if ! defined HAVE_SYS_TIME_H && ! defined TM_IN_SYS_TIME
struct timeval {
  int tv_sec;
  int tv_usec;
};
#endif /* not TIME_H and not SYS_TIME_H */
#endif /* UNISTD_H */

/* What to do if this header file doesn't exist??? */
#ifdef HAVE_SYSLOG_H
#include <syslog.h>
#endif

/* If you don't have these, or the equivalent thereof, then you can't */
/* run this program, therefore, no checks are going to be made        */
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>

#endif /* HEADERS_H */

