/***************************************************************************
 *   Copyright (C) 2008 by Apocalypse  					   *
 *   muwee@gala.net  							   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/


#include <QtGui>
#include <QDebug>
#include <kconfig.h>
#include <kgenericfactory.h>
#include "form1.h"
#include "widg.h"
#include "ui_form.h"

K_PLUGIN_FACTORY(form1Factory, registerPlugin<form1>();)
K_EXPORT_PLUGIN(form1Factory("form1"));

form1::form1( QWidget * parent, const QVariantList&) 
	: KCModule(form1Factory::componentData(), parent)
{
	setupUi(this);
	dir.setPath("/usr/share/themes/");
	if (dir.exists()) 
	{
		filesel = dir.entryList(QDir::AllDirs | QDir::NoDotAndDotDot);
		QDir::setCurrent("/usr/share/themes/");
		for (i=0; i!=filesel.size()-1; i++) 
		{
			/*if (filesel.at(i)=="/usr/share/themes/qt4" && QDir::homePath().append("/.themes/qt4").exists()==0))
			QProcess processik.start("cp", QStringList()<<"-R"<<"/usr/share/themes/qt4"<<"~/.themes/");*/
			filesel[i]+="/gtk-2.0";
			dir.setPath(filesel.at(i));
			if (!dir.exists()) 
			{
				filesel.removeAt(i);
				i--;
			}
		}
	}
	varstr=QDir::homePath().append("/.themes");
	hometh=varstr+"/qt4";
	dirqt.setPath(hometh);
	if(dirqt.exists())
	{
		comboBox->insertItem(0,"Use current KDE style");
		warning->hide();
	}
	dir.setPath(varstr);
	if (dir.exists()) 
	{
		hilesel = dir.entryList(QDir::AllDirs | QDir::NoDotAndDotDot);
		QDir::setCurrent(varstr);
		for (i=0; i!=hilesel.size(); i++) 
		{
			hilesel[i]+="/gtk-2.0";
			dir.setPath(hilesel.at(i));
			if (dir.exists()) filesel.append(hilesel.at(i));
		}	
	}
	if (!filesel.isEmpty()) 
	{
		filesel.sort();
		for (i=1; i!=filesel.size(); i++) 
		{
			filesel[i].remove("/gtk-2.0");
			if (filesel.at(i)!="qt4") comboBox->addItem(filesel.at(i));
		}
	}
	//icons finding
	dir.setPath("/usr/share/icons/");
	if (dir.exists()) 
	{
		filesel = dir.entryList(QDir::AllDirs);
		QDir::setCurrent("/usr/share/icons/");
		for (i=1; i!=filesel.size()-1; i++) 
		{
			filesel[i]+="/index.theme";
			index.setFileName(filesel.at(i));
			if (!index.exists()) 
			{
				filesel.removeAt(i);
				i--;
			}
		}
	}
	varstr=QDir::homePath().append("/.icons");
	dir.setPath(varstr);
	if (dir.exists()) 
	{
		hilesel = dir.entryList(QDir::AllDirs);
		QDir::setCurrent(varstr);
		for (i=1; i!=hilesel.size(); i++) 
		{
			hilesel[i]+="/index.theme";
			index.setFileName(hilesel.at(i));
			if (index.exists()) filesel.append(hilesel.at(i));
		}	
	}
	if (!filesel.isEmpty()) 
	{
		filesel.sort();
		for (i=1; i!=filesel.size(); i++) 
		{
			filesel[i].remove("/index.theme");
			comboBox2->addItem(filesel.at(i));
		}
	}
	//others
	arg<<"--localprefix";
	proc.start("kde4-config", arg);
	if (proc.waitForFinished()) kdehome = proc.readLine();
	proc.close();
	if (kdehome.contains("\n")) kdehome.remove("\n");
	applyBox->setDisabled(true);
	applyBox->setChecked(true);
	p=0;
	fstr="Sans Serif";
	fsz=10;
	setButtons(KCModule::Apply);
	setFocusPolicy(Qt::ClickFocus);
	sett=new QSettings("gtk-kde4", "gtk-kde4");
	comboBox->setCurrentIndex((sett->value("StyleIndex")).toInt());
	comboBox2->setCurrentIndex((sett->value("Iconindex")).toInt());
	//language
	varstr=getenv("LANGUAGE");
	if (varstr=="ru") rus();
	if (varstr=="de") ger();
	else if (varstr=="ua") ukr();
	else if (varstr=="be") bel();
	else if (varstr=="ro") rom();
	else if (varstr=="fr") fra();
	else if (varstr=="es") spa();
	else if (varstr=="it") ita();
	else if (varstr=="pl") pol();
	else if (varstr=="eo") esp();
	else if (varstr=="zh_CN") chi();
	connect(aboutButton, SIGNAL(released()), this, SLOT(AboutReleased()));
	connect(CFButton, SIGNAL(released()), this, SLOT(CFReleased()));
	connect(comboBox, SIGNAL(currentIndexChanged(int)),this, SLOT(com1Ch()));
}

void form1::save () {
	pal=qApp->palette();
	if (applyBox->checkState()==2)
	{
		wincol<<pal.color(QPalette::Midlight)<<pal.color(QPalette::Button);
		wincol<<pal.color(QPalette::Disabled,QPalette::ButtonText);
		wincol<<pal.color(QPalette::ButtonText);
		wincol<<pal.color(QPalette::Highlight);
		wincol<<pal.color(QPalette::Disabled, QPalette::HighlightedText);
		wincol<<pal.color(QPalette::HighlightedText);
		wincol<<pal.color(QPalette::Window);
		wincol<<pal.color(QPalette::Disabled,QPalette::WindowText);
		wincol<<pal.color(QPalette::WindowText);
		for (i=0; i!=wincol.size(); i++)
		{
			colors<<QString::number(wincol.at(i).redF());
			colors[i]+=", ";
			colors[i]+=QString::number(wincol.at(i).greenF());
			colors[i]+=", ";
			colors[i]+=QString::number(wincol.at(i).blueF());
		}
	}
	if (comboBox->currentIndex()==0)
	{
	widg* widge = new widg(this);
	widge->move(1024,1024);
	widge->show();
	
	//i must keep this, till  Oxy fix
	QMenu* menu=new QMenu;
	QAction* act1=new QAction(menu);
	QAction* act2=new QAction(menu);
	act1->setText("             ");
	act2->setText("             ");
	menu->addAction(act1);
	menu->addAction(act2);	
	menu->move(widge->mapToGlobal(QPoint(225,90)));
	menu->show();
	//fix Oxy! ^
	
	QDir::setCurrent(QDir::homePath().append("/.themes/qt4/gtk-2.0/"));
	wpix=QPixmap(widge->size());
	wpix.fill(Qt::transparent);
	bpix=QPixmap(widge->size());
	bpix.fill(Qt::transparent);
	widge->render(&bpix,QPoint(0,0),QRect(0,0,640,1024), QWidget::DrawWindowBackground);
	widge->render(&wpix,QPoint(0,0),QRect(0,0,640,1024), QWidget::DrawChildren);
	//wpix.save("wpix.png",0, 100);
	pix=wpix.copy(QRect(5,5,93,22));
	pix.save("Buttons/button-normal.png",0, 100);
	pix.save("Buttons/button-default.png",0, 100);
	pix.save("Toolbar/toolbutton-normal.png",0, 100);
	pix.save("Toolbar/toolbutton-default.png",0, 100);
	pix.save("Combo/combo-normal.png",0, 100);
	pix=wpix.copy(QRect(5,30,93,22));
	pix.save("Buttons/button-prelight.png",0, 100);
	pix.save("Toolbar/toolbutton-prelight.png",0, 100);
	pix.save("Combo/combo-prelight.png",0, 100);
	pix=wpix.copy(QRect(5,55,93,22));
	pix.save("Buttons/button-pressed.png",0, 100);
	pix.save("Toolbar/toolbutton-pressed.png",0, 100);
	pix.save("Toolbar/toolbutton-toggled.png",0, 100);
	pix.save("Combo/combo-active.png",0, 100);
	pix=wpix.copy(QRect(5,80,93,22));
	pix.save("Buttons/button-insensitive.png",0, 100);
	pix.save("Combo/combo-insensitive.png",0, 100);
	//background
	pix=bpix.copy(QRect(524,1,1,1024));
	pix.save("Toolbar/bg.png",0,100);
	pix=bpix.copy(QRect(1,20,1,50));
	pix.save("Toolbar/toolbar.png",0,100);
	pix=bpix.copy(QRect(1,20,1,30));
	pix.save("Toolbar/toolbarbg.png",0,100);
	//chBox
	pix=wpix.copy(QRect(100,5, 23,23));
	pix=pix.scaled(19,19);
	pix.save("Check-Radio/check1.png",0,100);
	pix=wpix.copy(QRect(100,80, 23,23));
	pix=pix.scaled(19,19);
	pix.save("Check-Radio/check2.png",0,100);	
	pix=wpix.copy(QRect(100,30, 23,23));
	pix=pix.scaled(19,19);
	pix.save("Check-Radio/check3.png",0,100);
	pix=wpix.copy(QRect(100,105, 23,23));
	pix=pix.scaled(19,19);
	pix.save("Check-Radio/check4.png",0,100);
	pix=wpix.copy(QRect(100,55, 23,23));
	pix=pix.scaled(19,19);
	pix.save("Check-Radio/check5.png",0,100);
	pix=wpix.copy(QRect(100,130, 23,23));
	pix=pix.scaled(19,19);
	pix.save("Check-Radio/check6.png",0,100);
	//rbBox
	pix=wpix.copy(QRect(125,5, 23,23));
	pix=pix.scaled(17,17);
	pix.save("Check-Radio/option1.png",0,100);
	pix=wpix.copy(QRect(125,80, 23,23));
	pix=pix.scaled(17,17);
	pix.save("Check-Radio/option2.png",0,100);	
	pix=wpix.copy(QRect(125,30, 23,23));
	pix=pix.scaled(17,17);
	pix.save("Check-Radio/option3.png",0,100);
	pix=wpix.copy(QRect(125,105, 23,23));
	pix=pix.scaled(17,17);
	pix.save("Check-Radio/option4.png",0,100);
	pix=wpix.copy(QRect(125,55, 23,23));
	pix=pix.scaled(17,17);
	pix.save("Check-Radio/option5.png",0,100);
	pix=main;
	pix=wpix.copy(QRect(125,130, 23,23));
	pix=pix.scaled(17,17);
	pix.save("Check-Radio/option6.png",0,100);
	//pBar
	rota.rotate(90);
	pix=wpix.copy(QRect(5,155,300,30));
	pix.save("ProgressBar/trough-progressbar-horiz.png",0,100);
	pix=pix.transformed(rota);
	pix.save("ProgressBar/trough-progressbar-vert.png",0,100);
	pix=wpix.copy(QRect(5,190,300,30));
	pix.save("ProgressBar/progressbar-horiz.png",0,100);
	pix=pix.transformed(rota);
	pix.save("ProgressBar/progressbar-vert.png",0,100);
	//tbw
	pix=wpix.copy(QRect(355,5,75,24));
	pix.save("Tabs/tab-top-active.png",0,100);
	pix=pix.transformed(rota);
	pix.save("Tabs/tab-right-active.png",0,100);
	pix=pix.transformed(rota);
	pix.save("Tabs/tab-bottom-active.png",0,100);
	pix=pix.transformed(rota);
	pix.save("Tabs/tab-left-active.png",0,100);
	pix=wpix.copy(QRect(435,5,75,24));
	pix.save("Tabs/tab-top.png",0,100);
	pix.save("Tabs/notebook_top_flat.png",0,100);
	pix=pix.transformed(rota);
	pix.save("Tabs/tab-right.png",0,100);
	pix.save("Tabs/notebook_right_flat.png",0,100);
	pix=pix.transformed(rota);
	pix.save("Tabs/tab-bottom.png",0,100);
	pix.save("Tabs/notebook_bottom_flat.png",0,100);
	pix=pix.transformed(rota);
	pix.save("Tabs/tab-left.png",0,100);
	pix.save("Tabs/notebook_left_flat.png",0,100);
	//menubar, menu
	main=QPixmap(23,10);
	main.fill(Qt::transparent);
	pix=bpix.copy(QRect(1,1,1,10));
	pix.save("Menu-Menubar/menubar.png",0,100);
	pix=wpix.copy(225,30,60,25);
	pix.save("Menu-Menubar/menubar-item.png",0,100);
	main=QPixmap(menu->size());
	main.fill(Qt::transparent);
	pix=main;
	menu->render(&pix,QPoint(0,0),menu->visibleRegion(),QWidget::DrawChildren);
	pix.save("Menu-Menubar/menu.png",0,100);
	pix=wpix.copy(225,60,100,24);
	pix.save("Menu-Menubar/menuitem.png",0,100);
	//sBar
	pix=wpix.copy(QRect(150,5,19,126));
	pix.save("Scrollbars/slider-vert.png",0,100);
	pix=pix.transformed(rota);
	pix=pix.copy(0,0,pix.width()-1, pix.height()-1);
	pix.save("Scrollbars/slider-horiz.png",0,100);
	pix=wpix.copy(QRect(175,5,19,126));
	pix.save("Scrollbars/slider-vert-prelight.png",0,100);
	pix=pix.transformed(rota);
	pix=pix.copy(0,0,pix.width()-1, pix.height()-1);
	pix.save("Scrollbars/slider-horiz-prelight.png",0,100);
	pix=wpix.copy(QRect(200,5,19,126));
	pix.save("Scrollbars/slider-vert-insens.png",0,100);
	pix=pix.transformed(rota);
	pix.save("Scrollbars/slider-horiz-insens.png",0,100);
	pix.save("Scrollbars/slider-vert-insens.png",0,100);
	pix=wpix.copy(QRect(225,5,23,19));
	pix.save("Scrollbars/trough-scrollbar-vert.png",0,100);
	pix=pix.transformed(rota);
	pix.save("Scrollbars/trough-scrollbar-horiz.png",0,100);
	//arrows(steppers)
	pix=wpix.copy(QRect(20,250,16,20));
	pix.save("Scrollbars/stepper-up.png",0,100);
	pix=pix.transformed(rota);
	pix.save("Scrollbars/stepper-right.png",0,100);
	pix=pix.transformed(rota);
	pix.save("Scrollbars/stepper-down.png",0,100);
	pix=pix.transformed(rota);
	pix.save("Scrollbars/stepper-left.png",0,100);	
	pix=wpix.copy(QRect(20,270,16,20));
	pix.save("Scrollbars/stepper-up-prelight.png",0,100);
	pix=pix.transformed(rota);
	pix.save("Scrollbars/stepper-right-prelight.png",0,100);
	pix=pix.transformed(rota);
	pix.save("Scrollbars/stepper-down-prelight.png",0,100);
	pix=pix.transformed(rota);
	pix.save("Scrollbars/stepper-left-prelight.png",0,100);
	pix=wpix.copy(QRect(20,290,16,20));
	pix.save("Scrollbars/stepper-up-insens.png",0,100);
	pix=pix.transformed(rota);
	pix.save("Scrollbars/stepper-right-insens.png",0,100);
	pix=pix.transformed(rota);
	pix.save("Scrollbars/stepper-down-insens.png",0,100);
	pix=pix.transformed(rota);
	pix.save("Scrollbars/stepper-left-insens.png",0,100);
	//slider
	pix=wpix.copy(QRect(330,5,20,30));
	pix.save("Range/slider-horiz.png",0,100);
	pix=pix.transformed(rota);
	pix.save("Range/slider-vert.png",0,100);
	pix=wpix.copy(QRect(330,40,20,30));
	pix.save("Range/slider-horiz-prelight.png",0,100);
	pix=pix.transformed(rota);
	pix.save("Range/slider-vert-prelight.png",0,100);
	pix=wpix.copy(QRect(330,105,19,27));
	pix.save("Range/trough-horizontal.png",0,100);
	pix=pix.transformed(rota);
	pix.save("Range/trough-vertical.png",0,100);
	//table
	pix=wpix.copy(QRect(355,55,77,25));
	pix.save("ListHeaders/list_header.png",0,100);
	pix=wpix.copy(QRect(355,85,77,25));
	pix.save("ListHeaders/list_header-prelight.png",0,100);
	pix=wpix.copy(QRect(355,115,77,25));
	pix.save("ListHeaders/list_header-pressed.png",0,100);
	//arrows
	pix=wpix.copy(QRect(435,55,15,16));
	pix.save("Arrows/arrow-up.png",0,100);
	pix=wpix.copy(QRect(435,75,15,16));
	pix.save("Arrows/arrow-down-prelight.png",0,100);
	pix.save("Arrows/arrow-down.png",0,100);
	pix=wpix.copy(QRect(435,95,15,16));
	pix.save("Arrows/arrow-left-prelight.png",0,100);
	pix.save("Arrows/arrow-left.png",0,100);
	pix=wpix.copy(QRect(435,115,15,16));
	pix.save("Arrows/arrow-right-prelight.png",0,100);
	pix.save("Arrows/arrow-right-norm.png",0,100);
	pix=wpix.copy(QRect(438,119,9,10));
	//pix=pix.scaled(9,8, Qt::IgnoreAspectRatio, Qt::SmoothTransformation);
	pix.save("Menu-Menubar/menu-arrow.png",0,100);
	pix.save("Menu-Menubar/menu-arrow-prelight.png",0,100);
	pix=wpix.copy(QRect(435,135,15,16));
	widge->hide();
	delete menu;
	}
	
	//writing to file
	gtkrc2=getenv("GTK2_RC_FILES");
	if (gtkrc2.contains(":")) gtkrc2.remove(":");
	gtkrc=getenv("GTK_RC_FILES");
	if (gtkrc.contains(":")) gtkrc.remove(":");
	file.setFileName(gtkrc2);
	if (!file.exists())
	{
		varstr=kdehome.append("share/config/gtkrc-2.0");
		if (varstr.contains("\n")) varstr.remove("\n");
		file.setFileName(varstr);
	}
	varfile.setFileName(gtkrc);
	if (!varfile.exists())
	{	
		varstr.clear();
		varstr=kdehome.append("share/config/gtkrc");
		if (varstr.contains("\n")) varstr.remove("\n");
		varfile.setFileName(varstr);
		gtkrc=varstr;
	}
	file.setPermissions(QFile::WriteOwner);
	varfile.setPermissions(QFile::WriteOwner);
	varfile.remove();
	file.remove();
	file.open(QFile::WriteOnly);
	QTextStream out(&file);
	if (comboBox->currentIndex()!=0)
	{
		out<<"include \"/usr/share/themes/"<<comboBox->currentText()<<"/gtk-2.0/gtkrc\""<<endl;
		out<<"include \""<<QDir::homePath()<<"/.themes/"<<comboBox->currentText()<<"/gtk-2.0/gtkrc\""<<endl;
	}else{
		out<<"include \"/usr/share/themes/qt4/gtk-2.0/gtkrc\""<<endl;
		out<<"include \""<<QDir::homePath()<<"/.themes/qt4/gtk-2.0/gtkrc\""<<endl;
	}
	out<<"style \"user-font\""<<endl;
	out<<"{ "<<endl;
	out<<"font_name=\""<<fstr<<" "<<fsz<<" "<<fst<<" "<<fw<<"\""<<endl;
	if (applyBox->checkState()==2) {
	out<<"fg[NORMAL] = {"<<colors.at(3)<<" }"<<endl;
	out<<"bg[NORMAL] = {"<<colors.at(1)<<" }"<<endl;
    out<<"text[NORMAL] = {"<<colors.at(9)<<" }"<<endl;
    out<<"base[NORMAL] = {"<<colors.at(7)<<" }"<<endl;
	
	out<<"fg[ACTIVE] = {"<<colors.at(3)<<" }"<<endl;
	out<<"bg[ACTIVE] = {"<<colors.at(1)<<" }"<<endl;
    out<<"text[ACTIVE] = {"<<colors.at(9)<<" }"<<endl;
    out<<"base[ACTIVE] = {"<<colors.at(7)<<" }"<<endl;
   
    out<<"fg[PRELIGHT] = {"<<colors.at(3)<<" }"<<endl;
	out<<"bg[PRELIGHT] = {"<<colors.at(0)<<" }"<<endl;
    out<<"text[PRELIGHT] = {"<<colors.at(9)<<" }"<<endl;
    out<<"base[PRELIGHT] = {"<<colors.at(7)<<" }"<<endl;
    
    out<<"fg[SELECTED] = {"<<colors.at(6)<<" }"<<endl;
	out<<"bg[SELECTED] = {"<<colors.at(4)<<" }"<<endl;
    out<<"text[SELECTED] = {"<<colors.at(6)<<" }"<<endl;
    out<<"base[SELECTED] = {"<<colors.at(4)<<" }"<<endl;
	
	out<<"fg[INSENSITIVE] = {"<<colors.at(3)<<" }"<<endl;
	out<<"bg[INSENSITIVE] = {"<<colors.at(1)<<" }"<<endl;
    out<<"text[INSENSITIVE] = {"<<colors.at(8)<<" }"<<endl;
    out<<"base[INSENSITIVE] = {"<<colors.at(7)<<" }"<<endl;
    } 
	out<<"}"<<endl;
	out<<"widget_class \"*\" style \"user-font\""<<endl;
	out<<"gtk-theme-name=\""<<comboBox->currentText()<<"\""<<endl;
	out<<"gtk-font-name=\""<<fstr<<" "<<fsz<<" "<<fst<<" "<<fw<<"\""<<endl;
	out<<"gtk-icon-theme-name=\""<<comboBox2->currentText()<<"\""<<endl;
	file.flush();
	file.close();
	file.setPermissions(QFile::ReadOwner);
	file.copy(gtkrc);
	varfile.setPermissions(QFile::ReadOwner);
	sett->setValue("StyleIndex", comboBox->currentIndex());
	sett->setValue("IconIndex", comboBox2->currentIndex());
}

void form1::AboutReleased () {
	about1* about=new about1;
	about->show();
}

void form1::CFReleased() {
	bool ok;
	QFont font = QFontDialog::getFont(&ok,this);
	if (ok) {
	fstr=font.defaultFamily();
	fsz=font.pointSize();	
	j=font.style();
	i=font.weight();
	if (j==0) fst.clear();
	if (j==1) fst="Italic";
	if (j==2) fst="Oblique";
	if (i==25) fw="Light";
	if (i==50) fw.clear();
	if (i==63) fw="DemiBold";
	if (i==75) fw="Bold";
	if (i==87) fw="Black";
	}
}

void form1::com1Ch() {
	changed();
	if (comboBox->currentIndex()==0)
	{
		applyBox->setDisabled(true);
		applyBox->setChecked(true);
		
	}
	else
	{
		applyBox->setDisabled(false);
		applyBox->setChecked(false);
	}
}

about1::about1(QWidget * parent):QDialog(parent)
{
	this->setWindowTitle("About GTK-KDE4");
	QLabel *label = new QLabel(this);
	QLabel *label2 = new QLabel(this);
	QLabel *name = new QLabel(this);
	font.setBold(true);
	font.setPointSize(18);
	name->setFont(font);
	name->setText("GTK-KDE4");
	name->move(140,5);
	font.setPointSize(12);
	label2->setText("Konchunas Yulian (muwee@gala.net)");
	label2->setFont(font);
	label->setAlignment(Qt::AlignHCenter);
	label->setText(QString::fromUtf8(
"Thanks to:\n"
"Kulik Max for French (faust_13may@mail.ru)\n"
"Ivan Babrou for Belorussian (ibobrik@gmail.com)\n"
"Fadeev Dmitriy for Romanian (nagohack@gmail.com)\n"
"Nikita Kungurov for Esperanto (maristo147@gmail.com)\n"
"Mikko C. for Italian\n"
"Agata Pilip for Polish\n"
"Jesús Vidal for Spanish (jesusvpct@vodafone.es)\n"
"Cornelius Maihöfer for German (maihoefer@gmail.com)\n"
"Ni Hui for Chinese (shuizhuyuanluo@126.com)\n"
"Skoskin Andrey for help and support (rooteg.org@gmail.com)\n\n"
"If you have any questions, ideas, translations etc.\n"
"send them to author's mail\n"
"version 0.8b\n"
"Copyright(C) Apocalypse 2008"
));
	label->move(20,60);
	label2->move(60,35);
	this->resize(400,310);
}

void form1::rus() {
	if(dirqt.exists()) comboBox->setItemText(0,QString::fromUtf8("Использовать текущий стиль KDE"));
	else warning->setText(QString::fromUtf8("Внимание: У Вас не установлена тема qt4. Применение стиля KDE к GTK программам невозможно!"));
	label->setText(QString::fromUtf8("Выберите стиль:"));
	applyBox->setText(QString::fromUtf8("Применить цвета KDE к GTK приложениям"));
	CFButton->setText(QString::fromUtf8("Сменить шрифт"));
	label2->setText(QString::fromUtf8("Выберите иконки:"));
	aboutButton->setText(QString::fromUtf8("О программе"));
}

void form1::ger() {
	if (dirqt.exists()) comboBox->setItemText(0,QString::fromUtf8("Den aktuellen KDE-Stil benutzen"));
	else warning->setText(QString::fromUtf8("Achtung: Der Qt4 Stil ist nicht installiert. Somit kann der KDE-Stil nicht auf GTK Programme angewendet werden!"));
	label->setText(QString::fromUtf8("Stil auswählen:"));
	applyBox->setText(QString::fromUtf8("Das KDE-Farbschema auch auf GTK-Programme anwenden"));
	CFButton->setText(QString::fromUtf8("Schriftart auswählen"));
	label2->setText(QString::fromUtf8("Symbole auswählen:"));
	aboutButton->setText(QString::fromUtf8("Über das Programm"));
}

void form1::ukr() {
	if (dirqt.exists()) comboBox->setItemText(0,QString::fromUtf8("Використовувати данний стиль KDE"));
	else warning->setText(QString::fromUtf8("Увага: у Вас не встановлена тема Qt4. Використання стилю KDE к GTK програмам неможливо!"));
	label->setText(QString::fromUtf8("Виберіть стиль:"));
	applyBox->setText(QString::fromUtf8("Використати кольори KDE к програмам GTK"));
	CFButton->setText(QString::fromUtf8("Змінити шрифт"));
	label2->setText(QString::fromUtf8("Виберiть iконки:"));
	aboutButton->setText(QString::fromUtf8("Про програму"));
}

void form1::bel() {
	if(dirqt.exists()) comboBox->setItemText(0,QString::fromUtf8("Выкарыстоўваць цяперашні стыль KDE"));
	else warning->setText(QString::fromUtf8("Увага, у вас не ўсталявана тэма qt4. Выкарыстоўваньне стылю KDE да GTK праграм немагчыма!"));
	label->setText(QString::fromUtf8("Выбераце стыль:"));
	applyBox->setText(QString::fromUtf8("Выкарыстоўваць колеры для KDE і GTK праграм"));
	CFButton->setText(QString::fromUtf8("Зьмяніць шрыфт"));
	aboutButton->setText(QString::fromUtf8("Пра праграму"));
}

void form1::rom() {
	if  (dirqt.exists()) comboBox->setItemText(0,QString::fromUtf8("Utilizeazâ stilul KDE curent"));
	else warning->setText(QString::fromUtf8("Atentie: Stilul QT4 nu e instalat. Aplicarea stilului KDE la GTK e imposibila."));
	label->setText(QString::fromUtf8("Alegeţi stilul:"));
	applyBox->setText(QString::fromUtf8("Aplică culorele KDE la programele GTK"));
	CFButton->setText(QString::fromUtf8("Schimba caracterele"));
	label2->setText("Alegeţi insignele:");
	aboutButton->setText(QString::fromUtf8("Despre program"));
}

void form1::fra() {
	if(dirqt.exists()) comboBox->setItemText(0,QString::fromUtf8("Utiliser le style courant KDE"));
	label->setText(QString::fromUtf8("Choisissez le style:"));
	applyBox->setText(QString::fromUtf8("Appliquer les couleurs KDE vers GTK aux applications"));
	CFButton->setText(QString::fromUtf8("Remplacer la police"));
	label2->setText(QString::fromUtf8("Choisirez les insignes:"));
	aboutButton->setText(QString::fromUtf8("Sur le programme"));
}

void form1::spa() {
	if(dirqt.exists()) comboBox->setItemText(0,QString::fromUtf8("Utilizar el estilo actual de KDE"));
	else warning->setText(QString::fromUtf8("Attenzione: Il tema Qt4 non è installato, impossibile applicare lo stile di KDE alle applicazioni GTK!"));
	label->setText(QString::fromUtf8("Seleccionar estilo:"));
	applyBox->setText(QString::fromUtf8("Aplicar los colores KDE a las aplicaciones GTK"));
	CFButton->setText(QString::fromUtf8("Cambiar la fuente"));
	label2->setText(QString::fromUtf8("Seleccionar iconos:"));
	aboutButton->setText(QString::fromUtf8("Acerca de"));
}

void form1::ita() {
	if (dirqt.exists()) comboBox->setItemText(0,QString::fromUtf8("Usa lo stile attuale di KDE"));
	label->setText(QString::fromUtf8("Seleziona stile:"));
	applyBox->setText(QString::fromUtf8("Applica i colori di KDE alle applicazioni GTK"));
	CFButton->setText(QString::fromUtf8("Cambia Caratteri"));
	label2->setText(QString::fromUtf8("Seleziona icone:"));
	aboutButton->setText(QString::fromUtf8("Informazioni"));
}

void form1::pol() {
	if(dirqt.exists()) comboBox->setItemText(0,QString::fromUtf8("Zastosuj aktualny styl KDE"));
	label->setText(QString::fromUtf8("Wybierz inny styl:"));
	applyBox->setText(QString::fromUtf8("Użyj palety kolorów KDE także dla aplikacji GTK"));
	CFButton->setText(QString::fromUtf8("Wybierz czcionkę"));
	label2->setText(QString::fromUtf8("Wybierz ikony:"));
	aboutButton->setText(QString::fromUtf8("O programie"));
}

void form1::esp() {
	if(dirqt.exists()) comboBox->setItemText(0,QString::fromUtf8("Uzi nunan aspekton de KDE"));
	else warning->setText("Atento: Aspekto de qt4 ne estas instalita. Apliko de KDE'a aspekto al GTK'aj programoj ne estas ebla.");
	label->setText(QString::fromUtf8("Elektu aspekton:"));
	applyBox->setText(QString::fromUtf8("Apliki kolorojn al KDE kaj GTK programoj"));
	CFButton->setText(QString::fromUtf8("Ŝanĝi tiparon"));
	label2->setText(QString::fromUtf8("Elektu bildetojn:"));
	aboutButton->setText(QString::fromUtf8("Pri programo"));
}

void form1::chi() {
	if(dirqt.exists()) comboBox->setItemText(0,QString::fromUtf8("使用当前的 KDE 样式"));
	label->setText(QString::fromUtf8("选择样式："));
	applyBox->setText(QString::fromUtf8("对 GTK 程序应用 KDE 配色"));
	CFButton->setText(QString::fromUtf8("更改字体"));
	label2->setText(QString::fromUtf8("选择图标："));
	aboutButton->setText(QString::fromUtf8("关于"));
}

//QPixmap joined(pm.width() * 2, pm.height(); pm.fill(0x0); QPainter p(&joined); p.drawPixmap(0, 0, pm); p.scale(-1, 1); p.drawPixmap(-joined.width(), 0, pm); p.end();
void form1::load(){
	applyBox->setChecked(false);
	comboBox->setCurrentIndex((sett->value("StyleIndex")).toInt());
	comboBox2->setCurrentIndex((sett->value("Iconindex")).toInt());
}
void form1::defaults(){}

void form1::resizeEvent(QResizeEvent* event) {
	CFButton->move(10,this->height()-50);
	aboutButton->move(this->width()-10-aboutButton->width(),this->height()-20-aboutButton->height());
	z=event->oldSize().width()-this->width();
	comboBox->resize(this->width()-comboBox->x()-20, comboBox->height());
	comboBox2->resize(comboBox->width(), comboBox2->height());
	warning->move((this->width()-warning->width())/2, aboutButton->y()-20);
}

void form1::enterEvent(QEvent*) {
	changed(true);
}
 void form1::closeEvent(QCloseEvent* event) {
	event->accept();
	save();
}

