/*
 *     gtkatlantic - the gtk+ monopd client, enjoy network monopoly games
 *
 *
 *  Copyright (C) 2002-2003 Rochet Sylvain
 *
 *  gtkatlantic is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <stdlib.h>
#include <stdio.h>
#include <unistd.h>
#include <glib.h>
#include <string.h>

#include "engine.h"


void eng_conv_8_to_mask(guchar * in, guchar * out, guint32 nb_pixel) {
   
	guint32 i, size_in, size_out;

	size_in  = size_out = calc_buf_size(nb_pixel, 1, 8);

	for(i = 0; i < nb_pixel; i++)  {

		if(in[i] != 0)   out[i] = 0xff;
		else  out[i] = 0x00;
	}
}


void eng_conv_16_to_mask(guchar * in, guchar * out, guint32 nb_pixel) {
   
	guint32 i, size_in, size_out;

	size_in  = calc_buf_size(nb_pixel, 1, 16);
	size_out = calc_buf_size(nb_pixel, 1, 8);

	for(i = 0; i < nb_pixel; i++)  {

		if(in[ i * 2 ]     != 0  ||  in[(i * 2) + 1] != 0)   out[i] = 0xff;
		else out[i] = 0x00;
	}
}


void eng_conv_24_to_mask(guchar * in, guchar * out, guint32 nb_pixel) {
   
	guint32 i, size_in, size_out;   

	size_in  = calc_buf_size_24(nb_pixel, 1);
	size_out = calc_buf_size(nb_pixel, 1, 8);

	for(i = 0; i < nb_pixel; i++)  {

		if(in[ i * 3 ]     != 0  ||  in[(i * 3) + 1] != 0  ||  in[(i * 3) + 2] != 0)   out[i] = 0xff;
		else  out[i] = 0x00;
	}
}

