/* GtkBalls
 * Copyright (C) 1998-1999 Eugene V. Morozov
 * Modifyed in 2001 by drF_ckoff
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */
#include <errno.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <signal.h>
#include <unistd.h>
#include <fcntl.h>
#include <locale.h>
#include <sys/param.h>
#include <time.h>
#include <gtk/gtk.h>
#include <gdk-pixbuf/gdk-pixbuf.h>

#include "gtkballs.h"
#include "gtkutils.h"
#include "interface.h"
#include "preferences.h"
#include "scoreboard.h"
#include "path.h"
#include "license.h"
#include "gfx.h"

/* ----- Global variables ----- */

/* Note that I'm trying to start global variables' names from
 * uppercase letter whenever possible */

GtkbGameRules Rules = {9, 9, 7, 3, 5};
/* "classic". 9x9 board, 7 colors, 3 new, destroy by 5 */
GtkbGameRules ClassicRules = {9, 9, 7, 3, 5};

/* The board itself */
gint *Board;

/* copy of board on previous step. stupid. temporary. i hope =) */
gint *BoardUndo;

/* next colors... */
gint *NextColors;

/* copy of next colors on previous step... */
gint *NextColorsUndo;

/* main application window */
GtkWidget *MainWindow;
GtkStyle  *MainStyle;

/* Backing pixmap for drawing area */
GtkWidget *DrawingArea=NULL;

/* Score labels (also used in interface.[ch]) */
GtkWidget *Hi_score_label=NULL,*User_score_label=NULL;

GtkWidget *Timer_label=NULL;

gint Timer_limit=-1;
time_t Timer_start_time=-1;

/* box for next balls */
GtkWidget *Small_balls_box;

struct score_board Scoreboard[10];
struct score_board_full *FullScoreboard=NULL;
gint FullScoreboardNumber=0;

int Score_fds[2];

/* This flag shows should be next colors to be shown
 * This variable is also used in preferences.[ch] and interface.c */
gint Show_next_colors=TRUE;

/* This flag indicates wether to show the path of the ball
 * This variable is also used in preferences.[ch] */
gint Show_path=TRUE;

/* This flag indicates wether to show the footprints of the ball
 * This variable is also used in preferences.[ch] */
gint Show_footprints=TRUE;

/* This flag indicates wether to show the destroy ball animation */
gint Show_destroy=TRUE;

/* name of default theme. TODO: make "internal" theme, so, when
 * theme name is NULL we can use it... */
gchar Default_theme_name[]="Default";

/* Name of the current theme. Theme_name should point to that,
   and g_free() must be called when changing name and
   Current_theme_name!=NULL */
gchar *Current_theme_name=NULL;

/* This is the name of theme to use */
gchar *Theme_name=Default_theme_name;

/* The next two variables is also used in interface.[ch] */
gint Score=0, Hi_score=0;

/* copy of scores on previous step. */
gint ScoreUndo=0, Hi_scoreUndo=0;

/* jumping animation phase */
volatile gint phase = 0;

/* jumping animation timer tag */
guint TimerTag=0;

void 	show_rules	 	(GtkWidget *widget, gpointer data);
void 	about 		 	(GtkWidget *widget, gpointer data);
void 	destroy_about_window	(GtkWidget *widget, gpointer data);
void 	undo_move		(GtkWidget *widget, gpointer data);

GtkItemFactory *Menu_items_factory;

static GtkItemFactoryEntry Menu_items[] = 
{
	{N_("/_Game"), 		       NULL, 	     NULL, 		0, "<Branch>"},
  	{N_("/_Game/tear0"), 	       NULL, 	     NULL, 		0, "<Tearoff>"},
  	{N_("/_Game/_New"), 	       "<control>N", new_game, 		0, "<StockItem>", GTK_STOCK_NEW},
  	{N_("/_Game/_Rules"), 	       "<control>R", rules_dialog, 	0, "<StockItem>", GTK_STOCK_PROPERTIES},
  	{N_("/_Game/sep0"), 	       NULL, 	     NULL, 		0, "<Separator>"},
  	{N_("/_Game/_Save"), 	       "<control>S", save_game_cb, 	0, "<StockItem>", GTK_STOCK_SAVE},
  	{N_("/_Game/_Load"), 	       "<control>L", load_game_cb,      0, "<StockItem>", GTK_STOCK_OPEN},
  	{N_("/_Game/sep0"), 	       NULL, 	     NULL, 		0, "<Separator>"},
        {N_("/_Game/_Hall of fame"),   "<control>H", show_hall_of_fame, 0, "<Item>"},
        {N_("/_Game/sep1"), 	       NULL, 	     NULL, 		0, "<Separator>"},
  	{N_("/_Game/_Quit"), 	       "<control>Q", gtk_main_quit,     0, "<StockItem>", GTK_STOCK_QUIT},
  	{N_("/_Edit"), 	      	       NULL, 	     NULL, 		0, "<Branch>"},
  	{N_("/_Edit/tear1"),           NULL,         NULL, 		0, "<Tearoff>"},
  	{N_("/_Edit/_Undo"), 	       "<control>U", undo_move,        	0, "<StockItem>", GTK_STOCK_UNDO},
  	{N_("/_Settings"), 	       NULL, 	     NULL, 		0, "<Branch>"},
  	{N_("/_Settings/tear1"),       NULL,         NULL, 		0, "<Tearoff>"},
  	{N_("/_Settings/_Preferences"),"<control>P", preferences_dialog,0, "<StockItem>", GTK_STOCK_PREFERENCES},
  	{N_("/_Help"),                 NULL,         NULL, 		0, "<LastBranch>"},
  	{N_("/_Help/tear2"),           NULL,         NULL, 		0, "<Tearoff>"},
  	{N_("/_Help/_Rules"), 	       "F1",         show_rules, 	0, "<StockItem>", GTK_STOCK_HELP},
  	{N_("/_Help/sep2"),  	       NULL,         NULL, 		0, "<Separator>"},
  	{N_("/_Help/_About"),	       "<control>A", about, 		0, "<Item>"}
};

static gchar *menu_translate(const gchar *path, gpointer data) {
	gchar *retval=gettext(path);

        return retval;
}

void menu_set_sensitive(GtkItemFactory *ifactory, const gchar *path, gboolean sensitive) {
    GtkWidget *widget;

    g_return_if_fail(ifactory != NULL);

    widget = gtk_item_factory_get_item(ifactory, path);
    gtk_widget_set_sensitive(widget, sensitive);
}

void get_main_menu(GtkWidget *window, GtkWidget **menubar) {
  	gint nmenu_items;

  	nmenu_items=sizeof(Menu_items)/sizeof(Menu_items[0]);
  	Menu_items_factory=gtk_item_factory_new(GTK_TYPE_MENU_BAR, "<Main>", NULL);
  	gtk_item_factory_set_translate_func(Menu_items_factory, menu_translate, NULL, NULL);
  	gtk_item_factory_create_items(Menu_items_factory, nmenu_items, Menu_items, NULL);
  	gtk_window_add_accel_group(GTK_WINDOW(window), Menu_items_factory->accel_group);

  	if(menubar) {
    		*menubar=Menu_items_factory->widget;
        }
}

void undo_move(GtkWidget *widget, gpointer data) {

        memcpy(Board, BoardUndo, sizeof(gint)*Rules.xsize*Rules.ysize);
        memcpy(NextColors, NextColorsUndo, sizeof(gint)*Rules.next);
        Score=ScoreUndo;
        Hi_score=Hi_scoreUndo;
        if(AnimationInProgress) {
      		gtk_timeout_remove(TimerTag);
        	AnimationInProgress=FALSE;
        }
        set_hi_score_label();
        set_user_score_label();
        menu_set_sensitive(Menu_items_factory, "/Edit/Undo", FALSE);
        draw_board(DrawingArea, Pixmap);
        draw_next_balls();
        update_rectangle(DrawingArea, 0, 0, -1, -1);
}

gint count_free_cells(void) {
  	gint i,counter=0;
        gint *bp=Board;

  	for(i=0;i<Rules.xsize*Rules.ysize;i++)
      		if(!*bp++)
			counter++;

  	return counter;
}

void new_turn(gint number, gboolean first) {
  	gint i,k=0,free_cells_number;

        do {
        	Timer_start_time=time(NULL);

	  	k=0;
        	if(number < Rules.next) {
                	number = Rules.next;
	        }

  		if((free_cells_number=count_free_cells()) <= number) {
			if (Score>Scoreboard[9].score) {
				input_name_dialog();
	                }
		      	new_game();
    			return;
	        }

  		do {
      			i=(gint)(((gfloat)Rules.xsize*Rules.ysize)*rand()/(RAND_MAX+1.0));
	      		if(Board[i] == 0) {
        	                if(first) {
                	                Board[i]=1+(gint)(((gfloat)Rules.colors)*rand()/(RAND_MAX+1.0));
                        	} else {
	  				Board[i]=NextColors[k];
	                        }
		  		k++;
			} else {
				continue;
	                }
      			/* I hope that k!=0 */
                	if(k<=Rules.next) {
      				NextColors[k-1]=1+(gint)(((gfloat)Rules.colors)*rand()/(RAND_MAX+1.0));
	                }
    		} while(k<((number<free_cells_number) ? number : free_cells_number));

                if(!first) {
	        	draw_next_balls();
			/* if line complete, don't increase user's score--it's not his merit */
			destroy_lines(DrawingArea, Pixmap, FALSE);
	  		draw_board(DrawingArea, Pixmap);
	        	update_rectangle(DrawingArea, 0, 0, -1, -1);
                }
        } while((free_cells_number=count_free_cells()) == Rules.xsize*Rules.ysize);
}

/* 
   start a new game:
   clear the game field, create five new balls
   and set score to 0.
 */
void new_game(void){
  	if(AnimationInProgress) {
      		gtk_timeout_remove(TimerTag);
      		AnimationInProgress=FALSE;
    	}

        memset(Board,0,sizeof(gint)*Rules.xsize*Rules.ysize);

  	new_turn(Rules.destroy, TRUE);
        menu_set_sensitive(Menu_items_factory, "/Edit/Undo", FALSE);
  	Score=0;
        set_hi_score_label();
  	set_user_score_label();
  	if(DrawingArea != NULL) {
                draw_next_balls();
        	draw_board(DrawingArea, Pixmap);
        	update_rectangle(DrawingArea, 0, 0, -1, -1);
    	}
}

/* Show dialog box with game rules*/
void show_rules(GtkWidget *widget, gpointer data) {
  	GtkWidget *window;
  	GtkWidget *vbox, *hbox, *button_box;
  	GtkWidget *label;
  	GtkWidget *frame;
  	GtkWidget *separator;
  	GtkWidget *ok_button;

	window=ut_window_new(_("Rules"), "GtkBalls_Rules", "GtkBalls", TRUE, FALSE, FALSE, 5);

  	vbox=gtk_vbox_new(FALSE, 0);
  	gtk_container_add(GTK_CONTAINER(window), vbox);

        frame=gtk_frame_new(_("Rules"));
  	gtk_box_pack_start(GTK_BOX(vbox), frame, TRUE, TRUE, 3);

  	hbox=gtk_hbox_new(FALSE, 0);
	gtk_container_add(GTK_CONTAINER(frame), hbox);

  	label=gtk_label_new(_("The play area of GtkBalls is a 9x9 grid. When GtkBalls  is\n" \
			      "first  started  a  number  of balls are placed in a random\n" \
			      "manner on the grid. Balls can be in seven different colors\n" \
			      "(red,  green,  blue,  cyan,  brown, pink, yellow). You may\n" \
			      "move balls on the grid by clicking them  and  clicking  an\n" \
			      "empty  square  on the grid as destination for the ball you\n" \
			      "selected. Balls will only move if they are not blocked  by\n" \
			      "other  balls.  Each time you move a ball, unless you score\n" \
			      "some points , new balls appear in a random manner  on  the\n" \
			      "grid.  If  the grid is full then the game is lost. However\n" \
			      "this is bound to happen, your goal is to make the  highest\n" \
			      "score. In order to do this you must make lines in a verti-\n" \
			      "cal, horizontal or diagonal way with  balls  of  the  same\n" \
			      "color.  A  line  must have at least five balls of the same\n" \
			      "color. Making a line of  five  balls  will  earn  you  ten\n" \
			      "points  for  your score. If you make lines over five balls\n" \
			      "it will earn you even more points. In order  to  help  you\n" \
			      "decide which ball you are going to move, there is an indi-\n" \
			      "cator on top of the grid that shows what colors  the  next\n" \
			      "balls that will appear on the grid will be."));
  	gtk_box_pack_start(GTK_BOX(hbox), label, TRUE, TRUE, 5);

  	separator=gtk_hseparator_new();
  	gtk_box_pack_start(GTK_BOX(vbox), separator, FALSE, FALSE, 5);

  	button_box=gtk_hbox_new(FALSE, 0);
  	gtk_box_pack_start(GTK_BOX(vbox), button_box, TRUE, TRUE, 2);

        ok_button=ut_button_new_stock_swap(GTK_STOCK_CLOSE, gtk_widget_destroy, window, button_box);

        gtk_widget_grab_default(ok_button);
  	gtk_widget_show_all(window);
}

/* Show about dialog box */
void about(GtkWidget *widget, gpointer data) {
  	GtkWidget *window;
  	GtkWidget *vbox,*hbox,*buttons_box;
  	GdkPixmap *splash; /* GtkBalls logo */
  	GtkWidget *label; /* Information about author and copying conditions */
  	GtkWidget *pixmap;
  	GdkBitmap *mask;
  	GtkStyle  *style;
  	GtkWidget *separator;
  	GtkWidget *ok_button, *license_button;
  	gchar     strbuf[1024];

	window=ut_window_new(_("About"), "GtkBalls_About", "GtkBalls", TRUE, TRUE, FALSE, 5);

  	vbox=gtk_vbox_new(FALSE, 0);
  	gtk_container_add(GTK_CONTAINER(window), vbox);

  	hbox=gtk_hbox_new(FALSE, 0);
  	gtk_box_pack_start(GTK_BOX(vbox), hbox, TRUE, TRUE, 0);
  
  	style=gtk_widget_get_style(window);
  	splash=gdk_pixmap_create_from_xpm(DrawingArea->window, &mask,
				          &style->bg[GTK_STATE_NORMAL],
				          DATADIR "/gtkballs/gtkballs-logo.xpm");
  	if(splash) {
        	pixmap=gtk_image_new_from_pixmap(splash, mask);
  		gtk_box_pack_start(GTK_BOX(hbox), pixmap, TRUE, TRUE, 4);
        }

  	g_snprintf(strbuf, sizeof(strbuf), _("GtkBalls %s\n Copyright (C) 1998-1999 Eugene Morozov\n" \
					     "<jmv@online.ru>, <roshiajin@yahoo.com>\n\n" \
		       		       	     "GtkBalls comes with ABSOLUTELY NO WARRANTY;\n" \
		       		       	     "for details press \"Show license\" button.\n" \
      		       		       	     "This is free software and you are welcome to\n" \
				       	     "redistribute it under certain conditions;\n" \
				       	     "press \"Show license\" button for details."),VERSION);
  	label=gtk_label_new(strbuf);
  	gtk_box_pack_start(GTK_BOX(hbox), label, TRUE, TRUE, 2);
  
  	separator=gtk_hseparator_new();
  	gtk_box_pack_start(GTK_BOX(vbox), separator, FALSE, FALSE, 5);

  	buttons_box=gtk_hbutton_box_new();
  	gtk_box_pack_start(GTK_BOX(vbox), buttons_box, TRUE, TRUE, 2);
        gtk_button_box_set_layout(GTK_BUTTON_BOX(buttons_box), GTK_BUTTONBOX_SPREAD);

        ok_button=ut_button_new_stock_swap(GTK_STOCK_CLOSE, gtk_widget_destroy, window, buttons_box);

        license_button=ut_button_new(_("Show license"), gnu_license_dialog, window, buttons_box);

        gtk_widget_grab_default(ok_button);
  	gtk_widget_show_all(window);
}

gint animate_ball(gpointer data) {
  	GtkWidget *widget;
  	int x,y;

  	widget=GTK_WIDGET(data);

  	find_x_y_of_the_node(&x, &y, Jumping_ball, Rules.xsize, Rules.ysize);
  	if(widget!=NULL) {
    		draw_ball(widget, Jumping_ball_color, Pixmap, x, y, phase+1, 0);
        }

  	++phase;
        if(phase>=gtkbTheme->balls[Jumping_ball_color-1].jumpphases) {
  		phase=0;
        }
	TimerTag=gtk_timeout_add(gtkbTheme->balls[Jumping_ball_color-1].jumpdelays[phase], animate_ball, widget);

  	return FALSE;
}

gint countdown_timer(gpointer data) {
        gchar *text;
        GtkLabel *label = data;
        time_t nowt;
        gint trem;

        if(Timer_start_time == -1 || Timer_limit <= 0) return TRUE;

        nowt=time(NULL);
        if(nowt - Timer_start_time >= Timer_limit) {
        	Timer_start_time=nowt;
	      	new_turn(Rules.next, FALSE);
        }
        trem=Timer_limit + Timer_start_time - nowt;
        text=g_strdup_printf(_("Remaining time: %02d:%02d"), trem/60, trem%60);
        gtk_label_set_text(label, text);
        g_free(text);

  	return TRUE;
}

gint button_press_event(GtkWidget *widget, GdkEventButton *event) {
  	gint x,y,xn,yn;
	gint *TmpBoardUndo;
	gint *TmpNextColorsUndo;
	gint TmpScoreUndo, TmpHi_scoreUndo;

  	if(event->button==1 && Pixmap!=NULL) {
      		x=calculate_board_coord_x(event->x);
      		y=calculate_board_coord_y(event->y);
		find_x_y_of_the_node(&xn, &yn, Jumping_ball, Rules.xsize, Rules.ysize);
      		if(Board[y*Rules.xsize+x]) {
	  		if(AnimationInProgress) {
                                if(x==xn && y==yn) {
	    				return FALSE;
                                } else {
	    				gtk_timeout_remove(TimerTag);
                                	draw_ball(widget, Board[Jumping_ball], Pixmap, xn, yn, 0, 0);
                                }
                        }
	  		Jumping_ball=y*Rules.xsize+x;
	  		Jumping_ball_color=Board[y*Rules.xsize+x];
	  		AnimationInProgress=TRUE;
                        phase=0;
	  		TimerTag=gtk_timeout_add(gtkbTheme->balls[Jumping_ball_color-1].jumpdelays[phase], animate_ball, widget);
		} else if(AnimationInProgress == TRUE) {
        		TmpNextColorsUndo=g_malloc(sizeof(gint)*Rules.next);
                        TmpBoardUndo=g_malloc(sizeof(gint)*Rules.xsize*Rules.ysize);
        		memcpy(TmpBoardUndo, Board, sizeof(gint)*Rules.xsize*Rules.ysize);
        		memcpy(TmpNextColorsUndo, NextColors, sizeof(gint)*Rules.next);
                        TmpScoreUndo=Score;
                        TmpHi_scoreUndo=Hi_score;
	  		gtk_timeout_remove(TimerTag);
	  		AnimationInProgress=FALSE;
	  		if(!move_ball(widget, Jumping_ball, y*Rules.xsize+x)) {
	      			TimerTag=gtk_timeout_add(gtkbTheme->balls[Jumping_ball_color-1].jumpdelays[phase], animate_ball, widget);
	      			AnimationInProgress=TRUE;
                                g_free(TmpBoardUndo);
                                g_free(TmpNextColorsUndo);
	      			return FALSE;
	    		}
        		memcpy(BoardUndo, TmpBoardUndo, sizeof(gint)*Rules.xsize*Rules.ysize);
        		memcpy(NextColorsUndo, TmpNextColorsUndo, sizeof(gint)*Rules.next);
                        g_free(TmpBoardUndo);
                        g_free(TmpNextColorsUndo);
                        ScoreUndo=TmpScoreUndo;
                        Hi_scoreUndo=TmpHi_scoreUndo;
        		menu_set_sensitive(Menu_items_factory, "/Edit/Undo", TRUE);

	  		if(!destroy_lines(widget, Pixmap, TRUE)) {
	      			new_turn(Rules.next, FALSE);
	    		}

                        Timer_start_time=time(NULL);
		}
    	}

  	return FALSE;
}

void child_process_score_writer(int ch_fds[2]) {
	fd_set rfds;
        int i;
  	int fd=-1;
	gchar *buf;
        size_t sz;
  	sigset_t sset;
	struct flock lockinfo;

        close(ch_fds[1]);
        while(1) {
        	FD_ZERO(&rfds);
                FD_SET(ch_fds[0], &rfds);
                i=select(ch_fds[0] + 1, &rfds, NULL, NULL, NULL);
                if(i > 0) {
                	i = read(ch_fds[0], &sz, sizeof(sz));
                        if(i <= 0) {
                        	exit(0);
                        }
                        /* block signals before writing, to prevent possible file corruption */
			sigemptyset(&sset);
			sigaddset(&sset, SIGHUP);
		  	sigaddset(&sset, SIGINT);
			sigaddset(&sset, SIGQUIT);
		  	sigaddset(&sset, SIGTERM);
			sigprocmask(SIG_BLOCK, &sset, NULL);
  			fd=open(LOCALSTATEDIR SCORE_FILE, O_WRONLY | O_TRUNC);
                        if(fd != -1) {
  				/* get write lock before writing scores */
  				lockinfo.l_whence=SEEK_SET;
  				lockinfo.l_start=0;
	  			lockinfo.l_len=0;

  				i=0;
  				while(1) {
    					lockinfo.l_type=F_WRLCK;
    					if(!fcntl(fd, F_SETLK, &lockinfo)) break;
	    				if(i>=3) {
      						close(fd);
      						fd=-1;
    					}
    					i++;
	  			}
                        }
                        while(sz > 0) {
                                buf=g_malloc(sz);
                		read(ch_fds[0], buf, sz);
                        	if(fd != -1) {
                                        write(fd, buf, sz);
                                }
                                g_free(buf);
                		read(ch_fds[0], &sz, sizeof(sz));
                        }

                        if(fd != -1) {
  				close(fd);
                        }
  			sigprocmask(SIG_UNBLOCK, &sset, NULL);
                }
        }
}

int main(int argc, char **argv) {
  	GtkWidget *menubar;
  	GtkWidget *vbox,*hbox,*hbox1,*drawing_area_box;
  	GdkPixbuf *icon;
  	gint i;
	GError *error=NULL;
        gchar *err;

        pid_t pid;

  	gtk_set_locale();
#ifdef HAVE_NLS
  	bindtextdomain (PACKAGE, LOCALEDIR);
  	textdomain (PACKAGE);
        bind_textdomain_codeset(PACKAGE, "UTF8");
#endif /* HAVE_NLS */

        if(pipe(Score_fds) == -1) {
                printf("pipe() failed: %s\n", strerror(errno));
        }
        pid = fork();
        if(pid == -1) {
                printf("cannot fork: %s\n", strerror(errno));
        } else if(pid == 0) {
                child_process_score_writer(Score_fds);
        }
/*
        printf("%d\n", getgid());
        setgid(getgid());
*/
        /* drop privileges */
        setregid(getgid(), getgid());

  	/* load user's preferences */
  	load_preferences();

  	/* initialize random seed */
  	srand((unsigned int)time(NULL));
        Board=g_malloc0(sizeof(gint)*Rules.xsize*Rules.ysize);
        BoardUndo=g_malloc0(sizeof(gint)*Rules.xsize*Rules.ysize);
        NextColors=g_malloc(sizeof(gint)*Rules.next);
        NextColorsUndo=g_malloc(sizeof(gint)*Rules.next);
  	new_turn(Rules.destroy, TRUE);
        Timer_start_time=-1;

  	gtk_init(&argc, &argv);

  	if(!read_score(Scoreboard, &FullScoreboard, &FullScoreboardNumber)) {
                simple_message_box(_("Unable to read score.\n"));
    	}

	MainWindow=ut_window_new(_("GtkBalls"), "GtkBalls_Main", "GtkBalls", FALSE, FALSE, FALSE, 0);
  	MainStyle=gtk_widget_get_style(MainWindow);

  	g_signal_connect(G_OBJECT(MainWindow), "destroy", G_CALLBACK(gtk_main_quit), MainWindow);
  	gtk_widget_realize(MainWindow);
  	DrawingArea=gtk_drawing_area_new();

  	vbox=gtk_vbox_new(FALSE, 5);
  	hbox=gtk_hbox_new(FALSE, 0);
  	hbox1=gtk_hbox_new(FALSE, 0);
  	drawing_area_box=gtk_hbox_new(FALSE, 0);
  	Small_balls_box=gtk_hbox_new(TRUE, 0);

  	get_main_menu(MainWindow, &menubar);
        menu_set_sensitive(Menu_items_factory, "/Edit/Undo", FALSE);
  	gtk_box_pack_start(GTK_BOX(vbox), menubar, FALSE, TRUE, 0);

  	Hi_score=Scoreboard[0].score;
  	Score=0;

  	Hi_score_label=gtk_label_new(_("Hi-score: 0"));
  	set_hi_score_label();
  	gtk_box_pack_start(GTK_BOX(hbox), Hi_score_label, FALSE, FALSE, 5);

  	User_score_label=gtk_label_new(_("Your score: 0"));
  	set_user_score_label();
  	gtk_box_pack_end(GTK_BOX(hbox), User_score_label, FALSE, FALSE, 5);

        Timer_label=gtk_label_new(NULL);
  	gtk_box_pack_start(GTK_BOX(hbox1), Timer_label, TRUE, TRUE, 5);
	gtk_timeout_add(250, countdown_timer, Timer_label);

  	gtk_box_pack_start(GTK_BOX(vbox), GTK_WIDGET(hbox), FALSE, FALSE, 0);
  	gtk_box_pack_start(GTK_BOX(vbox), GTK_WIDGET(hbox1), FALSE, FALSE, 0);

  	g_signal_connect(G_OBJECT(DrawingArea), "expose_event", G_CALLBACK(expose_event), NULL);
  	g_signal_connect(G_OBJECT(DrawingArea), "button_press_event", G_CALLBACK(button_press_event), NULL);
  	gtk_widget_set_events(DrawingArea, GDK_EXPOSURE_MASK | GDK_BUTTON_PRESS_MASK);

  	gtk_box_pack_start(GTK_BOX(drawing_area_box), DrawingArea, TRUE, FALSE, 10);
  	gtk_box_pack_start(GTK_BOX(vbox), drawing_area_box, FALSE, FALSE, 10);
  	gtk_container_add(GTK_CONTAINER(MainWindow), vbox);

        icon=gdk_pixbuf_new_from_file(DATADIR "/gtkballs/gtkballs_16x16.xpm", &error);
        if(error) g_error_free(error);
  	if(icon) {
		gtk_window_set_icon(GTK_WINDOW(MainWindow), icon);
        }

  	if(!(i=load_theme(Theme_name))) {
                if(strcmp(Theme_name, Default_theme_name)!=0) {
                        err=g_strdup_printf(_("Failed loading theme \"%s\"! Trying \"%s\"\n"),Theme_name, Default_theme_name);
                	simple_message_box(err);
                        g_free(err);
                	Theme_name=Default_theme_name;
  			i=load_theme(Theme_name);
                }
                if(!i) {
                        err=g_strdup_printf(_("Failed loading theme \"%s\"! Exiting.\n"),Theme_name);
                	simple_message_box(err);
                        g_free(err);
                        return 1;
                }
  	}

  	gtk_widget_show_all(MainWindow);
  	Pixmap=gdk_pixmap_new(DrawingArea->window, Rules.xsize*gtkbTheme->emptycell.xsize, Rules.ysize*gtkbTheme->emptycell.ysize, -1);

        SmallBalls=g_malloc(Rules.next*sizeof(GtkWidget *));
        for(i=0;i<Rules.next;i++) {
                SmallBalls[i]=gtk_image_new_from_pixmap(gtkbTheme->balls[NextColors[i]-1].small.pixmap, gtkbTheme->balls[NextColors[i]-1].small.mask);
  		gtk_box_pack_start(GTK_BOX(Small_balls_box), SmallBalls[i], FALSE, FALSE, 0);
        }

  	gtk_box_pack_start(GTK_BOX(hbox), Small_balls_box, TRUE, FALSE, 0);

  	show_hide_next_balls(Show_next_colors);

  	gtk_widget_show(Small_balls_box);
        draw_board(DrawingArea, Pixmap);
        gtk_quit_add(0, (GtkFunction)gtkb_theme_free_handler, NULL);

        Timer_start_time=time(NULL);
        gtk_label_set_text(GTK_LABEL(Timer_label), _("Time is unlimited"));

  	gtk_main();

  	return 0;
}
