/*
 * Directory view widget header
 *
 * Display directory diff on GtkCList widget.
 * Internally, it owns DiffDir data(see diff.h).
 * When a user select a row(ie. he wants to open these files),
 * this widget emits "select_file" signal.
 * It is up to an application(in gtkdiff case, GDiffWindow module)
 * to take care of handling "select_file" signal.
 *
 * Copyright INOUE Seiichiro <inoue@ainet.or.jp>, licensed under the GPL.
 */
#ifndef __GDIFF_DIRVIEW_H__
#define __GDIFF_DIRVIEW_H__

#include <gtk/gtkscrolledwindow.h>
#include "properties.h" /* for DViewPref */

#ifdef __cplusplus 
extern "C" {
#endif /* __cplusplus */

#define GDIFF_TYPE_DIRVIEW				(gdiff_dirview_get_type())
#define GDIFF_DIRVIEW(obj)				GTK_CHECK_CAST(obj, gdiff_dirview_get_type(), GdiffDirView)
#define GDIFF_DIRVIEW_CLASS(klass)		GTK_CHECK_CLASS_CAST(klass, gdiff_dirview_get_type(), GdiffDirViewClass)
#define GDIFF_IS_DIRVIEW(obj)			GTK_CHECK_TYPE(obj, gdiff_dirview_get_type())
#define GDIFF_IS_DIRVIEW_CLASS(klass)	(GTK_CHECK_CLASS_TYPE((klass), GDIFF_TYPE_DIRVIEW))


typedef struct _GdiffDirView       GdiffDirView;
typedef struct _GdiffDirViewClass  GdiffDirViewClass;

struct _GdiffDirView {
	GtkScrolledWindow scrollwin;

	GtkCList *clist;

	/* backward pointer for reference */
	GDiffWindow *gdwin;

	/* Backend data */
	DiffDir *diffdir;
	char *dirname[2];

	/* TRUE if one of files under this directory has been reloaded. */
	gboolean b_dirty;

	/* Store this for search feature */
	int cur_selected_row;
	
	DViewPref pref;
};

struct _GdiffDirViewClass {
	GtkScrolledWindowClass parent_class;

	/* Interfaces */
	void (*select_file)(GdiffDirView *dirview, DiffFiles *dfiles);/* signal */
	void (*scrollup)(GdiffDirView *dirview);/* signal */
	void (*scrolldown)(GdiffDirView *dirview);/* signal */
};


GtkType gdiff_dirview_get_type(void);
GtkWidget* gdiff_dirview_new(DiffDir *diffdir);
void gdiff_dirview_redisplay(GdiffDirView *dirview);
void gdiff_dirview_adjust_column(GdiffDirView *dirview, int total_width);
gboolean gdiff_dirview_search_string(GdiffDirView *dirview, const char *string, WhichFile whichfile);
void gdiff_dirview_checksum(GdiffDirView *dirview);

/* Macros */
#define GDIFF_DIRVIEW_DIFFDIR(dirview)\
	(GDIFF_DIRVIEW(dirview)->diffdir)
#define GDIFF_DIRVIEW_DIRNAME(dirview, whichfile)\
	(GDIFF_DIRVIEW(dirview)->dirname[whichfile])
#define GDIFF_DIRVIEW_PREF(dirview)\
	(GDIFF_DIRVIEW(dirview)->pref)

#define GDIFF_DIRVIEW_NUM_DIRS(dirview)\
	((GDIFF_DIRVIEW_DIFFDIR(dirview)->is_diff3) ? 3 : 2)

#ifdef __cplusplus
} 
#endif /* __cplusplus */
 
#endif /* __GDIFF_DIRVIEW_H__ */
