/*
 * One-pane widget header
 *
 * This is one of components in onepane-view widget.
 * Show the files on one text widget coloring the different portions.
 * Some interfaces such as show line numbers, are provided by basepane-widget.
 *
 * Copyright INOUE Seiichiro <inoue@ainet.or.jp>, licensed under the GPL.
 */
#ifndef __GDIFF_ONEPANE_H__
#define __GDIFF_ONEPANE_H__

#include "basepane-widget.h"
#include <gtk/gtkscrolledwindow.h>
#include <gtk/gtktext.h>

#ifdef __cplusplus 
extern "C" {
#endif /* __cplusplus */

#define GDIFF_TYPE_ONEPANE				(gdiff_onepane_get_type())
#define GDIFF_ONEPANE(obj)				GTK_CHECK_CAST(obj, gdiff_onepane_get_type(), GdiffOnePane)
#define GDIFF_ONEPANE_CLASS(klass)		GTK_CHECK_CLASS_CAST(klass, gdiff_onepane_get_type(), GdiffOnePaneClass)
#define GDIFF_IS_ONEPANE(obj)			GTK_CHECK_TYPE(obj, gdiff_onepane_get_type())
#define GDIFF_IS_ONEPANE_CLASS(klass)	(GTK_CHECK_CLASS_TYPE((klass), GDIFF_TYPE_ONEPANE))

	
typedef struct _GdiffOnePane       GdiffOnePane;
typedef struct _GdiffOnePaneClass  GdiffOnePaneClass;

struct _GdiffOnePane {
	GdiffBasePane basepane;

	GtkWidget *text;

	/* One-pane specific internal data */
	/* DTextMap is internally related to GtkText widget */
	DTextMap *dtmap;

	/* Line number column */
	int n_col;	/* -1 implies that format hasn't been calculated */
	char format_common[32];					/* e.g. "%4d  " */
	char format_diff[MAX_NUM_COMPARE_FILES][32];/* e.g. "%4d< " and "%4d> " */

	/* These work as cache in a sense */
	/* Current line number for string search */
	int search_ln[MAX_NUM_COMPARE_FILES]; /* in buf */
	int search_tln;/* in text */
	/* Point in text widget */
	int search_tpoint;/* in text */
	/* Current index of the above line */
	int search_tindex;/* in text */
};

struct _GdiffOnePaneClass {
	GdiffBasePaneClass parent_class;
};


GtkType gdiff_onepane_get_type(void);
GtkWidget* gdiff_onepane_new(DiffDir *diffdir, DiffFiles *dfiles);

#ifdef __cplusplus
} 
#endif /* __cplusplus */
 
#endif /* __GDIFF_ONEPANE_H__ */
