// -*- C++ -*-

/* window_test_fontcombo.cc
 * 
 * Copyright (C) 2000 GtkExtra-- Development Team  
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "window_test_fontcombo.h"

#include <iostream>
#include <gtk--/window.h>
#include <gtk--/box.h>

Window_Test_FontCombo::Window_Test_FontCombo()
{ 
  set_title("GtkExtra::FontCombo Demo");

  m_strDefaultText = "ABCDEFGHI abcdefghi 0123456789";

  set_border_width(0);

  m_VBox.set_border_width(0);
  add(m_VBox);

  m_VBox.pack_start(m_FontCombo, false, false);
  m_VBox.pack_start(m_Entry);

  m_Entry.set_text(m_strDefaultText);

  m_FontCombo.changed.connect(slot(this, &Window_Test_FontCombo::On_FontCombo_Changed));
  
  show_all();
}

Window_Test_FontCombo::~Window_Test_FontCombo()
{
}

gint Window_Test_FontCombo::delete_event_impl(GdkEventAny*)
{ 
  Gtk::Main::quit();
  return 0; 
}

void Window_Test_FontCombo::On_FontCombo_Changed()
{
 Gtk::Style* pStyle = m_Entry.get_style();
 pStyle->set_font(m_FontCombo.get_font());
 m_Entry.set_style(*pStyle);

 std::string strText = m_Entry.get_text();
 if(strText.size() == 0)
 {
   m_Entry.set_text(m_strDefaultText);
 }

 m_Entry.set_position(0);
}
