/*
 *   Copyright (C) 2007-2009 Tristan Heaven <tristanheaven@gmail.com>
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License along
 *   with this program; if not, write to the Free Software Foundation, Inc.,
 *   51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

#ifndef _PROPERTIES_HASH_H_
#define _PROPERTIES_HASH_H_

int gtkhash_properties_hash_get_pos_from_name(const char *name);
const char *gtkhash_properties_hash_get_name_from_pos(const int pos);
void gtkhash_properties_hash_set_digest(struct page_s *page, const int pos,
	char *digest);
const char *gtkhash_properties_hash_get_digest(struct page_s *page,
	const int pos);
void gtkhash_properties_hash_clear_digests(struct page_s *page);
unsigned int gtkhash_properties_hash_get_source(struct page_s *page);
void gtkhash_properties_hash_add_source(struct page_s *page);
bool gtkhash_properties_hash_get_stop(struct page_s *page);
void gtkhash_properties_hash_set_stop(struct page_s *page, const bool stop);
enum hash_state_e gtkhash_properties_hash_get_state(struct page_s *page);
void gtkhash_properties_hash_set_state(struct page_s *page,
	const enum hash_state_e state);
bool gtkhash_properties_hash_file(struct page_s *page);
void gtkhash_properties_hash_init(struct page_s *page);
void gtkhash_properties_hash_deinit(struct page_s *page);

#endif // _PROPERTIES_HASH_H_
