// Copyright (C) 2000-2005, Luca Padovani <luca.padovani@cs.unibo.it>.
//
// This file is part of GtkMathView, a Gtk widget for MathML.
// 
// GtkMathView is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// GtkMathView is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with GtkMathView; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
// 
// For details, see the GtkMathView World-Wide-Web page,
// http://helm.cs.unibo.it/mml-widget/, or send a mail to
// <lpadovan@cs.unibo.it>

#include "TFM.hh"

static TFM::Font font = {
  "CMSY",
  0xf4,
  "TeX math symbols",
  0x00500000,
  0xb0dc306e,
  22,
  128
};

static TFM::Dimension dimension[] = {
  { 0x01, "slant", 0x00040000 },
  { 0x02, "space", 0x00000000 },
  { 0x03, "space_stretch", 0x00000000 },
  { 0x04, "space_shrink", 0x00000000 },
  { 0x05, "x_height", 0x0006e38d },
  { 0x06, "quad", 0x00178e4d },
  { 0x07, "extra_space", 0x00000000 },
  { 0x08, "num1", 0x000ecdca },
  { 0x09, "num2", 0x0006330d },
  { 0x0a, "num3", 0x000810ed },
  { 0x0b, "denom1", 0x00106763 },
  { 0x0c, "denom2", 0x000882b3 },
  { 0x0d, "sup1", 0x00080e90 },
  { 0x0e, "sup2", 0x000674f6 },
  { 0x0f, "sup3", 0x0004b60d },
  { 0x10, "sub1", 0x00033333 },
  { 0x11, "sub2", 0x00066666 },
  { 0x12, "supdrop", 0x0007e940 },
  { 0x13, "subdrop", 0x0001999a },
  { 0x14, "delim1", 0x001fae13 },
  { 0x15, "delim2", 0x0016b853 },
  { 0x16, "axis_height", 0x00040000 }
};


static TFM::Kerning C_41_Kerning[] = {
  { 0x30, 0x0003e393 }
};

static TFM::Kerning C_42_Kerning[] = {
  { 0x30, 0x0002c720 }
};

static TFM::Kerning C_43_Kerning[] = {
  { 0x30, 0x0002c720 }
};

static TFM::Kerning C_44_Kerning[] = {
  { 0x30, 0x0001aaad }
};

static TFM::Kerning C_45_Kerning[] = {
  { 0x30, 0x000238e6 }
};

static TFM::Kerning C_46_Kerning[] = {
  { 0x30, 0x000238e6 }
};

static TFM::Kerning C_47_Kerning[] = {
  { 0x30, 0x000238e6 }
};

static TFM::Kerning C_48_Kerning[] = {
  { 0x30, 0x000238e6 }
};

static TFM::Kerning C_49_Kerning[] = {
  { 0x30, 0x00008e3a }
};

static TFM::Kerning C_4a_Kerning[] = {
  { 0x30, 0x0003555a }
};

static TFM::Kerning C_4b_Kerning[] = {
  { 0x30, 0x00011c73 }
};

static TFM::Kerning C_4c_Kerning[] = {
  { 0x30, 0x0002c720 }
};

static TFM::Kerning C_4d_Kerning[] = {
  { 0x30, 0x0002c720 }
};

static TFM::Kerning C_4e_Kerning[] = {
  { 0x30, 0x0001aaad }
};

static TFM::Kerning C_4f_Kerning[] = {
  { 0x30, 0x000238e6 }
};

static TFM::Kerning C_50_Kerning[] = {
  { 0x30, 0x0001aaad }
};

static TFM::Kerning C_51_Kerning[] = {
  { 0x30, 0x000238e6 }
};

static TFM::Kerning C_52_Kerning[] = {
  { 0x30, 0x0001aaad }
};

static TFM::Kerning C_53_Kerning[] = {
  { 0x30, 0x0002c720 }
};

static TFM::Kerning C_54_Kerning[] = {
  { 0x30, 0x00008e3a }
};

static TFM::Kerning C_55_Kerning[] = {
  { 0x30, 0x0001aaad }
};

static TFM::Kerning C_56_Kerning[] = {
  { 0x30, 0x00008e3a }
};

static TFM::Kerning C_57_Kerning[] = {
  { 0x30, 0x0001aaad }
};

static TFM::Kerning C_58_Kerning[] = {
  { 0x30, 0x0002c720 }
};

static TFM::Kerning C_59_Kerning[] = {
  { 0x30, 0x0001aaad }
};

static TFM::Kerning C_5a_Kerning[] = {
  { 0x30, 0x0002c720 }
};


static TFM::Character character[] = {
  { 0x00, 0x00115566, 0x000aaab3, 0x0002aab3, 0x00000000, 0, 0, 0, 0 },
  { 0x01, 0x0007555a, 0x0007e393, 0xffffe393, 0x00000000, 0, 0, 0, 0 },
  { 0x02, 0x00115566, 0x000aaab3, 0x0002aab3, 0x00000000, 0, 0, 0, 0 },
  { 0x03, 0x000bc726, 0x000771c6, 0xffff71c6, 0x00000000, 0, 0, 0, 0 },
  { 0x04, 0x00115566, 0x000aaab3, 0x0002aab3, 0x00000000, 0, 0, 0, 0 },
  { 0x05, 0x000bc726, 0x0007e393, 0xffffe393, 0x00000000, 0, 0, 0, 0 },
  { 0x06, 0x00115566, 0x000aaab3, 0x0002aab3, 0x00000000, 0, 0, 0, 0 },
  { 0x07, 0x00115566, 0x000aaab3, 0x0002aab3, 0x00000000, 0, 0, 0, 0 },
  { 0x08, 0x00115566, 0x000aaab3, 0x0002aab3, 0x00000000, 0, 0, 0, 0 },
  { 0x09, 0x00115566, 0x000aaab3, 0x0002aab3, 0x00000000, 0, 0, 0, 0 },
  { 0x0a, 0x00115566, 0x000aaab3, 0x0002aab3, 0x00000000, 0, 0, 0, 0 },
  { 0x0b, 0x00115566, 0x000aaab3, 0x0002aab3, 0x00000000, 0, 0, 0, 0 },
  { 0x0c, 0x00115566, 0x000aaab3, 0x0002aab3, 0x00000000, 0, 0, 0, 0 },
  { 0x0d, 0x0015c733, 0x000b1c73, 0x00031c73, 0x00000000, 0, 0, 0, 0 },
  { 0x0e, 0x000bc726, 0x0007e393, 0xffffe393, 0x00000000, 0, 0, 0, 0 },
  { 0x0f, 0x000bc726, 0x0007e393, 0xffffe393, 0x00000000, 0, 0, 0, 0 },
  { 0x10, 0x00115566, 0x00083ca6, 0x00003ca6, 0x00000000, 0, 0, 0, 0 },
  { 0x11, 0x00115566, 0x00083ca6, 0x00003ca6, 0x00000000, 0, 0, 0, 0 },
  { 0x12, 0x00115566, 0x000b8256, 0x00038256, 0x00000000, 0, 0, 0, 0 },
  { 0x13, 0x00115566, 0x000b8256, 0x00038256, 0x00000000, 0, 0, 0, 0 },
  { 0x14, 0x00115566, 0x000b8256, 0x00038256, 0x00000000, 0, 0, 0, 0 },
  { 0x15, 0x00115566, 0x000b8256, 0x00038256, 0x00000000, 0, 0, 0, 0 },
  { 0x16, 0x00115566, 0x000b8256, 0x00038256, 0x00000000, 0, 0, 0, 0 },
  { 0x17, 0x00115566, 0x000b8256, 0x00038256, 0x00000000, 0, 0, 0, 0 },
  { 0x18, 0x00115566, 0x000657ad, 0xfffe57ad, 0x00000000, 0, 0, 0, 0 },
  { 0x19, 0x00115566, 0x00089da6, 0x00009da6, 0x00000000, 0, 0, 0, 0 },
  { 0x1a, 0x00115566, 0x00099d5a, 0x00019d5a, 0x00000000, 0, 0, 0, 0 },
  { 0x1b, 0x00115566, 0x00099d5a, 0x00019d5a, 0x00000000, 0, 0, 0, 0 },
  { 0x1c, 0x0015c733, 0x00099d5a, 0x00019d5a, 0x00000000, 0, 0, 0, 0 },
  { 0x1d, 0x0015c733, 0x00099d5a, 0x00019d5a, 0x00000000, 0, 0, 0, 0 },
  { 0x1e, 0x00115566, 0x00099d5a, 0x00019d5a, 0x00000000, 0, 0, 0, 0 },
  { 0x1f, 0x00115566, 0x00099d5a, 0x00019d5a, 0x00000000, 0, 0, 0, 0 },
  { 0x20, 0x0015c733, 0x000657ad, 0xfffe57ad, 0x00000000, 0, 0, 0, 0 },
  { 0x21, 0x0015c733, 0x000657ad, 0xfffe57ad, 0x00000000, 0, 0, 0, 0 },
  { 0x22, 0x000bc726, 0x000b1c73, 0x00031c73, 0x00000000, 0, 0, 0, 0 },
  { 0x23, 0x000bc726, 0x000b1c73, 0x00031c73, 0x00000000, 0, 0, 0, 0 },
  { 0x24, 0x0015c733, 0x000657ad, 0xfffe57ad, 0x00000000, 0, 0, 0, 0 },
  { 0x25, 0x0015c733, 0x000b1c73, 0x00031c73, 0x00000000, 0, 0, 0, 0 },
  { 0x26, 0x0015c733, 0x000b1c73, 0x00031c73, 0x00000000, 0, 0, 0, 0 },
  { 0x27, 0x00115566, 0x00083ca6, 0x00003ca6, 0x00000000, 0, 0, 0, 0 },
  { 0x28, 0x0015c733, 0x000657ad, 0xfffe57ad, 0x00000000, 0, 0, 0, 0 },
  { 0x29, 0x0015c733, 0x000657ad, 0xfffe57ad, 0x00000000, 0, 0, 0, 0 },
  { 0x2a, 0x000e000d, 0x000b1c73, 0x00031c73, 0x00000000, 0, 0, 0, 0 },
  { 0x2b, 0x000e000d, 0x000b1c73, 0x00031c73, 0x00000000, 0, 0, 0, 0 },
  { 0x2c, 0x0015c733, 0x000657ad, 0xfffe57ad, 0x00000000, 0, 0, 0, 0 },
  { 0x2d, 0x0015c733, 0x000b1c73, 0x00031c73, 0x00000000, 0, 0, 0, 0 },
  { 0x2e, 0x0015c733, 0x000b1c73, 0x00031c73, 0x00000000, 0, 0, 0, 0 },
  { 0x2f, 0x00115566, 0x0006e38d, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x30, 0x00070e3d, 0x0008e390, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x31, 0x0015c733, 0x0006e38d, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x32, 0x000f1c80, 0x00099d5a, 0x00019d5a, 0x00000000, 0, 0, 0, 0 },
  { 0x33, 0x000f1c80, 0x00099d5a, 0x00019d5a, 0x00000000, 0, 0, 0, 0 },
  { 0x34, 0x00138e4d, 0x000b1c73, 0x00031c73, 0x00000000, 0, 0, 0, 0 },
  { 0x35, 0x00138e4d, 0x000b1c73, 0x00031c73, 0x00000000, 0, 0, 0, 0 },
  { 0x36, 0x00000000, 0x000b1c73, 0x00031c73, 0x00000000, 0, 0, 0, 0 },
  { 0x37, 0x00000000, 0x000657ad, 0xfffe57ad, 0x00000000, 0, 0, 0, 0 },
  { 0x38, 0x000ce39a, 0x000b1c73, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x39, 0x000ce39a, 0x000b1c73, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x3a, 0x000f1c80, 0x0006e38d, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x3b, 0x000bc726, 0x000c0000, 0x0000e38d, 0x00000000, 0, 0, 0, 0 },
  { 0x3c, 0x001038f3, 0x000b1c73, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x3d, 0x001038f3, 0x000b1c73, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x3e, 0x00115566, 0x000b1c73, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x3f, 0x00115566, 0x000b1c73, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x40, 0x000e000d, 0x000b1c73, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x41, 0x0011d0d6, 0x000aeef0, 0x00000000, 0x00000000, 1, C_41_Kerning, 0, 0 },
  { 0x42, 0x000eb586, 0x000aeef0, 0x00000000, 0x0000443d, 1, C_42_Kerning, 0, 0 },
  { 0x43, 0x000c8373, 0x000aeef0, 0x00000000, 0x00009eba, 1, C_43_Kerning, 0, 0 },
  { 0x44, 0x001157b0, 0x000aeef0, 0x00000000, 0x00008e3a, 1, C_44_Kerning, 0, 0 },
  { 0x45, 0x000c5560, 0x000aeef0, 0x00000000, 0x00013dfd, 1, C_45_Kerning, 0, 0 },
  { 0x46, 0x000fcfb0, 0x000aeef0, 0x00000000, 0x0001a4fa, 1, C_46_Kerning, 0, 0 },
  { 0x47, 0x000d9b5d, 0x000aeef0, 0x00018e3a, 0x0000d82a, 1, C_47_Kerning, 0, 0 },
  { 0x48, 0x00131cd0, 0x000aeef0, 0x00000000, 0x00000000, 1, C_48_Kerning, 0, 0 },
  { 0x49, 0x000d1cca, 0x000aeef0, 0x00000000, 0x0000d5a0, 1, C_49_Kerning, 0, 0 },
  { 0x4a, 0x000f5563, 0x000aeef0, 0x00018e3a, 0x000302da, 1, C_4a_Kerning, 0, 0 },
  { 0x4b, 0x0010e15d, 0x000aeef0, 0x00000000, 0x00000000, 1, C_4b_Kerning, 0, 0 },
  { 0x4c, 0x000f6f90, 0x000aeef0, 0x00000000, 0x00000000, 1, C_4c_Kerning, 0, 0 },
  { 0x4d, 0x001915f6, 0x000aeef0, 0x00000000, 0x00000000, 1, C_4d_Kerning, 0, 0 },
  { 0x4e, 0x00120456, 0x000aeef0, 0x00000000, 0x0002780a, 1, C_4e_Kerning, 0, 0 },
  { 0x4f, 0x00116d4a, 0x000aeef0, 0x00000000, 0x00008e3a, 1, C_4f_Kerning, 0, 0 },
  { 0x50, 0x000ff666, 0x000aeef0, 0x00000000, 0x00015f00, 1, C_50_Kerning, 0, 0 },
  { 0x51, 0x00121c83, 0x000aeef0, 0x00018e3a, 0x00000000, 1, C_51_Kerning, 0, 0 },
  { 0x52, 0x0013235d, 0x000aeef0, 0x00000000, 0x00000000, 1, C_52_Kerning, 0, 0 },
  { 0x53, 0x000de39a, 0x000aeef0, 0x00000000, 0x00011706, 1, C_53_Kerning, 0, 0 },
  { 0x54, 0x000d28b0, 0x000aeef0, 0x00000000, 0x0004666a, 1, C_54_Kerning, 0, 0 },
  { 0x55, 0x000dfaea, 0x000aeef0, 0x00000000, 0x0001a4fa, 1, C_55_Kerning, 0, 0 },
  { 0x56, 0x000e61ea, 0x000aeef0, 0x00000000, 0x00015f00, 1, C_56_Kerning, 0, 0 },
  { 0x57, 0x0015e1f3, 0x000aeef0, 0x00000000, 0x00015f00, 1, C_57_Kerning, 0, 0 },
  { 0x58, 0x000ff23d, 0x000aeef0, 0x00000000, 0x000257c6, 1, C_58_Kerning, 0, 0 },
  { 0x59, 0x000edf10, 0x000aeef0, 0x00018e3a, 0x00015f00, 1, C_59_Kerning, 0, 0 },
  { 0x5a, 0x000fdcca, 0x000aeef0, 0x00000000, 0x000150c6, 1, C_5a_Kerning, 0, 0 },
  { 0x5b, 0x000f1c80, 0x0008e390, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x5c, 0x000f1c80, 0x0008e390, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x5d, 0x000f1c80, 0x0008e390, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x5e, 0x000f1c80, 0x0008e390, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x5f, 0x000f1c80, 0x0008e390, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x60, 0x000e000d, 0x000b1c73, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x61, 0x000e000d, 0x000b1c73, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x62, 0x000aaab3, 0x000c0000, 0x00040000, 0x00000000, 0, 0, 0, 0 },
  { 0x63, 0x000aaab3, 0x000c0000, 0x00040000, 0x00000000, 0, 0, 0, 0 },
  { 0x64, 0x000aaab3, 0x000c0000, 0x00040000, 0x00000000, 0, 0, 0, 0 },
  { 0x65, 0x000aaab3, 0x000c0000, 0x00040000, 0x00000000, 0, 0, 0, 0 },
  { 0x66, 0x000bc726, 0x000c0000, 0x00040000, 0x00000000, 0, 0, 0, 0 },
  { 0x67, 0x000bc726, 0x000c0000, 0x00040000, 0x00000000, 0, 0, 0, 0 },
  { 0x68, 0x00098e40, 0x000c0000, 0x00040000, 0x00000000, 0, 0, 0, 0 },
  { 0x69, 0x00098e40, 0x000c0000, 0x00040000, 0x00000000, 0, 0, 0, 0 },
  { 0x6a, 0x0007555a, 0x000c0000, 0x00040000, 0x00000000, 0, 0, 0, 0 },
  { 0x6b, 0x000bc726, 0x000c0000, 0x00040000, 0x00000000, 0, 0, 0, 0 },
  { 0x6c, 0x000bc726, 0x000c0000, 0x00040000, 0x00000000, 0, 0, 0, 0 },
  { 0x6d, 0x000e000d, 0x000c0000, 0x00040000, 0x00000000, 0, 0, 0, 0 },
  { 0x6e, 0x000bc726, 0x000c0000, 0x00040000, 0x00000000, 0, 0, 0, 0 },
  { 0x6f, 0x0007555a, 0x000b1c73, 0x00031c73, 0x00000000, 0, 0, 0, 0 },
  { 0x70, 0x00118e4d, 0x0000e560, 0x000f1aa0, 0x00000000, 0, 0, 0, 0 },
  { 0x71, 0x001093fa, 0x000aeef0, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x72, 0x001271da, 0x000aeef0, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x73, 0x000a1c7a, 0x000b1c73, 0x00031c73, 0x000238e6, 0, 0, 0, 0 },
  { 0x74, 0x000f1c80, 0x0008e390, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x75, 0x000f1c80, 0x0008e390, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x76, 0x00115566, 0x000b8256, 0x00038256, 0x00000000, 0, 0, 0, 0 },
  { 0x77, 0x00115566, 0x000b8256, 0x00038256, 0x00000000, 0, 0, 0, 0 },
  { 0x78, 0x000aaab3, 0x000b1c73, 0x00031c73, 0x00000000, 0, 0, 0, 0 },
  { 0x79, 0x000aaab3, 0x000b1c73, 0x00031c73, 0x00000000, 0, 0, 0, 0 },
  { 0x7a, 0x000aaab3, 0x000b1c73, 0x00031c73, 0x00000000, 0, 0, 0, 0 },
  { 0x7b, 0x000e000d, 0x000b1c73, 0x00031c73, 0x00000000, 0, 0, 0, 0 },
  { 0x7c, 0x00115566, 0x000b1c73, 0x000212f6, 0x00000000, 0, 0, 0, 0 },
  { 0x7d, 0x00115566, 0x000b1c73, 0x000212f6, 0x00000000, 0, 0, 0, 0 },
  { 0x7e, 0x00115566, 0x000b1c73, 0x000212f6, 0x00000000, 0, 0, 0, 0 },
  { 0x7f, 0x00115566, 0x000b1c73, 0x000212f6, 0x00000000, 0, 0, 0, 0 }
};

void
cmsy5_tables(TFM::Font*& _font, TFM::Dimension*& _dimension, TFM::Character*& _character)
{
  _font = &font;
  _dimension = dimension;
  _character = character;
}
