#ifndef INCLUDE_THEMES_H
#define INCLUDE_THEMES_H
/* ----------------------------------------------------------------------------
 * themes.h
 * prototypes and definitions for themes.c.
 *
 * Copyright 2002 Matthias Grimm
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version
 * 2 of the License, or (at your option) any later version.
 * ----------------------------------------------------------------------------*/

#include <gtk/gtk.h>

enum { GLOBAL, BRIGHTNESS, VOLUME, MUTE, MOUSE, BATTERY,
	   SLEEP, NOAUDIO, KBDILLU, CDROM, CRTMIRROR, POPUPS=CRTMIRROR };

#define SECTIONNAMES	"", "brightness", "volume", "mute", "mouse", "battery",\
                        "sleep", "noaudio", "kbdillu", "cdrom", "crtmirror"

enum { POPUP_BRIGHTNESS, POPUP_VOLUME, POPUP_MUTE, POPUP_NOAUDIO,
       POPUP_MOUSE, POPUP_BATTERY, POPUP_SLEEP, POPUP_KBDILLU,
       POPUP_CDROM, POPUP_CRTMIRROR };

#define POPUP_TYPE_PROGRESS	0
#define POPUP_TYPE_MESSAGE	1
#define POPUP_TYPE_IMAGE	2

#define VOLUME_MAX			100
#define BACKLIGHT_MAX		15
#define KBDILLU_MAX			15

#define TIMEOUT_MIN			2
#define TIMEOUT_LEVER		7	/* in 10th of a second */
#define TIMEOUT_NOTICE		15

struct theme {
	char		name[30];
	int			bgtype;
	GtkWidget	*bgimage;
	int			popup_active[POPUPS];
	int			popup_time[POPUPS];
	struct sample *volsound;
	struct sample *warnsound;
	int			havesound;
	int			(*layout_init)();   /* load layout resources, etc. */
	int			(*layout_attach)();  /* attach a wdget tree to a given window */
	void		(*layout_cleanup)(); /* free mem, etc. */
	void		(*layout_update)(struct theme *td, GtkWidget *window, int popup, ...);
	void		*user_data;
};

struct themeoption {
	int	popup;
	char	*option;
	int	(*process)();
	void	*data;
};

struct layoutengine {
	char	*name;
	int	(*layout_init)();  /* load layout resources, etc. */
	int	(*layout_attach)();  /* attach a wdget tree to a given window */
	void	(*layout_cleanup)(); /* free mem, etc. */
	void	(*layout_update)(struct theme *td, GtkWidget *window, int popup, ...);
};

/* public prototypes */
struct theme *theme_init (char *name);
void theme_exit (struct theme *td);
int is_theme (char *name);

int theme_load_data (struct theme *td, struct themeoption *tab, int tablen);
int theme_bool (struct theme *td, char *arg, int *data);
int theme_int (struct theme *td, char *arg, int *data);
int theme_string (struct theme *td, char *arg, gchar **data);
int theme_layout (struct theme *td, char *arg, int *data);
int theme_bgtype (struct theme *td, char *arg, int *data);
int theme_image (struct theme *td, char *arg, GtkWidget **data);
int theme_sound (struct theme *td, char *arg, struct sample **data);
void theme_cleanup_buffer(char *buffer);

/* gtk+ layout theme engine */
int layout_classic_init (struct theme *td);
void layout_classic_exit (struct theme *td);
int layout_classic_attach (struct theme *td, GtkWidget *window);
void layout_classic_update (struct theme *td, GtkWidget *window, int popup, ...);

/* macosx layout theme engine */
int layout_macosx_init (struct theme *td);
void layout_macosx_exit (struct theme *td);
int layout_macosx_attach (struct theme *td, GtkWidget *window);
void layout_macosx_update (struct theme *td, GtkWidget *window, int popup, ...);

#endif    /* INCLUDE_THEMES_H */
