/*  GTKtalog.
 *  Copyright (C) 1999  Mathieu VILLEGAS
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <config.h>
#include <gnome.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <fnmatch.h>

#include "about.h"
#include "addisk.h"
#include "buttonbar.h"
#include "categories.h"
#include "config_common.h"
#include "edit.h"
#include "exit.h"
#include "fastaddisk.h"
#include "folder.h"
#include "interface.h"
#include "io.h"
#include "loadcat.h"
#include "report.h"
#include "savecat.h"
#include "search.h"
#include "selectdir.h"
#include "setup.h"
#include "thread_utils.h"

#define TOOLBAR_NB_OF_ELEMENTS	10

GnomeUIInfo *toolbar;
GtkWidget *toolbar_widget;
GnomeUIInfo general_toolbar[] = {
/*00*/ GNOMEUIINFO_SEPARATOR,
/*01*/ GNOMEUIINFO_ITEM_STOCK (N_("New"), N_("New catalog"),
			       cb_new_file, GNOME_STOCK_PIXMAP_NEW),
/*02*/ GNOMEUIINFO_ITEM_STOCK (N_("Open"), N_("Open catalog"),
			       cb_open_cat, GNOME_STOCK_PIXMAP_OPEN),
/*03*/ GNOMEUIINFO_ITEM_STOCK (N_("Save"), N_("Save catalog"),
			       cb_fast_save, GNOME_STOCK_PIXMAP_SAVE),
/*04*/ GNOMEUIINFO_ITEM_STOCK (N_("Save as..."), N_("Save catalog as..."),
			       cb_save_cat, GNOME_STOCK_PIXMAP_SAVE_AS),
/*05*/ GNOMEUIINFO_ITEM_STOCK (N_("Edit categories"),
			       N_("Edit categories"),
			       cb_edit_categories,
			       GNOME_STOCK_PIXMAP_PROPERTIES),
/*06*/ GNOMEUIINFO_ITEM_STOCK (N_("Preferences"), N_("Preferences"),
			       cb_run_setup, GNOME_STOCK_PIXMAP_PREFERENCES),
/*07*/ GNOMEUIINFO_ITEM_STOCK (N_("Find file"), N_("Find file"),
			       cb_create_search_dialog,
			       GNOME_STOCK_PIXMAP_SEARCH),
/*08*/ GNOMEUIINFO_ITEM_STOCK (N_("Create Report"), N_("Create Report"),
			       cb_open_report_dialog,
			       GNOME_STOCK_PIXMAP_BOOK_GREEN),
/*09*/ GNOMEUIINFO_ITEM_STOCK (N_("Add CD"), N_("Add CD"),
			       cb_fast_add_disk, GNOME_STOCK_PIXMAP_CDROM),
/*10*/ GNOMEUIINFO_ITEM_STOCK (N_("Add dir"), N_("Add dir"),
			       cb_show_select_dir_win,
			       GNOME_STOCK_PIXMAP_CDROM),
/*11*/ GNOMEUIINFO_ITEM_STOCK (N_("Exit"), N_("Quit Gtktalog"),
			       cb_quit_prog, GNOME_STOCK_PIXMAP_EXIT),
/*12*/ GNOMEUIINFO_END
};

void
enable_gnome_button_bar (GtkWidget * window, gint type)
{
  toolbar =
    (GnomeUIInfo *) g_malloc (TOOLBAR_NB_OF_ELEMENTS * sizeof (GnomeUIInfo));

  /* Copy the items from the general toolbar to the toolbar.
   * toolbar is the toolbar that will be displayed.
   * This way makes it easy to program customization later as it
   *              was the case in the old enable_button_bar.
   */
  memcpy (&(toolbar[0]), &(general_toolbar[1]), sizeof (GnomeUIInfo));
  memcpy (&(toolbar[1]), &(general_toolbar[2]), sizeof (GnomeUIInfo));
  memcpy (&(toolbar[2]), &(general_toolbar[3]), sizeof (GnomeUIInfo));
  memcpy (&(toolbar[3]), &(general_toolbar[0]), sizeof (GnomeUIInfo));
  memcpy (&(toolbar[4]), &(general_toolbar[9]), sizeof (GnomeUIInfo));
  memcpy (&(toolbar[5]), &(general_toolbar[8]), sizeof (GnomeUIInfo));
  memcpy (&(toolbar[6]), &(general_toolbar[7]), sizeof (GnomeUIInfo));
  memcpy (&(toolbar[7]), &(general_toolbar[0]), sizeof (GnomeUIInfo));
  memcpy (&(toolbar[8]), &(general_toolbar[11]), sizeof (GnomeUIInfo));
  memcpy (&(toolbar[9]), &(general_toolbar[12]), sizeof (GnomeUIInfo));

  gnome_app_create_toolbar_with_data (GNOME_APP (window), toolbar, NULL);
  /* The last GnomeUIInfo item contains the toolbar widget as the .widget field */
  toolbar_widget = toolbar[TOOLBAR_NB_OF_ELEMENTS - 1].widget;
  update_toolbar_style ();
}

void
update_toolbar_style ()
{
  gtk_toolbar_set_style (GTK_TOOLBAR (toolbar_widget),
			 my_config->toolbar_type);
}

void
buttons_set_sensitive (gboolean sensitive)
{
  gtk_widget_set_sensitive (GTK_WIDGET (toolbar[2].widget), sensitive);
  gtk_widget_set_sensitive (GTK_WIDGET (toolbar[5].widget), sensitive);
  gtk_widget_set_sensitive (GTK_WIDGET (toolbar[6].widget), sensitive);
}

void
buttons_set_all_sensitive (gboolean sensitive)
{
  int i;
  for (i = 0; i < TOOLBAR_NB_OF_ELEMENTS; i++)
    {
      if (toolbar[i].widget)
	{
	  gtk_widget_set_sensitive (GTK_WIDGET (toolbar[i].widget),
				    sensitive);
	}
    }
}

void
cb_new_file (GtkWidget * w, gpointer data)
{
  if ((get_thread_status () == THREAD_SCAN_RUNNING_NO)
      && (!is_search_running ()))
    {
      new_file ();
    }
}

void
cb_open_recent (GtkWidget * w, gpointer data)
{
  FOLDER *racine;
  gchar *p;
  gchar *filename = data;
  gint l;

  if ((get_thread_status () == THREAD_SCAN_RUNNING_NO)
      && (!is_search_running ()))
    {
      if (my_config->racine != NULL)
	{
	  if (my_config->racine->is_modified == TRUE)
	    {
	      if (yes_no_cancel_dialog (_("Open dialog"),
					_
					("The catalog has not been saved. Lose it anyway?"))
		  != 0)
		{
		  return;
		}
	    }
	}
      gtk_clist_clear ((GtkCList *) clist);
      if (my_config->racine != NULL)
	{
	  clear_folder (my_config->racine);
	}
      gtk_entry_set_text (GTK_ENTRY (path_entry), "");
      racine = init_folder ();
      create_tree (racine);

      my_config->racine = racine;

/* load_cat_from_file() is supposed to free the old filename
 * so we do not keep something pointing to it to free it after
 */
      filename = g_strdup (filename);
      l = load_cat_from_file (filename, my_config->racine);
      if (l == -1)
	{
	  return;
	}
      g_free (my_config->working_path);
      my_config->working_path = g_strdup (filename);
      p = my_config->working_path;
      while (p[0])
	p++;
      while (p[0] != '/')
	p--;
      p[1] = 0;
      g_node_traverse (my_config->racine->tree,
		       G_PRE_ORDER, G_TRAVERSE_ALL, -1, add_gnode_to_ctree,
		       my_config->racine);
      ctree_window_add (my_config->racine->ctree);
      update_tree (my_config->racine);

      gtk_window_set_title (GTK_WINDOW (main_window), filename);
      menus_set_sensitive (TRUE);
      if (l == -2)
	{
	  WARNING_DIALOG (_
			  ("At least one disk name was empty. A random name was used instead"),
			  main_window);
	}

    }
}

void
cb_open_cat (GtkWidget * w, gpointer data)
{
  if ((get_thread_status () == THREAD_SCAN_RUNNING_NO)
      && (!is_search_running ()))
    {
      open_cat (my_config->racine);
    }
}

void
cb_merge_cat (GtkWidget * w, gpointer data)
{
  if ((get_thread_status () == THREAD_SCAN_RUNNING_NO)
      && (!is_search_running ()))
    {
      merge_cat (my_config->racine);
    }
}

void
cb_fast_save (GtkWidget * w, gpointer data)
{
  if (my_config->racine)
    {
      if ((get_thread_status () == THREAD_SCAN_RUNNING_NO)
	  && (!is_search_running ()))
	{
	  fast_save (my_config->racine);
	}
    }
}

void
cb_save_cat (GtkWidget * w, gpointer data)
{
  if (my_config->racine)
    {
      if ((get_thread_status () == THREAD_SCAN_RUNNING_NO)
	  && (!is_search_running ()))
	{
	  save_cat (my_config->racine);
	}
    }
}

void
cb_quit_prog (GtkWidget * w, gpointer data)
{
  if ((get_thread_status () == THREAD_SCAN_RUNNING_NO)
      && (!is_search_running ()))
    {
      quit_prog (my_config->racine);
    }
}

void
cb_edit_categories (GtkWidget * w, gpointer data)
{
  if ((get_thread_status () == THREAD_SCAN_RUNNING_NO)
      && (!is_search_running ()))
    {
      if (my_config->racine)
	{
	  edit_categories (my_config->racine);
	}
    }
}

void
cb_run_setup (GtkWidget * w, gpointer data)
{
  if ((get_thread_status () == THREAD_SCAN_RUNNING_NO)
      && (!is_search_running ()))
    {
      run_setup ();
    }
}

void
cb_create_search_dialog (GtkWidget * w, gpointer data)
{
  if ((get_thread_status () == THREAD_SCAN_RUNNING_NO)
      && (!is_search_running ()))
    {
      if (my_config->racine)
	{
	  if (g_node_n_nodes (my_config->racine->tree, G_TRAVERSE_ALL) > 1)
	    {
	      set_search_running (TRUE);
	      menus_set_all_sensitive (FALSE);

	      create_search_dialog (my_config->racine);
	    }
	  else
	    ERROR_DIALOG (_
			  ("The catalog is empty: nothing to search!"),
			  main_window);
	}
    }
}

void
cb_open_report_dialog (GtkWidget * w, gpointer data)
{
  if ((get_thread_status () == THREAD_SCAN_RUNNING_NO)
      && (!is_search_running ()))
    {
      if (my_config->racine)
	{
	  if (g_node_n_nodes (my_config->racine->tree, G_TRAVERSE_ALL) > 1)
	    open_report_dialog (my_config->racine);
	  else
	    ERROR_DIALOG (_
			  ("The catalog is empty: nothing to write in a report!"),
			  main_window);
	}
    }
}

void
cb_fast_add_disk (GtkWidget * w, gpointer data)
{
  if ((get_thread_status () == THREAD_SCAN_RUNNING_NO)
      && (!is_search_running ()))
    {
      if (my_config->racine == NULL)
	{
	  my_config->racine = init_folder ();
	  create_tree (my_config->racine);
	  add_gnode_to_ctree (my_config->racine->tree, my_config->racine);
	  ctree_window_add (my_config->racine->ctree);
	  menus_set_sensitive (TRUE);
	}
      fast_add_disk (my_config->racine);
    }
}

void
cb_show_select_dir_win (GtkWidget * w, gpointer data)
{
  if ((get_thread_status () == THREAD_SCAN_RUNNING_NO)
      && (!is_search_running ()))
    {
      if (my_config->racine == NULL)
	{
	  my_config->racine = init_folder ();
	  create_tree (my_config->racine);
	  add_gnode_to_ctree (my_config->racine->tree, my_config->racine);
	  ctree_window_add (my_config->racine->ctree);
	  menus_set_sensitive (TRUE);
	  update_tree (my_config->racine);

	}
      show_select_dir_win (my_config->racine);
    }
}

void
cb_cat_info (GtkWidget * w, gpointer data)
{
  if ((get_thread_status () == THREAD_SCAN_RUNNING_NO)
      && (!is_search_running ()))
    {
      if (my_config->racine)
	{
	  show_statistics (my_config->racine, my_config->racine->tree);
	}
    }
}

void
cb_about_gtktalog (GtkWidget * w, gpointer data)
{
  about_gtktalog ();
}
