/* The Filesystem destination Widget */

#include <gtk/gtk.h>
#include <string.h>
#include <unistd.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <fcntl.h>
#include <unistd.h>
#include <stdio.h>
#include <dirent.h>
#include <stdlib.h>

#include "int.h"

#include "preferences.h"
#include "main.h"
#include "getdir.h"
#include "filelist.h"
#include "fsedit.h"
#include "fileman.h"
#include "treedroppatch.h"
#include "varmanwidgets.h"
#include "updatehandlers.h"
#include "menusys.h"
#include "preview.h"
#include "multisession.h"
#include "dialog.h"
#include "filetypes.h"
#include "helpings.h"
#include "vfs_unixtree.h"

/* uncomment for debugging */
// #define DEBUG

GtkWidget *fsedit;
filelist_info *content;
GtkWidget *tree;
GtkWidget *rootitem;
GList *fsedit_updatehandlers=NULL;
vfs_filesystem *edited_fs=NULL;

gint fsedit_updatedisplay(gpointer data)
{
   GtkTreeItem *treeentry;

   treeentry=content->treeentry;

   if (treeentry->expanded)
     {
	gtk_tree_item_collapse(treeentry);
	gtk_tree_item_expand(treeentry);
     }
   ;
   gtk_tree_item_deselect(treeentry);
   gtk_tree_item_select(treeentry);

   updatehandlers_call(fsedit_updatehandlers);
   return 0;
}
;

void fsedit_updatedisplay_void(int status,gpointer data)
{
   fsedit_updatedisplay(data);
};

/* define this globally here, we can change this anytime we want.
 *
 * Please make sure that callback functions delete the encoder mapping
 * unless you want to see a memory leak.
 *
 * FIXME: don't leave this to the callback handlers, create some manager
 * instance in between cleaning this up
 * */
fileman_addstreamglobal fsedit_streamdropinfo;

void fsedit_dnddone(int status,gpointer data)
{
   filetypes_clearmapping(&fsedit_streamdropinfo.encodermapping);

   gtk_timeout_add(0,
		   fsedit_updatedisplay,
		   NULL);
};

typedef struct
{
   fileman_additems_donecallback donecb;
   gpointer data;
   char *desturi;
} fsedit_genericdrop_callback_info;

void fsedit_genericdrop_callback(int status,gpointer data)
{
   fsedit_genericdrop_callback_info *info=(fsedit_genericdrop_callback_info*)data;
   /* FixMe: be more specific here */
   if (status)
     {
	const char *errormsg=_("Error adding items to the Filesystem:\n%s\nPlease check the result.\n");
	char *msg=NULL;
	const char *current;
	const char *lasterror=NULL;
	while ((current=vfs_getlasterrorstring(content->fs))!=NULL)
	  lasterror=current;
	if (!lasterror)
	  lasterror=_("Unknown Filesystem error");
	msg=malloc(strlen(errormsg)+((lasterror)?strlen(lasterror):0)+1);
	sprintf(msg,errormsg,lasterror);
	dialog_error(msg);
	free(msg);
     };
   free(info->desturi);
   info->donecb(0,info->data);
   free(info);
};

void fsedit_genericdrop(char *itemlist,
			char *path,
			fileman_additems_donecallback donecb,
			gpointer cbdata,
			int dragtype)
{
   GList *items=helpings_convertdndlist(itemlist);
   fsedit_genericdrop_callback_info *info=(fsedit_genericdrop_callback_info*)malloc(sizeof(fsedit_genericdrop_callback_info));
   
#ifdef DEBUG
   int i;
   printf("Received DND string:\n");
   for (i=0;i<strlen(itemlist);++i)
     {
	if (((itemlist[i]>='a')&&(itemlist[i]<='z'))||
	    ((itemlist[i]>='A')&&(itemlist[i]<='Z')))
	  printf("%c",itemlist[i]);
	else
	  printf("#%i",itemlist[i]);
     };
   printf("\n");
#endif
   info->donecb=donecb;
   info->data=cbdata;
   info->desturi=vfs_buildvfsuri(content->fs,path);

   /* initialize global info structure for stream drops */
   fsedit_streamdropinfo.encodermapping=NULL;
   fsedit_streamdropinfo.dragtype=dragtype;

   fileman_additemlist(items,
		       fsedit_genericdrop_callback,
		       info,

		       (gpointer)info->desturi,
		       2,

		       "",
		       fileman_addfile_generic,
		       dragtype,
		       
		       "stream:",
		       fileman_addstream,
		       (gpointer)&fsedit_streamdropinfo

		       );
};

/* drophandler now takes x and y coordinates of the pointer.
 * Those are not required here,though */
int fsedit_drophandler(char *s,int x,int y,int dragtype,gpointer data)
{
   fsedit_genericdrop(s,content->path,
		      fsedit_dnddone,
		      NULL,
		      dragtype);
   return 1;
}
;

int fsedit_setbootimage(char *s,char *p,
			fileman_mkdircall mkdir,
			fileman_addfilecall addfile,
			gpointer data
			)
{
   char *filename=strdup(s);
   vfs_parseuri(s,filename);

   varman_setvar(global_defs,"isotrack_bootimage",filename);
   /* convenience - once a user selects a bootimage,it is very likely
    * he's gonna want to use it as well */
   varman_setvar(global_defs,"isotrack_makebootable","true");
   free(filename);
   return 1;
};

void fsedit_selectbootimage(GtkWidget *w,selectlist_info *info)
{
   fileman_selectionhandler(selectlist_getselection(info),"",
			    fsedit_setbootimage,
			    NULL,NULL,NULL);
};

void fsedit_mkdirhandler(GtkWidget *w,selectlist_info *info)
{
	/* call fileman_mkdir_dialog with the current path.
	 * This will ask the user to enter a directory name.
	 * Once this is done mkdir_dialog will create the directory requested
	 * and call fsedit_updatedisplay as an indication that the process
	 * has finished and that the program can now return to its normal
	 * state of operation. */
   fileman_mkdir_dialog(content->fs,content->path,
			GTK_SIGNAL_FUNC(fsedit_updatedisplay),NULL);
}
;

int fsedit_renamesingle(char *s,char *p,
			fileman_mkdircall mkdir,
			fileman_addfilecall addfile,
			gpointer data
			)
{
   char *filename=strdup(s);
   vfs_parseuri(s,filename);
   if (filename)
     {
	fileman_rename_dialog(content->fs,filename,
			      GTK_SIGNAL_FUNC(fsedit_updatedisplay),NULL);
	free(filename);
     };
   return 1;
};

void fsedit_renamehandler(GtkWidget *w,selectlist_info *info)
{
   /* call fileman_rename_dialog with the currently selected file.
    * This will ask the user to enter a new name.
    * Once this is done rename_dialog will rename the file to it's new name
    * and call fsedit_updatedisplay as an indication that the process
    * has finished and that the program can now return to its normal
    * state of operation. */
   fileman_selectionhandler(selectlist_getselection(info),
			    content->path,
			    fsedit_renamesingle,
			    NULL,NULL,NULL);
}
;

typedef struct
{
   fileman_additems_continuecb cb;
   fileman_additems_state *cbdata;
}
fsedit_delete_iterate_info;

void fsedit_delete_iterate_cb(int status,gpointer data)
{
   fsedit_delete_iterate_info *info=(fsedit_delete_iterate_info*)data;
   info->cb(info->cbdata);
   free(info);
};

void fsedit_delete_iterate(char *item,
			   gpointer data1,
			   gpointer data2,

			   fileman_additems_continuecb cb,
			   fileman_additems_state *cbdata)
{
   char *path=strdup(item);
   vfs_filesystem *fs=vfs_parseuri(item,path);
   if (fs)
     {
	fsedit_delete_iterate_info *info=
	  (fsedit_delete_iterate_info*)malloc(sizeof(fsedit_delete_iterate_info));
	info->cb=cb;
	info->cbdata=cbdata;

	vfs_remove_recursively(fs,path,
			       fsedit_delete_iterate_cb,
			       info,
			       !strcmp(path,"/")); // don't try to delete the root directory ;_)
     };
   free(path);
};

void fsedit_removehandler(GtkWidget *w,selectlist_info *info)
{
   char *files=selectlist_getselection(info);
   GList *items=helpings_convertdndlist(files);

#ifdef DEBUG
   printf ("fsedit_removehandler: removing\n %s\n",
	   files);
#endif

   fileman_additemlist(items,
		       fsedit_updatedisplay_void,
		       NULL,

		       NULL,
		       1,

		       "", /* whatever */
		       fsedit_delete_iterate,
		       NULL);
}
;

void fsedit_treednddone(int status,gpointer data)
{
   getdir_dirinfo *info=data;
   GtkWidget *w=info->referringto;

   filetypes_clearmapping(&fsedit_streamdropinfo.encodermapping);

   if (GTK_TREE_ITEM(w)->expanded)
     {
	gtk_tree_item_collapse(GTK_TREE_ITEM(w));
	gtk_tree_item_expand(GTK_TREE_ITEM(w));
     }
   ;
   if (!strcmp((char*)info->dirname,content->path))
     {
	gtk_tree_item_deselect(GTK_TREE_ITEM(w));
	gtk_tree_item_select(GTK_TREE_ITEM(w));
     }
   ;
   updatehandlers_call(fsedit_updatehandlers);
};

int fsedit_treedrop(char *s,
		    int x,int y,
		    int dragtype,
		    gpointer data)
{
   getdir_dirinfo *info=data;

   fsedit_genericdrop(s,info->dirname,
		      fsedit_treednddone,
		      (gpointer)info,
		      dragtype);
   return 1;
}
;

static menusys_menu fsedit_filelistpopup[]=
{
   MENUSYS_ITEM_NONE(N_("Delete File(s)"),N_("Delete marked file(s)/director(y/ies)"),fsedit_removehandler),
   MENUSYS_ITEM_NONE(N_("Create Directory"),N_("Create a directory within the current file list"),fsedit_mkdirhandler),
   MENUSYS_ITEM_NONE(N_("Rename File(s)"),N_("Rename selected file(s)"),fsedit_renamehandler),
   MENUSYS_ITEM_NONE(N_("Make Boot Image"),N_("Make current cd bootable using this boot image"),fsedit_selectbootimage),
   MENUSYS_ITEM_NONE(N_("Convert to.."),N_("Convert this file to another filetype"),selectlist_encodetofile),
   MENUSYS_ITEM_END
}
;

void fsedit_cb_filelistselect(GtkWidget *w,getdir_dirinfo *i)
{
#ifdef DEBUG
   printf ("fsedit_cb_filelistselect: displaying content of %s\n",
	   i->dirname);
#endif
   content=filelist_create((char*)i->dirname,
			   i->fs,
			   fsedit_drophandler,TRUE,
			   fsedit_filelistpopup,
			   GTK_TREE_ITEM(w),
			   FALSE
			   );
   gtk_paned_add2(GTK_PANED(fsedit),content->widget);
   gtk_widget_show(content->widget);

}
;

void fsedit_cb_filelistdeselect(GtkWidget *w,getdir_dirinfo *i)
{
#ifdef DEBUG
   printf ("fsedit_cb_filelistdeselect: leaving %s\n",
	   i->dirname);
#endif
   filelist_destroy(content);
}
;

void fsedit_treeremove_update(int status,void *data)
{
   getdir_dirinfo *info;

   GtkTreeItem *host;

   info=(getdir_dirinfo*)data;

   if (info->parent)
     host=GTK_TREE_ITEM(info->parent);
   else
     host=GTK_TREE_ITEM(info->referringto);

   gtk_tree_item_collapse(host);
   gtk_tree_item_expand(host);
	/* if the host dir is currently displayed on the right side,
	 * update the right side as well */
   if (host==content->treeentry)
     {
	gtk_tree_item_deselect(GTK_TREE_ITEM(host));
	gtk_tree_item_select(GTK_TREE_ITEM(host));
     }
   ;

   updatehandlers_call(fsedit_updatehandlers);
}
;

void fsedit_treeremove(GtkWidget *w,void *data)
{
   getdir_dirinfo *info=(getdir_dirinfo*)data;

   vfs_remove_recursively(info->fs,
			  info->dirname,
			  fsedit_treeremove_update,
			  data,
			  0);
}
;

void fsedit_treemkdir_update(gpointer data)
{
   getdir_dirinfo *info;

   info=(getdir_dirinfo*)data;

	/* update subdir informations */
   if ( (GTK_TREE_ITEM_SUBTREE(info->referringto)==NULL) &&
       (vfs_numberofsubdirs(info->fs,info->dirname)>2))
     {
	gtk_tree_item_set_subtree(GTK_TREE_ITEM(info->referringto),
				  gtk_tree_new());
     }
   ;
   if (GTK_TREE_ITEM(info->referringto)->expanded)
     {
	gtk_tree_item_collapse(GTK_TREE_ITEM(info->referringto));
	gtk_tree_item_expand(GTK_TREE_ITEM(info->referringto));
     }
   ;
   if (!strcmp((char*)info->dirname,content->path))
     {
	gtk_tree_item_deselect(GTK_TREE_ITEM(info->referringto));
	gtk_tree_item_select(GTK_TREE_ITEM(info->referringto));
     }
   ;

   updatehandlers_call(fsedit_updatehandlers);
}
;

void fsedit_treemkdir(GtkWidget *w,void *data)
{
   getdir_dirinfo *info;

   info=(getdir_dirinfo*)data;

   fileman_mkdir_dialog(info->fs,
			(char*)info->dirname,
			fsedit_treemkdir_update,
			data);
}
;

void fsedit_treerename_update(char *newname,gpointer data)
{
   getdir_dirinfo *info;
   int was_expanded=0;
   int was_selected=0;

   info=(getdir_dirinfo*)data;

   /* as our directory's name is part of the path to all our subdirectories,
    * we have to collapse our tree in case it is expanded */
   if (GTK_TREE_ITEM(info->referringto)->expanded)
     {
	gtk_tree_item_collapse(GTK_TREE_ITEM(info->referringto));
	was_expanded=1;
     }
   ;
   /* and we have to update the "content" side,that is the right half of
    * the screen,as well */
   if (!strcmp((char*)info->dirname,content->path))
     {
	gtk_tree_item_deselect(GTK_TREE_ITEM(info->referringto));
	was_selected=1;
     }
   ;

   /* set new directory name */
   gtk_label_set_text(GTK_LABEL(gtk_container_children(GTK_CONTAINER(info->referringto))->data),
		      (strrchr(newname,'/')+1));
   free(info->dirname);
   info->dirname=malloc(strlen(newname)+1);
   strcpy((char*)info->dirname,newname);

   /* restore selected item and expand status */
   if (was_expanded)
     gtk_tree_item_expand(GTK_TREE_ITEM(info->referringto));
   if (was_selected)
     gtk_tree_item_select(GTK_TREE_ITEM(info->referringto));

   /* well this should be it,call updatehandlers now */
   updatehandlers_call(fsedit_updatehandlers);
}
;

void fsedit_applyvolid(gchar *string,gpointer data)
{
   if (string!=NULL)
     varman_setvar(global_defs,"fsedit_volid",string);
};

void fsedit_changevolid()
{
   dialog_string(_("ISO Filesystem Volume ID"),
		 varman_getvar(global_defs,"fsedit_volid"),
		 32,
		 fsedit_applyvolid,
		 NULL);
}
;

void fsedit_treerename(GtkWidget *w,void *data)
{
   getdir_dirinfo *info;

   info=(getdir_dirinfo*)data;

   if (info->parent!=NULL)
     {
	fileman_rename_dialog(info->fs,
			      info->dirname,
			      fsedit_treerename_update,
			      data);
     }
   else
     fsedit_changevolid();
}
;

static menusys_menu fsedit_treepopup[]=
{
   MENUSYS_ITEM_NONE(N_("Delete Directory"),N_("Delete a directory"),fsedit_treeremove),
   MENUSYS_ITEM_NONE(N_("Create Directory"),N_("Create a directory within the currently selected dir"),fsedit_treemkdir),
   MENUSYS_ITEM_NONE(N_("Rename VOLUME/Directory"),N_("Rename a directory"),fsedit_treerename),
   MENUSYS_ITEM_END
}
;

void fsedit_rootitem_create()
{
   char *rootdisplay;
   rootdisplay=varman_replacevars_copy(global_defs,"/[fsedit_volid]");
   rootitem=gtk_tree_item_new_with_label(rootdisplay);
   free(rootdisplay);

   gtk_tree_append(GTK_TREE(tree),rootitem);
   gtk_tree_item_set_subtree(GTK_TREE_ITEM(rootitem),
			     gtk_tree_new());
   gtk_widget_show(rootitem);
   getdir_connectstdsignals(rootitem,
			    NULL, /* this is the first item in the tree hierarchy*/
			    getdir_dirinfo_create("/",
						  edited_fs,
						  fsedit_cb_filelistselect,
						  fsedit_cb_filelistdeselect,
						  NULL,
						  TRUE,
						  fsedit_treedrop,
						  fsedit_treepopup
						  ));
}
;

GtkWidget *fsedit_create()
{
   GtkWidget *treescroll;

   fsedit=gtk_hpaned_new();

   treescroll=gtk_scrolled_window_new (NULL,NULL);
   gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(treescroll),
				  GTK_POLICY_AUTOMATIC,
				  GTK_POLICY_AUTOMATIC);

   tree=gtk_tree_new();
   gtk_tree_set_selection_mode(GTK_TREE(tree),GTK_SELECTION_BROWSE);
   treedroppatch_install(tree);

   gtk_scrolled_window_add_with_viewport (GTK_SCROLLED_WINDOW(treescroll),tree);
   gtk_widget_show(tree);

   edited_fs=vfs_unixtree_create(FSEDIT_DESTPATH);

   fsedit_rootitem_create();

   gtk_paned_pack1(GTK_PANED(fsedit),treescroll,1,1);
   gtk_widget_show(treescroll);

   gtk_paned_compute_position(GTK_PANED(fsedit),INITSIZE_X,140,500);
   gtk_paned_set_position(GTK_PANED(fsedit),(int)(INITSIZE_X/3));

   return fsedit;
}
;

void fsedit_update_all()
{

   /* select the root item */
   gtk_tree_select_item(GTK_TREE(tree),0);
   /* deselect the root item (results in the murder of our filelist) */
   gtk_tree_unselect_item(GTK_TREE(tree),0);
   /* then do the same with the whole directory tree on the left side. */
   gtk_widget_destroy(rootitem);
   /* and create a new one */
   fsedit_rootitem_create();

   /* display something on the right again :-) */
   gtk_tree_select_item(GTK_TREE(tree),0);

   updatehandlers_call(fsedit_updatehandlers);
}
;

/* register changes of the iso fs volume id */
void fsedit_volidchange()
{
   char *rootdisplay;

   rootdisplay=varman_replacevars_copy(global_defs,"/[fsedit_volid]");
   /* set new Tree item name */
   gtk_label_set_text(GTK_LABEL(gtk_container_children(GTK_CONTAINER(rootitem))->data),
		      rootdisplay);
   free(rootdisplay);
};

/* delete the whole fsedit area including multisession informations */
void fsedit_remove_all()
{
   /* remove virtual files, call update_all (registered as update handler) */
   multisession_delete();
   
   /* remove content of fsedit directory */
   vfs_remove_recursively_blocking(content->fs,"/",1);
};

void fsedit_symlinktreechanged()
{
   vfs_unixtree_setroot(edited_fs,varman_getvar(dynamic_defs,"$symlinktree"));
   fsedit_update_all();
};

void fsedit_init()
{

   gtk_tree_select_item(GTK_TREE(tree),0);

        /* update display whenever a session got imported */
   updatehandlers_register(&multisession_updatehandlers,
			   fsedit_update_all,
			   NULL);

   varman_install_handler(dynamic_defs,
			  "$symlinktree",
			  fsedit_symlinktreechanged,
			  NULL);
   varman_install_handler(global_defs,
			  "fsedit_volid",
			  fsedit_volidchange,
			  NULL);
}
;

/* delete fsedit area when exiting */
void fsedit_destroy()
{
   fsedit_remove_all();
   if (varman_getvar(dynamic_defs,"$symlinktree"))
     remove(varman_getvar(dynamic_defs,"$symlinktree"));
};
