/* Recording controls */

#ifndef RECORD_H
#define RECORD_H

#include <gtk/gtk.h>

#include "config.h"

#include "datacopydlg.h"
#include "streamcopy.h"
#include "rterm.h"

/* the different recording modes Gnometoaster is supporting */
/* this was the first mode to be there. a new instance of cdrecord
 * is run for each track to be written */
#define RECORD_MODE_TAO_MULTI  0
/* perform disc-at-once recording using cdrdao. This was the second
 * variant to be supported. It runs cdrdao only once, transparently
 * changing data sources when hitting a track boundary */
#define RECORD_MODE_DAO_CDRDAO 1
/* Track at once recording using cdrecord. Like _DAO_CDRDAO, cdrecord
 * is called only once with named pipes passed to it for the different
 * tracks. This way, cdrecord has control over the whole cd which is
 * necessary when writing to some recorders */
#define RECORD_MODE_TAO_SINGLE 2
/* Same as above with the only difference that cdrecord is supposed to
 * write in DAO mode. This can be accomplished by simply passing the
 * -dao switch on cdrecord's commandline */
#define RECORD_MODE_DAO_SINGLE 3

/* the following structure is used to control the recording process */
typedef struct
{
   /* one of the definitions above (RECORD_MODE_*) */
   int writing_mode;
   /* we have to remember the filename of the TOC file to be able to
    * delete it once it is no longer needed */
   char *tocfile;
   /* those pipes connect to the recording backend used by this recording
    * process */
   int inpipe;
   int outpipe;
   int errpipe;
   /* those are used to control the state of the recording backend */
   int cdrecordpid;
   /* the current track in our tracklist. For real multi writing 
    * (not only multiplexing), we have to make a local copy of the
    * tracklist as well */
   int currenttrack;
   /* the progress dialog, to be accessed by the main thread only */
   datacopydlg_dlginfo *dlg;
   /* This is being used to measure the time it takes to write, e.g. 
    * the leadout */
   int measure_timeout_handle;
   int measure_size;

   /* pipe output of backend into recording terminal */
   rterm_pipeinfo *outtag;
   rterm_pipeinfo *errtag;
   
   streamcopy_state *cs;
} record_recordingstate;
   
extern int record_active;  // True when cd creation is running

GtkWidget *record_create();

void record_startrecord(GtkWidget *w);
void record_clear(GtkWidget *w);

#endif // RECORD_H
