#include <gtk/gtk.h>
#include <string.h>
#include "main.h"

/* testing */
GdkRectangle rect;
GtkWidget *tipwindow;
gulong timeout = 0;
static gboolean mw_tooltip_timeout(GtkWidget *tv);
PangoLayout *layout = NULL;

gchar *get_tooltip_text()
	{
	gchar *summary, *comment, *due_date,*priority, *retval, *category;
	GString *string;
	gint prio;
	GtkTreePath *path;
	GtkTreeIter iter;
	int i = gtk_option_menu_get_history(GTK_OPTION_MENU(mw.option));
	string = g_string_new("");
	if (gtk_tree_view_get_path_at_pos(GTK_TREE_VIEW(mw.treeview), rect.x, rect.y, &path, NULL, NULL, NULL))
	{
	gtk_tree_model_get_iter(GTK_TREE_MODEL(mw.list), &iter, path);	
	gtk_tree_model_get(GTK_TREE_MODEL(mw.list), &iter, 
			SUMMARY, &summary, 
			F_DATE, &due_date,
			COMMENT, &comment,
			PRIOSTR, &priority,
			PRIORITY, &prio,
			CATEGORY, &category, 
			-1); 
	gtk_tree_path_free(path);
	if(i == 0)g_string_append_printf(string, "<i>%s:</i>\n", category); 
	g_string_append_printf(string, _("<b>Summary:</b>\t%s\n"), summary);
	g_string_append_printf(string, _("<b>Due date:</b>\t%s\n"), due_date);
	if(prio == 0) g_string_append_printf(string, _("<b>Priority:</b>\t<span color=\"dark green\">%s</span>"), priority);
	else if(prio == 1) g_string_append_printf(string, _("<b>Priority:</b>\t%s"), priority);
	else  g_string_append_printf(string, _("<b>Priority:</b>\t<span color=\"red\">%s</span>"), priority);
	if(strlen(comment)) g_string_append_printf(string, _("\n<b>Comment:</b>\t%s\n"), comment); 

	/* free all the stuff */
	g_free(summary);
	g_free(due_date);
	g_free(comment);
	g_free(priority);
//	g_free(prio);
	g_free(category);

	retval = string->str;	
	g_string_free(string, FALSE);

	return retval;
	}
	else return g_strdup("oeps");
	}
    
    

void mw_paint_tip(GtkWidget *widget, GdkEventExpose *event)
{
	GtkStyle *style;
	char *tooltiptext = get_tooltip_text();
	pango_layout_set_markup(layout, tooltiptext, strlen(tooltiptext));
	pango_layout_set_wrap(layout, PANGO_WRAP_WORD);
	pango_layout_set_width(layout, 300000);
	style = tipwindow->style;

	gtk_paint_flat_box (style, tipwindow->window, GTK_STATE_NORMAL, GTK_SHADOW_OUT,
			    NULL, tipwindow, "tooltip", 0, 0, -1, -1);


	gtk_paint_layout (style, tipwindow->window, GTK_STATE_NORMAL, TRUE,
			  NULL, tipwindow, "tooltip", 4, 4, layout);

	//g_object_unref(layout);
	g_free(tooltiptext);
	return;
}

gboolean mw_tooltip_timeout(GtkWidget *tv)
{
	GtkTreePath *path;
	GtkTreeIter iter;
	GValue val = {0};
	int scr_w,scr_h, w, h, x, y;
	char *tooltiptext = NULL;
    
	tooltiptext = get_tooltip_text();
	
	tipwindow = gtk_window_new(GTK_WINDOW_POPUP);
	tipwindow->parent = tv;
	gtk_widget_set_app_paintable(tipwindow, TRUE);
	gtk_window_set_resizable(GTK_WINDOW(tipwindow), FALSE);
	gtk_widget_set_name(tipwindow, "gtk-tooltips");
	g_signal_connect(G_OBJECT(tipwindow), "expose_event",
			G_CALLBACK(mw_paint_tip), NULL);
	gtk_widget_ensure_style (tipwindow);

	layout = gtk_widget_create_pango_layout (tipwindow, NULL);
	pango_layout_set_wrap(layout, PANGO_WRAP_WORD);
	pango_layout_set_width(layout, 300000);
	pango_layout_set_markup(layout, tooltiptext, strlen(tooltiptext));
	scr_w = gdk_screen_width();
	scr_h = gdk_screen_height();
	pango_layout_get_size (layout, &w, &h);
	w = PANGO_PIXELS(w) + 8;
	h = PANGO_PIXELS(h) + 8;

	gdk_window_get_pointer(NULL, &x, &y, NULL);
	if (GTK_WIDGET_NO_WINDOW(mw.window))
		y+=mw.window->allocation.y;

	x -= ((w >> 1) + 4);

	if ((x + w) > scr_w)
		x -= (x + w) - scr_w;
	else if (x < 0)
		x = 0;

	if ((y + h + 4) > scr_h)
		y = y - h;
	else
		y = y + 6;
//	g_object_unref(layout);
	g_free(tooltiptext);
	gtk_widget_set_size_request(tipwindow, w, h);
	gtk_window_move(GTK_WINDOW(tipwindow), x, y);
	gtk_widget_show(tipwindow);

	return FALSE;
}

gboolean mw_motion_cb (GtkWidget *tv, GdkEventMotion *event, gpointer null)
{
	GtkTreePath *path;
	if(!settings.list_tooltip) return FALSE;
		
	if(rect.y == 0 && rect.height == 0 && timeout)
	    {
		    g_source_remove(timeout);
		    timeout = 0;
		if (tipwindow) {
			gtk_widget_destroy(tipwindow);
			tipwindow = NULL;
		}
		    return FALSE;
	    
	    }
	if (timeout) {
		if (((int)event->y > rect.y) && (((int)event->y - rect.height) < rect.y))
			return FALSE;
		
		if(event->y == 0)
		    {
		    g_source_remove(timeout);
		    return FALSE;
		    
		    }
		/* We've left the cell.  Remove the timeout and create a new one below */
		if (tipwindow) {
			gtk_widget_destroy(tipwindow);
			tipwindow = NULL;
		}
		
		g_source_remove(timeout);
	}
	
	if(gtk_tree_view_get_path_at_pos(GTK_TREE_VIEW(tv), event->x, event->y, &path, NULL, NULL, NULL))
		{
		gtk_tree_view_get_cell_area(GTK_TREE_VIEW(tv), path, NULL, &rect);
		gtk_tree_path_free(path);
		if(rect.y != 0 && rect.height != 0) timeout = g_timeout_add(500, (GSourceFunc)mw_tooltip_timeout, tv);
		}
	return FALSE;
}

void mw_leave_cb (GtkWidget *w, GdkEventCrossing *e, gpointer n)
{
	if (timeout) {
		g_source_remove(timeout);
		timeout = 0;
	}
	if (tipwindow) {
	gtk_widget_destroy(tipwindow);
	g_object_unref(layout);
		tipwindow = NULL;
	}
}

