using System;
using System.Text.RegularExpressions;
using Gtk;
using System.IO;
using System.Threading;
using System.Diagnostics;
using Cairo;
using GConf;
using Sexy;
using Mono.Unix;
using System.Net;

namespace gtwitter
{
	
	public partial class MainWindow: Gtk.Window
	{
		public static Window mainWindow;
		
		//classes
		GetTwitterData getTwitterData = new GetTwitterData();
		PostToTwitter postToTwitter = new PostToTwitter();
		//CompositeInterface compositeInterface = new CompositeInterface();
		public static int navigation = 0;
		public static ReadInfo readInfo = new ReadInfo();
		
		//dialogs
		PreferencesWindow preferencesWindow;
		AboutDialog aboutDialog; 
		
//#if GTK_2_10
		//status icon
 		StatusIcon statusIcon = new StatusIcon();
//#endif
		
		//sexy widgets
		public UrlLabel urlLabel1  = new UrlLabel();
		public IconEntry PostEntry = new IconEntry();
		
		public string imageUrl = "";
		public static string screenName = "";
		public string TwitterPostUrl = "http://twitter.com/statuses/update.xml";
		public string TwitterFriendsUrl = "http://twitter.com/statuses/friends_timeline.xml";
		public string TwitterPublicUrl = "http://twitter.com/statuses/public_timeline.xml";
		public string TwitterDirectUrl = "http://twitter.com/direct_messages.xml";
		
		//gconf
		public static GConf.Client client;
		public static String GCONF_APP_PATH = "/apps/gtwitter";
		public static String SOURCE_KEY = GCONF_APP_PATH + "/source";
		public static String USERNAME_KEY = GCONF_APP_PATH + "/username";
		public static String PASSWORD_KEY = GCONF_APP_PATH + "/password";
		public static String REFRESH_KEY = GCONF_APP_PATH + "/refresh";
		public static String WINDOW_X_KEY = GCONF_APP_PATH + "/window_x";
		public static String WINDOW_Y_KEY = GCONF_APP_PATH + "/window_y";
		public static String WINDOW_WIDTH_KEY = GCONF_APP_PATH + "/window_width";
		public static String WINDOW_HEIGHT_KEY = GCONF_APP_PATH + "/window_height";
		public static String HIDDEN_KEY = GCONF_APP_PATH + "/hidden_at_startup";
		public static String FANCY_UI_KEY = GCONF_APP_PATH + "/fancy_ui";
		//notifications keys
		public static String NOTIFY_KEY = GCONF_APP_PATH + "/notify_on";
		public static String NOTIFY_DIRECT_KEY = GCONF_APP_PATH + "/notify_direct";
		public static String NOTIFY_PUBFRIE_KEY = GCONF_APP_PATH + "/notify_public_friends";
		public static String NOTIFY_ALL_KEY = GCONF_APP_PATH + "/notify_all";
	
		public static int x = 100;
		public static int y = 100;
		
		public static bool directM = false;
		
		//threads
		Thread getDataThread;
		Thread imageThread;
		Thread refreshThread;
		Thread postThread;
		Thread readStoredData;
		Thread populateTreeview;
		//bool threadOK = true;
		
		//columns needed for hiding/showing
		TreeViewColumn imageColumn;
		TreeViewColumn timeColumn;
		TreeViewColumn nameColumn;
		
		//set config directory in users /home
		public static string configDir = Environment.GetEnvironmentVariable("HOME") + "/.gtwitter/";
		
		//list store for treeview
		public ListStore liststore = new Gtk.ListStore (typeof (string), typeof (Gdk.Pixbuf), typeof (string), typeof (string));
		
		public MainWindow (): base (Gtk.WindowType.Toplevel)
		{
		   	//Catalog.Init ("i18n", "./locale");
			
			if (MainClass.composite) {
				//composite - transparency
				Gdk.Screen screen = this.Screen;
				Gdk.Colormap colormap = screen.RgbaColormap;
				if (colormap == null)
					colormap = screen.RgbColormap;
				
				this.Colormap = colormap;
				this.AppPaintable = true;
			}
			
			//window
			Build();
			mainWindow = this;
			Title = "gTwitter " + MainClass.version;
			vpaned1.Position = 84;
			TopNotebook.Page = 0;
						
			//url label sexy
			vbox2.Add(urlLabel1);
			urlLabel1.LineWrap = true;
			urlLabel1.Selectable = true;
			urlLabel1.Xalign = 0.0f;
			urlLabel1.Yalign = 0.0f;
			urlLabel1.WidthRequest = 100;
			urlLabel1.Markup = String.Format("<span foreground='darkblue'>{0}</span>",
				Catalog.GetString ("Click on Preferences button to enter username and password"));
			urlLabel1.Show();
			
			urlLabel1.UrlActivated += delegate(object o, UrlActivatedArgs args) {
				Process.Start("gnome-open", args.Url);
			};
			
			//post entry sexy
			hbox2.Add(PostEntry);
			PostEntry.AddClearButton();
			//PostEntry.SetIcon(IconEntryPosition.Primary, new Image(Stock.Network, IconSize.Menu));
			PostEntry.Text = Catalog.GetString ("What are you doing?");
			PostEntry.Show();
			
			PostEntry.Activated += OnPostEntryActivated;
			PostEntry.FocusInEvent += OnPostEntryFocusInEvent;
			PostEntry.FocusOutEvent += OnPostEntryFocusOutEvent;
			PostEntry.Changed += OnPostEntryChanged;
			//PostEntry.IconPressed += delegate(object o, IconPressedArgs args) {
			//};
			
			if (MainClass.composite) {
				scrolledwindow1.BorderWidth = 10;
				Decorated = false;
			}
			
			//gconf client & set defaults
			client = new GConf.Client();
			
			string passCheck = "";
			try {
				passCheck = (string) client.Get (PASSWORD_KEY);

				mainWindow.Move((int) client.Get (WINDOW_X_KEY), (int) client.Get (WINDOW_Y_KEY));
				mainWindow.Resize((int) client.Get (WINDOW_WIDTH_KEY), (int) client.Get (WINDOW_HEIGHT_KEY));
				
				int sourceStart = (int) client.Get (SOURCE_KEY);
				if (sourceStart == 0) {
					Friends.Active = true;
					Source.Label = Friends.Label;
				}
				if (sourceStart == 1) {
					Public.Active = true;
					Source.Label = Public.Label;
				}
				if (sourceStart == 2) {
					Direct.Active = true;
					Source.Label = Direct.Label;
				}
				
				TweetView.Active = (bool) client.Get (FANCY_UI_KEY);
				
				x = (int) client.Get (WINDOW_X_KEY);
				y = (int) client.Get (WINDOW_Y_KEY);
			}
			catch (NoSuchKeyException) { }
			
			//treeview
			TreeViewColumn numbersColumn = new TreeViewColumn();
			numbersColumn.Title = "#";
			numbersColumn.Visible = false;
			CellRendererText numbersCell = new CellRendererText();
			numbersColumn.PackStart(numbersCell, true);
			
			imageColumn = new TreeViewColumn();
			imageColumn.Title = "Image";
			CellRendererPixbuf imageCell = new CellRendererPixbuf();
			imageColumn.PackStart(imageCell, true);
			
			nameColumn = new TreeViewColumn();
			nameColumn.Title = "Name";
			nameColumn.Expand = true;
			CellRendererText nameCell = new CellRendererText();
			nameCell.Yalign = 0.0f;
			nameCell.WrapWidth = 260;
			nameCell.WrapMode = Pango.WrapMode.WordChar;
			nameColumn.Sizing = Gtk.TreeViewColumnSizing.Autosize;
			nameColumn.PackStart (nameCell, true);
			
			timeColumn = new TreeViewColumn();
			timeColumn.Title = "Time";
			CellRendererText timeCell = new CellRendererText();
			timeColumn.PackStart (timeCell, true);

			Treeview1.AppendColumn(numbersColumn);
			Treeview1.AppendColumn(imageColumn);
			Treeview1.AppendColumn(nameColumn);
			Treeview1.AppendColumn(timeColumn);
			
			numbersColumn.AddAttribute (numbersCell, "text", 0);
			imageColumn.AddAttribute (imageCell, "pixbuf", 1);
			nameColumn.AddAttribute (nameCell, "markup", 2);
			timeColumn.AddAttribute (timeCell, "markup", 3);
			
			//create config and images directory
			Gnome.Vfs.Vfs.Initialize();
			Gnome.Vfs.Directory.Create(configDir.ToString(), Gnome.Vfs.FilePermissions.UserAll);
			Gnome.Vfs.Directory.Create(configDir.ToString() + "images", Gnome.Vfs.FilePermissions.UserAll);
			//Directory.CreateDirectory(configDir);
			//Directory.CreateDirectory(configDir + "images");
			
//#if GTK_2_10
			//status icon
			statusIcon.FromPixbuf = new Gdk.Pixbuf(null, "gtwitter-22.png");
			statusIcon.Tooltip = String.Format("gTwitter {0}", MainClass.version);
			statusIcon.Activate += StatusIconActivate;
			statusIcon.PopupMenu += StatusIconPopupMenu;
			
			PreferencesButton.Visible = false;
			AboutButton.Visible = false;
			QuitButton.Visible = false;
			
//#endif
			
			AboutButton.Clicked += new EventHandler(this.AboutDialogActivate);
			//Viewport vp1 = (Viewport)scrolledwindow1.Child;
			//vp1.ModifyBg(StateType.Normal , new Gdk.Color(61,120,183));
			
			//PostEntry.GrabFocus();
			Statusbar1.Push(0, "Connecting...");
			
			//create dialogs
			aboutDialog = new AboutDialog(this);
			preferencesWindow = new PreferencesWindow();

			if ( passCheck.Length > 2 ) {
				
				//start getDataThread
				getDataThread = new Thread(new ThreadStart(DataThreadRoutine));
				getDataThread.Start();
				//timeout n seconds if it takes to much time, kill the thread
				//GLib.Timeout.Add (40000, new GLib.TimeoutHandler (TooLong));
			}
			else {
				Statusbar1.Push(0, Catalog.GetString ("Enter username/password in Preferences."));
				RefreshButton.Sensitive = true;
				//PostEntry.Sensitive = true;
				menubar1.Sensitive = true;
				preferencesWindow.Show();
			}

			ActivateRefresh();
			
			Gnome.Vfs.Vfs.Shutdown();
		}

		//status icon click
		void StatusIconActivate(object o, EventArgs e)
		{
			if (mainWindow.Visible) {
				
				if (mainWindow.IsActive) {
					mainWindow.GetPosition(out x, out y);
					mainWindow.Hide();
				}
				else
					mainWindow.Present();
			}
			else {
				mainWindow.Move(x, y);
				mainWindow.Show();
				
				//stop blinking the status icon
				//statusIcon.Blinking = false;
			}	
		}
		void SHActivate(object o, EventArgs e)
		{
			if (mainWindow.Visible) {

				mainWindow.GetPosition(out x, out y);
				mainWindow.Hide();
			}
			else {
				mainWindow.Move(x, y);
				mainWindow.Show();
			}	
		}
		//status icon menu
		void StatusIconPopupMenu(object o, EventArgs e)
		{
			Menu popupMenu = new Menu();
			
			//menu items
			MenuItem menuPopupSH = new MenuItem("Show/Hide");
			
			ImageMenuItem menuPopupRef = new ImageMenuItem ("Refresh");
			menuPopupRef.Image = new Image(Stock.Refresh, IconSize.Menu);
			menuPopupRef.Sensitive = RefreshButton.Sensitive;
			
			ImageMenuItem menuPopupPref = new ImageMenuItem ("Preferences");
			menuPopupPref.Image = new Image(Stock.Preferences, IconSize.Menu);
			
			ImageMenuItem menuPopupAbout = new ImageMenuItem ("About");
			menuPopupAbout.Image = new Image(Stock.About, IconSize.Menu);
			
			ImageMenuItem menuPopupQuit = new ImageMenuItem ("Quit");
			menuPopupQuit.Image = new Image(Stock.Quit, IconSize.Menu);
			
			//add items
			popupMenu.Add(menuPopupSH);
			popupMenu.Add(new Gtk.SeparatorMenuItem());
			popupMenu.Add(menuPopupRef);
			popupMenu.Add(menuPopupPref);
			popupMenu.Add(menuPopupAbout);
			popupMenu.Add(new Gtk.SeparatorMenuItem());
			popupMenu.Add(menuPopupQuit);
			
			//events
			menuPopupSH.Activated += new EventHandler(this.SHActivate);
			menuPopupRef.Activated += new EventHandler(this.OnRefreshButtonClicked);
			menuPopupPref.Activated += new EventHandler(this.OnPreferencesButtonClicked);
			menuPopupAbout.Activated += new EventHandler(this.AboutDialogActivate);
			menuPopupQuit.Activated += new EventHandler(this.OnQuitButtonClicked);
			
			popupMenu.ShowAll();
      		popupMenu.Popup();
		}
		void AboutDialogActivate(object o, EventArgs e)
		{
			aboutDialog.Show();
		}
		
		//activate read function
		public void ReadStoredData()
		{
			populateTreeview = new Thread(new ThreadStart(PopulateTreeviewThreadRoutine));
			
			//read data from XML
			readInfo.ReadInfoNow();
			
			//start thread
			populateTreeview.Start();
		}
		
		//treeview change event
		protected virtual void OnTreeview1CursorChanged(object sender, System.EventArgs e)
		{
			directM = false;
			
			if (!TweetView.Active) {
				
				TopNotebook.Page = 0;
				NameLabel.Text = "";
				ScreenNameLabel.Text = "";
				LocationLabel.Text = "";
				DescriptionLabel.Text = "";
				urlLabel2.Text = "";
				
				imageThread = new Thread(new ThreadStart(ImageThreadRoutine));
				
				//clear statusbar and image
				//Statusbar1.Pop(0);
				//Statusbar1.Pop(0);
				UserImage.Stock = "gtk-missing-image";
				UserImage.IconSize = 6;
				
				//TODO: Add the user image in the notification
				//TODO: atach the notification to the statusIcon
				
				//navigation
				TreeIter iter = new TreeIter();
			    TreeModel model;
			    GLib.Value val = new GLib.Value ();
			    Treeview1.Selection.GetSelected (out model, out iter);
			    liststore.GetValue (iter, 0, ref val);
			    string navigation1 = (string) val;
				
				try {
					navigation = Int32.Parse(navigation1)-1;
				} catch (ArgumentNullException) {}
				
				try {
					
					if ((int) client.Get (SOURCE_KEY) != 2) {
						
						string text = readInfo.text[navigation];

						//call url detection
						text = UrlDetection(text);
						
						UserName.Markup = "<span size='large' weight='bold'>" + readInfo.name[navigation] + "</span>";
						UserNLabel.Markup = "<span foreground='gray'>" + readInfo.screenName[navigation] + "</span>";
						
						//fix & character
						text = text.Replace("&amp;lt;", "&lt;");
						text = text.Replace("&amp;gt;", "&gt;");
						urlLabel1.Markup = "<span foreground='darkblue'>" + text + "</span>";
											
						screenName = readInfo.screenName[navigation];
						
						//use saved image
						UserImage.FromFile = (configDir+"images/"+screenName+".png");
						UserImage.IconSize = 6;
						
						/*
						if (mainWindow.Visible == false) {
							if ((bool) client.Get (NOTIFY_KEY) == true)
							{
								if ((bool) client.Get (NOTIFY_PUBFRIE_KEY) == true || (bool) client.Get (NOTIFY_ALL_KEY) == true)
								{
									
									Notification notify = new Notification ();
									notify.Summary = screenName;
									notify.Body = text;
									notify.Icon = Gdk.Pixbuf.LoadFromResource ("gtwitter-48.png");
									notify.Urgency = Urgency.Normal;
								
									notify.Timeout = 4500;
									notify.Show ();
									//statusIcon.Blinking = true;
								}
							}
						}*/
						//if it doesn't exist fetch it
						if (UserImage.Stock == "gtk-missing-image") {
							
							Statusbar1.Push(0, Catalog.GetString ("Fetching user image..."));
							imageUrl = readInfo.image[navigation];
							
							imageThread.Start();
						}
					}
					else {
						
						string text = readInfo.direct_text[navigation];
		
						//call url detection
						text = UrlDetection(text);
						
						UserName.Markup = String.Format("<span size='large' weight='bold'>{0}</span>",
							Catalog.GetString ("Direct Messages"));
						UserNLabel.Markup = "<span foreground='gray'>" + readInfo.direct_screenName[navigation] + "</span>";
						urlLabel1.Markup = "<span foreground='darkblue'>" + text + "</span>";
						//urlLabel1.Text =  readInfo.text[Int32.Parse(navigation) - 1];
						
						screenName = readInfo.direct_screenName[navigation];
						
						//use saved image
						UserImage.FromFile = (configDir+"images/"+screenName+".png");
						UserImage.IconSize = 6;
						
						/*
						if (mainWindow.Visible == false) {
							if ((bool) client.Get (NOTIFY_DIRECT_KEY) == true)
							{
								Notification notify = new Notification ();
								notify.Summary = "Direct Tweet from " + readInfo.direct_screenName[navigation];
								notify.Summary = text;
								notify.Icon = Gdk.Pixbuf.LoadFromResource ("gtwitter-48.png");
								notify.Timeout = 4500;
								notify.Show ();
								//statusIcon.Blinking = true;
							}
							
							if ((bool) client.Get (NOTIFY_ALL_KEY) == true)
							{
								Notification notify = new Notification ();
								notify.Summary = readInfo.direct_screenName[navigation];
								notify.Summary = text;
								notify.Icon = Gdk.Pixbuf.LoadFromResource ("gtwitter-48.png");
								notify.Timeout = 4500;
								notify.Show ();
								//statusIcon.Blinking = true;
							}
						}*/
					}
					
				}
				catch (ArgumentNullException) {
					Statusbar1.Push(0, Catalog.GetString ("No connection or wrong username/password."));
				}
				catch (NullReferenceException) {
				}
			}
		}
		
		//web url detection
		public static string UrlDetection(string text)
		{
			// match protocol://url
			Regex httpRegex = new Regex(@"([a-z]+://[^)(,!\s]+)", RegexOptions.IgnoreCase);
			// match www. url
			Regex wwwRegex = new Regex(@"(?:^|\s)(www\.[^)(,!\s]+)", RegexOptions.IgnoreCase);
			// match @nickname
			Regex atRegex = new Regex(@"@([^\s:,!]+)", RegexOptions.IgnoreCase);
			
			text = httpRegex.Replace(text, "<a href=\"$1\">$1</a>");
			text = atRegex.Replace(text, "@<a href=\"http://twitter.com/$1\">$1</a>");
			text = wwwRegex.Replace(text, "<a href=\"http://$1\">$1</a>");
			
			return text;
		}

		//preferences button
		protected virtual void OnPreferencesButtonClicked(object sender, System.EventArgs e)
		{
			preferencesWindow.Show();
		}
		
		//kill threads if it takes too long
		/*bool TooLong()
		{
			if (!threadOK) {
				
				try {
					if (getDataThread != null) {
						getDataThread.Abort();
						getDataThread = null;
					}
					if (refreshThread != null) {
						refreshThread.Abort();
						refreshThread = null;
					}
				} catch (Exception) { }
				
				Gtk.Application.Invoke (delegate {
					Statusbar1.Push(0, "This is taking too long, check you internet connection.");
				});
			}
			
			return false;
		}*/
		
		public void ActivateRefresh()
		{
			//refresh stuff
			uint timeout = 300000;
			try {
				if ((int) client.Get (REFRESH_KEY) == 0)
					timeout = 60000;
				if ((int) client.Get (REFRESH_KEY) == 1)
					timeout = 180000;
				if ((int) client.Get (REFRESH_KEY) == 2)
					timeout = 300000;
				if ((int) client.Get (REFRESH_KEY) == 3)
					timeout = 600000;
				if ((int) client.Get (REFRESH_KEY) == 4)
					timeout = 600000;
				if ((int) client.Get (REFRESH_KEY) == 5)
					timeout = 1;
			}
			catch (NoSuchKeyException) { }
			
			if (timeout != 1)
				GLib.Timeout.Add (timeout, new GLib.TimeoutHandler (UpdateRefresh));
		}
		public bool UpdateRefresh()
		{
			if (!getDataThread.IsAlive) {
				
				RefreshButton.Sensitive = false;
				PostEntry.Sensitive = false;
				menubar1.Sensitive = false;
				
				Statusbar1.Push(0, Catalog.GetString ("Connecting..."));
				refreshThread = new Thread(new ThreadStart(DataThreadRoutine));

				refreshThread.Start();
				//GLib.Timeout.Add (40000, new GLib.TimeoutHandler (TooLong));
			}
			
			return true;
		}
		//refresh button
		protected virtual void OnRefreshButtonClicked(object sender, System.EventArgs e)
		{
			Statusbar1.Push(0, Catalog.GetString ("Connecting..."));
			refreshThread = new Thread(new ThreadStart(DataThreadRoutine));
	
			UserImage.Stock = "gtk-network";
			UserImage.IconSize = 6;
			UserName.Markup = String.Format("<span size='large' weight='bold'>{0}</span>",
				Catalog.GetString ("Fetching data..."));
			UserNLabel.Markup = "";
			urlLabel1.Text = "";
			
			refreshThread.Start();
			//GLib.Timeout.Add (40000, new GLib.TimeoutHandler (TooLong));
			
			RefreshButton.Sensitive = false;
			PostEntry.Sensitive = false;
			menubar1.Sensitive = false;
		}
		
		//user image set
		public void ImageThreadRoutine()
		{
			try {
				Gtk.Application.Invoke (delegate {
					//get user image
					//try {
						UserImage.FromPixbuf = getTwitterData.GetUserImage(imageUrl);
					//} catch (NullReferenceException) {Console.WriteLine("nullll");}
					if (UserImage.Pixbuf == null) {
						Statusbar1.Push(0, Catalog.GetString ("Unable to get user image"));
						UserImage.Stock = "gtk-missing-image";
						UserImage.IconSize = 6;
					}
					//save friends image if it doesn't exist
					if ((int) client.Get (SOURCE_KEY) == 0 && !System.IO.File.Exists(configDir + "images/" + screenName + ".png"))
						UserImage.Pixbuf.Save(configDir + "images/" + screenName + ".png", "png");

					Statusbar1.Pop(0);
				});
			}
			catch (Exception ex) {
				Gtk.Application.Invoke (delegate {
					Statusbar1.Push(0, Catalog.GetString("Unable to get user image"));
					UserImage.Stock = "gtk-missing-image";
					UserImage.IconSize = 6;
				});
				
				if (MainClass.debug) {
					Console.WriteLine("Get image exception: ImageThreadRoutine()");
					Console.WriteLine(ex.StackTrace);
				}
			}

		}
		
		//populate treeview
		public void PopulateTreeviewThreadRoutine()
		{
			//TweetView not activated
			if (!TweetView.Active) {
				
				Gtk.Application.Invoke (delegate {
					
					liststore.Clear();
					timeColumn.Visible = true;
					imageColumn.Visible = false;
				
					try {
						
						if ( (int) client.Get (SOURCE_KEY) != 2 ) {
							string si, name, time;
							for (int i = 0; i < readInfo.statusCount; i++) {
								
								si = (i+1).ToString();
								name = String.Format("<span size='small'>{0}</span>", readInfo.name[i]);
								time = String.Format("<span size='small'>{0}</span>", readInfo.relative_time[i]);
								
								//Console.WriteLine(si + name + time);
								liststore.AppendValues (si,
								                        null,
								                        name,
								                        time);
							}
						}
						else {
							
							string si, screen_name, time;
							for (int i = 0; i < readInfo.direct_statusCount; i++) {
								
								si = (i+1).ToString();
								screen_name = String.Format("<span size='small'>{0}</span>", readInfo.direct_screenName[i]);
								time = String.Format("<span size='small'>{0}</span>", readInfo.direct_relative_time[i]);
								
								liststore.AppendValues (si,
								                        null,
								                        screen_name,
								                        time);
							}
						}
						
						Treeview1.Model = liststore;
						
						if (liststore != null)
							Treeview1.SetCursor(TreePath.NewFirst(), null, false);
						
					}
					catch (NullReferenceException ex) {
						if (MainClass.debug) {
							Console.WriteLine("Treeview exception: PopulateTreeview()");
							Console.WriteLine(ex.StackTrace);
						}
					}
					
					RefreshButton.Sensitive = true;
					PostEntry.Sensitive = true;
					menubar1.Sensitive = true;
				});
			}
			//TweetView activated
			else {
			
				Gtk.Application.Invoke (delegate {
				
					liststore.Clear();
					imageColumn.Visible = true;
					timeColumn.Visible = false;
				
					try {
						
						if ( (int) client.Get (SOURCE_KEY) != 2 ) {
							string si, text;
							for (int i = 0; i < readInfo.statusCount; i++) {
								
								si = (i+1).ToString();
								
								text = String.Format("<b>{1}</b> <span size='small' foreground='gray'>({2})</span>\n<span size='small' foreground='darkblue'>{0}</span>", 
								                     readInfo.text[i], readInfo.name[i], readInfo.relative_time[i]);
								
								String imageFile = (configDir+"images/"+readInfo.screenName[i]+".png");
								
								Gdk.Pixbuf uPixbuf;
								try {
									
									uPixbuf = new Gdk.Pixbuf(imageFile);
								}
								catch (GLib.GException) {
			
									imageUrl = readInfo.image[i];
									
									uPixbuf = getTwitterData.GetUserImage(imageUrl);
									
									//save friends image if it doesn't exist
									if ((int) client.Get (SOURCE_KEY) == 0 && !System.IO.File.Exists(configDir + "images/" + readInfo.screenName[i] + ".png"))
										uPixbuf.Save(configDir + "images/" + readInfo.screenName[i] + ".png", "png");
									
									//uPixbuf = new Gdk.Pixbuf(null, "gtwitter-22.png");
									//Queue(imageUrl);
								}
								
								liststore.AppendValues (si,
								                        uPixbuf,
								                        text,
								                        null);
							}
						}
						else {
							
							string si, text;
							for (int i = 0; i < readInfo.direct_statusCount; i++) {
								
								si = (i+1).ToString();
								text = String.Format("<b>{1}</b> <span size='small' foreground='gray'>({2})</span>\n<span size='small' foreground='darkblue'>{0}</span>",
								                     readInfo.direct_text[i], readInfo.direct_screenName[i], readInfo.direct_relative_time[i]);
								
								liststore.AppendValues (si,
								                        new Gdk.Pixbuf(null, "gtwitter-48.png"),
								                        text,
								                        null);
							}
						}
						
						Treeview1.Model = liststore;
						
						if (liststore != null)
							Treeview1.SetCursor(TreePath.NewFirst(), null, false);
						
					}
					catch (NullReferenceException ex) {
						if (MainClass.debug) {
							Console.WriteLine("Treeview exception: PopulateTreeview()");
							Console.WriteLine(ex.StackTrace);
						}
					}
					
					RefreshButton.Sensitive = true;
					PostEntry.Sensitive = true;
					menubar1.Sensitive = true;
				});
			}
		
		}
		/*
		HttpWebRequest req;
		void Queue (string url)
		{
			Gdk.Pixbuf pix1;
			
			req = (HttpWebRequest) WebRequest.Create (url);
			req.KeepAlive = false;
			
			WebResponse resp = null;
			
			resp = req.GetResponse ();
			req.BeginGetRequestStream (mycallback, this);
			
			
			Stream s = resp.GetResponseStream ();
			pix1 = new Gdk.Pixbuf (s);

			
			resp.Close ();
			
		}

		void mycallback (IAsyncResult r)
		{
		    req.EndGetRequestStream (r);
			
		    Gtk.Application.Invoke (delegate {
		        Console.WriteLine("sdddddddd");
		    });

		} 
		*/
		
		
		//thread function to call GetTwitterData
		public void DataThreadRoutine()
		{
			readStoredData = new Thread(new ThreadStart(ReadStoredData));
			
			int sourceKey = 0;
			string usernameKey = "";
			string passKey = "";
						
			try {
				sourceKey = (int) client.Get (SOURCE_KEY);
				usernameKey = (string) client.Get (USERNAME_KEY);
				passKey = (string) client.Get (PASSWORD_KEY);
			
				//source is friends timeline
				if (sourceKey == 0) {

					if ( getTwitterData.GetTwitterFriendsData(TwitterFriendsUrl, usernameKey, passKey, configDir) ) {
						
						Gtk.Application.Invoke (delegate {
							Statusbar1.Push(0, Catalog.GetString("Connection ok, populating with data."));
							urlLabel1.Selectable = true;
						});
						
						//start thread
						readStoredData.Start();
					}
					else {
						Gtk.Application.Invoke (delegate {
							Statusbar1.Push(0, Catalog.GetString ("Connection failed!"));
							UserName.Markup = String.Format("<span size='large' weight='bold'>{0}</span>",
								Catalog.GetString("Connection failed!"));
							RefreshButton.Sensitive = true;
							//PostEntry.Sensitive = true;
							menubar1.Sensitive = true;
						});
					}

					GLib.Timeout.Add (3000, new GLib.TimeoutHandler (ClearStatusbar));
				}
				
				//source is public timeline
				if (sourceKey == 1) {
					
					if ( getTwitterData.GetTwitterPublicData(TwitterPublicUrl, configDir) ) {

						Gtk.Application.Invoke (delegate {
							Statusbar1.Push(0, Catalog.GetString("Connection ok, populating with data."));
							urlLabel1.Selectable = true;
						});
						
						//start thread
						readStoredData.Start();	
					}
					else {
						Gtk.Application.Invoke (delegate {
							Statusbar1.Push(0, Catalog.GetString ("Connection failed!"));
							UserName.Markup = String.Format("<span size='large' weight='bold'>{0}</span>",
								Catalog.GetString ("Connection failed!"));
							RefreshButton.Sensitive = true;
							//PostEntry.Sensitive = true;
							menubar1.Sensitive = true;
						});
					}
					
					GLib.Timeout.Add (3000, new GLib.TimeoutHandler (ClearStatusbar));
				}
				
				if (sourceKey == 2) {

					if ( getTwitterData.GetTwitterDirectData(TwitterDirectUrl, usernameKey, passKey, configDir) ) {
						
						Gtk.Application.Invoke (delegate {
							Statusbar1.Push(0, Catalog.GetString("Connection ok, populating with data."));
							urlLabel1.Selectable = true;
						});
						
						//start thread
						readStoredData.Start();
					}
					else {
						Gtk.Application.Invoke (delegate {
							Statusbar1.Push(0, Catalog.GetString("Connection failed!"));
							UserName.Markup = String.Format("<span size='large' weight='bold'>{0}</span>",
								Catalog.GetString("Connection failed!"));
							RefreshButton.Sensitive = true;
							//PostEntry.Sensitive = true;
							menubar1.Sensitive = true;
						});
					}

					GLib.Timeout.Add (3000, new GLib.TimeoutHandler (ClearStatusbar));
				}
			}
			catch (NoSuchKeyException) {
				
				Gtk.Application.Invoke (delegate {
					Statusbar1.Push(0, Catalog.GetString("Connection failed!"));
					UserName.Markup = String.Format("<span size='large' weight='bold'>{0}</span>",
						Catalog.GetString("Connection failed!"));
					RefreshButton.Sensitive = true;
					//PostEntry.Sensitive = true;
				});
			}
		}
		
		//clear statusbar timeout
		bool ClearStatusbar()
		{
			Gtk.Application.Invoke (delegate {
				Statusbar1.Pop(0);
				Statusbar1.Pop(0);
				Statusbar1.Pop(0);
				Statusbar1.Pop(0);
			});
			
			return false;
		}
		
		//expose event, cairo/composite
		// FIXME: IMPORTANT! Fix this event so it compiles under Runtime 2.0 (gmcs)
		/*
		protected virtual void OnExposeEvent(object o, Gtk.ExposeEventArgs e)
		{
			
			if (MainClass.composite) {
				
				Gdk.Window window = e.Event.Window;
				//Gdk.Image image = e.Event.Window;
				Cairo.Context cr = Gdk.CairoHelper.Create (window);
				
				//need window sizes
				Int32 width, height;
				window.GetSize (out width, out height);
				
				compositeInterface.DrawComposite(cr, width, height);
			}
		}*/
		
		//window delete event - hides window
		protected void OnDeleteEvent (object sender, DeleteEventArgs a)
		{
			mainWindow.GetPosition(out x, out y);
			mainWindow.Hide();

			a.RetVal = true;
		}
		
		//quit button
		protected virtual void OnQuitButtonClicked(object o, EventArgs e)
		{	
			Application.Quit ();
			
			//abort Threads
			try {
				
				//store window position
				mainWindow.GetPosition(out x, out y);
				client.Set(WINDOW_X_KEY, x);
				client.Set(WINDOW_Y_KEY, y);
				client.Set(WINDOW_WIDTH_KEY, mainWindow.Allocation.Width);
				client.Set(WINDOW_HEIGHT_KEY, mainWindow.Allocation.Height);
				
				if (imageThread != null) {
					imageThread.Abort();
					imageThread = null;
				}
				if (getDataThread != null) {
					getDataThread.Abort();
					getDataThread = null;
				}
				if (refreshThread != null) {
					refreshThread.Abort();
					refreshThread = null;
				}
			} catch (Exception) { }
		}
		
		//post entry
		protected virtual void OnPostEntryActivated(object sender, System.EventArgs e)
		{
			PostEntry.Sensitive = false;
			RefreshButton.Sensitive = false;
			menubar1.Sensitive = false;
			
			try {
				getDataThread.Abort();
				refreshThread.Abort();
			} catch (Exception) { }
			
			postThread = new Thread(new ThreadStart(PostThreadRoutine));
			postThread.Start();
			
			//timeout 30seconds if it takes to much time, kill the thread
			//GLib.Timeout.Add (40000, new GLib.TimeoutHandler (TooLong));
		}
		
		//post thread routine
		public void PostThreadRoutine()
		{
			string post = PostEntry.Text;
			
			//trying to fix & character escaping
			//post = post.Replace("&amp;", "&");
			//Console.WriteLine("A " + post);
			
			string usernameKey = "";
			string passKey = "";
						
			try {
				usernameKey = (string) client.Get (USERNAME_KEY);
				passKey = (string) client.Get (PASSWORD_KEY);
				
				if (post.Length > 2) {
					
					Gtk.Application.Invoke (delegate {
						Statusbar1.Push(0, Catalog.GetString("Posting to Twitter..."));
					});
					
					//post to twitter
					if (!postToTwitter.PostDataToTwitter(TwitterPostUrl, usernameKey, passKey, post))
					{
						Gtk.Application.Invoke (delegate {
							Statusbar1.Push(0, Catalog.GetString("Posting failed!"));
						});
					}
					else {
						Gtk.Application.Invoke (delegate {
							Statusbar1.Push(0, Catalog.GetString("Successfully Posted!"));
						});
						GLib.Timeout.Add (2000, new GLib.TimeoutHandler (ClearStatusbar));
						
						//refresh data after post
						GLib.Timeout.Add (2200, new GLib.TimeoutHandler (RefreshAfterPost));
					}
					
				}
				else {
					Gtk.Application.Invoke (delegate {
						Statusbar1.Push(0, Catalog.GetString("At least write something :)"));
					});
					GLib.Timeout.Add (3000, new GLib.TimeoutHandler (ClearStatusbar));
				}
				
				PostEntry.Text = Catalog.GetString("What are you doing?");
				PostEntry.Sensitive = true;
				RefreshButton.Sensitive = true;
				menubar1.Sensitive = true;
			}
			catch (NoSuchKeyException) {
				
				Gtk.Application.Invoke (delegate {
					Statusbar1.Push(0, Catalog.GetString("Posting failed!"));
				});
			}
		}
		bool RefreshAfterPost()
		{
			Statusbar1.Push(0, Catalog.GetString("Connecting..."));
			refreshThread = new Thread(new ThreadStart(DataThreadRoutine));
	
			refreshThread.Start();

			return false;
		}
		
		//user button
		protected virtual void OnUserNameButtonClicked(object sender, System.EventArgs e)
		{
			//use gnome-open to open users home at twitter
			string cmdline = String.Format("gnome-open http://twitter.com/{0}", screenName);
		
			Process proc = Process.Start (cmdline);
		
			System.Threading.Thread.Sleep(250);
			proc.Close();
		}
		
		//entry "What are you doing?" text
		protected virtual void OnPostEntryFocusOutEvent(object o, Gtk.FocusOutEventArgs args)
		{
			if (PostEntry.Text.Length < 1)
				PostEntry.Text = Catalog.GetString("What are you doing?");
		}

		protected virtual void OnPostEntryFocusInEvent(object o, Gtk.FocusInEventArgs args)
		{
			if (PostEntry.Text.Length < 1 || PostEntry.Text.Equals("What are you doing?"))
				PostEntry.Text = "";
		}
		
		//140 characters counter
		protected virtual void OnPostEntryChanged(object sender, System.EventArgs e)
		{
			// don't know if I should add a Catalog.GetString here
			if (PostEntry.Text == "What are you doing?")
				StatusLabel.Markup = "<span foreground='gray'>140</span>";
			else
				StatusLabel.Markup = String.Format("<span foreground='gray'>{0}</span>", (140 - PostEntry.Text.Length).ToString());
		}

		//user details show when clicking on user image
		bool onceud = true;
		private UrlLabel urlLabel2 = new UrlLabel();
		protected virtual void OnEventbox1ButtonPressEvent(object o, Gtk.ButtonPressEventArgs args)
		{
			if (onceud) {

				table1.Attach(urlLabel2, 1, 2, 4, 5, AttachOptions.Fill, AttachOptions.Shrink, 0, 0);
				urlLabel2.Xalign = 0.0f;
				urlLabel2.Show();
				
				urlLabel2.UrlActivated += delegate(object obj, UrlActivatedArgs args2) {
					Process.Start("gnome-open", args2.Url);
				};
				
				onceud = false;
			}
			
			if (TopNotebook.Page == 0 && !Direct.Active) {
				
				TopNotebook.Page = 1;
				SetLabels();
			}
			else {
				
				TopNotebook.Page = 0;
				
				NameLabel.Text = "";
				ScreenNameLabel.Text = "";
				LocationLabel.Text = "";
				DescriptionLabel.Text = "";
				urlLabel2.Text = "";
			}
		}
		public void SetLabels() //set user detail labels
		{
			NameLabel.Markup = readInfo.name[navigation];
			ScreenNameLabel.Markup = readInfo.screenName[navigation];
			LocationLabel.Markup = readInfo.location[navigation];
			DescriptionLabel.Markup = readInfo.description[navigation];
			string urlString = readInfo.url[navigation];
			urlLabel2.Markup = String.Format("<a href=\"{0}\">{1}</a>", urlString, urlString);
			
			if (NameLabel.Text.Length < 2) {
				label1.Visible = false;
				NameLabel.Visible = false;
			}
			else {
				label1.Visible = true;
				NameLabel.Visible = true;
			}
			
			if (ScreenNameLabel.Text.Length < 2) {
				label2.Visible = false;
				ScreenNameLabel.Visible = false;
			}
			else {
				label2.Visible = true;
				ScreenNameLabel.Visible = true;
			}
			
			if (LocationLabel.Text.Length < 2) {
				label3.Visible = false;
				LocationLabel.Visible = false;
			}
			else {
				LocationLabel.Visible = true;
				label3.Visible = true;
			}
			
			if (DescriptionLabel.Text.Length < 2) {
				label4.Visible = false;
				DescriptionLabel.Visible = false;
			}
			else {
				label4.Visible = true;
				DescriptionLabel.Visible = true;
			}
			
			if (urlLabel2.Text.Length < 2) {
				label5.Visible = false;
				urlLabel2.Visible = false;
			}
			else {
				label5.Visible = true;
				urlLabel2.Visible = true;
			}
		}
		
		//screen name event
		protected virtual void OnUserNEventboxButtonPressEvent(object o, Gtk.ButtonPressEventArgs args)
		{
			if (!directM) {
				UserNLabel.Markup = screenName;
				directM = true;
			}
			else {
				UserNLabel.Markup = "<span foreground='gray'>" + screenName + "</span>";
				directM = true;
			}
				
		}


		//source radio buttons
		protected virtual void OnFriendsActivated(object sender, System.EventArgs e)
		{
			if (Friends.Active) {
				client.Set (SOURCE_KEY, 0);
				
				Source.Label = Friends.Label;
				
				readStoredData = new Thread(new ThreadStart(ReadStoredData));
				readStoredData.Start();
			}
		}
		protected virtual void OnPublicActivated(object sender, System.EventArgs e)
		{
			if (Public.Active) {
				client.Set (SOURCE_KEY, 1);
				
				Source.Label = Public.Label;
				
				readStoredData = new Thread(new ThreadStart(ReadStoredData));
				readStoredData.Start();
			}
		}
		protected virtual void OnDirectActivated(object sender, System.EventArgs e)
		{
			if (Direct.Active) {
				client.Set (SOURCE_KEY, 2);
				
				Source.Label = Direct.Label;
				
				readStoredData = new Thread(new ThreadStart(ReadStoredData));
				readStoredData.Start();
			}
		}
		
		protected virtual void OnTweetViewActivated(object sender, System.EventArgs e)
		{
			if (TweetView.Active) {
			
				client.Set(FANCY_UI_KEY, true);
				
				vpaned1.Child1.Visible = false;
				alignment1.TopPadding = 6;
				
				populateTreeview = new Thread(new ThreadStart(PopulateTreeviewThreadRoutine));
				//start thread
				populateTreeview.Start();
			}
			else {
			
				client.Set(FANCY_UI_KEY, false);

				vpaned1.Child1.Visible = true;
				alignment1.TopPadding = 0;
				
				populateTreeview = new Thread(new ThreadStart(PopulateTreeviewThreadRoutine));
				//start thread
				populateTreeview.Start();
			}
		}

		//focus post entry on window focus
		protected virtual void OnFocusInEvent(object o, Gtk.FocusInEventArgs args)
		{
			PostEntry.GrabFocus();
		}

		
		
	}
}

//ghaefb
