#!/bin/bash
PATH=/bin:/sbin:/usr/bin:/usr/sbin:/usr/local/sbin
FILTERSYS=0
if [ -e /sbin/ipchains ]; then
  FILTERSYS=1
fi;
if [ -e /usr/sbin/ipchains ]; then
  FILTERSYS=1
fi;
if [ -e /usr/local/sbin/ipchains ]; then
  FILTERSYS=1
fi;
if [ -e /proc/sys/kernel/osrelease ]; then
  if [ `sed "s/^\([0-9][0-9]*\.[0-9][0-9]*\).*\$/\1/" < /proc/sys/kernel/osrelease` == "2.4" ]; then
    if [ -e /sbin/iptables ]; then
      FILTERSYS=2
fi;
    if [ -e /usr/sbin/iptables ]; then
      FILTERSYS=2
    fi;
    if [ -e /usr/local/sbin/iptables ]; then
      FILTERSYS=2
    fi;
  fi;
fi;
if [ $FILTERSYS -eq 0 ]; then
  echo "ERROR Can't determine the firewall command! (Is ipchains or iptables installed?)"
fi;
if [ $FILTERSYS -eq 1 ]; then
  echo "Using ipchains."
  echo "Resetting firewall rules."
  ipchains -P output ACCEPT
  ipchains -P input ACCEPT
  ipchains -P forward ACCEPT
  ipchains -F forward
  ipchains -F input
  ipchains -F output
fi
if [ $FILTERSYS -eq 2 ]; then
  echo "Using iptables."
  echo "Resetting firewall rules."
  iptables -P OUTPUT ACCEPT
  iptables -P INPUT ACCEPT
  iptables -P FORWARD ACCEPT
  iptables -F FORWARD
  iptables -F INPUT
  iptables -F OUTPUT
fi;
echo "Finished."
