#ifndef GUESSNET_ENVIRONMENT_H
#define GUESSNET_ENVIRONMENT_H

/*
 * Common environment for most program functions
 *
 * Copyright (C) 2003  Enrico Zini <enrico@debian.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <string>
#include <vector>

#include "Environment.h"
#include "Parser.h"

class GuessnetEnvironment : public Environment
{
protected:
	// List of scans to perform
	std::vector<const Scan*> _scans;

	virtual void parseConfigFile() = 0;
	
public:
	static void init(int argc, const char* argv[]);
	static GuessnetEnvironment& get() throw ();
	const std::vector<const Scan*> scans() throw () { return _scans; }
};


// vim:set ts=4 sw=4:
#endif
